/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public final class AutofillServiceInfo {
    private static final String TAG = "AutofillServiceInfo";
    private final ServiceInfo mServiceInfo;
    private final String mSettingsActivity;

    private static ServiceInfo getServiceInfoOrThrow(ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = AppGlobals.getPackageManager().getServiceInfo(comp, 128, userHandle);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new PackageManager.NameNotFoundException(comp.toString());
    }

    public AutofillServiceInfo(PackageManager pm, ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        this(pm, AutofillServiceInfo.getServiceInfoOrThrow(comp, userHandle));
    }

    public AutofillServiceInfo(PackageManager pm, ServiceInfo si) {
        this.mServiceInfo = si;
        TypedArray metaDataArray = AutofillServiceInfo.getMetaDataArray(pm, si);
        if (metaDataArray != null) {
            this.mSettingsActivity = metaDataArray.getString(0);
            metaDataArray.recycle();
        } else {
            this.mSettingsActivity = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedArray getMetaDataArray(PackageManager pm, ServiceInfo si) {
        if (!"android.permission.BIND_AUTOFILL_SERVICE".equals(si.permission) && !"android.permission.BIND_AUTOFILL".equals(si.permission)) {
            Log.w(TAG, "AutofillService from '" + si.packageName + "' does not require permission " + "android.permission.BIND_AUTOFILL_SERVICE");
            throw new SecurityException("Service does not require permission android.permission.BIND_AUTOFILL_SERVICE");
        }
        XmlResourceParser parser = si.loadXmlMetaData(pm, "android.autofill");
        if (parser == null) {
            return null;
        }
        try {
            Resources res;
            try {
                int type;
                while ((type = parser.next()) != 1 && type != 2) {
                }
            }
            catch (IOException | XmlPullParserException e) {
                Log.e(TAG, "Error parsing auto fill service meta-data", e);
                TypedArray typedArray = null;
                parser.close();
                return typedArray;
            }
            if (!"autofill-service".equals(parser.getName())) {
                Log.e(TAG, "Meta-data does not start with autofill-service tag");
                TypedArray e = null;
                return e;
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            try {
                res = pm.getResourcesForApplication(si.applicationInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "Error getting application resources", e);
                TypedArray typedArray = null;
                parser.close();
                return typedArray;
            }
            TypedArray typedArray = res.obtainAttributes(attrs, R.styleable.AutofillService);
            return typedArray;
        }
        finally {
            parser.close();
        }
    }

    public ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivity;
    }

    public String toString() {
        return this.mServiceInfo == null ? "null" : this.mServiceInfo.toString();
    }
}

