/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.Service;
import android.content.Intent;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.RemoteException;
import android.service.autofill.FillCallback;
import android.service.autofill.FillEventHistory;
import android.service.autofill.FillRequest;
import android.service.autofill.IAutoFillService;
import android.service.autofill.IFillCallback;
import android.service.autofill.ISaveCallback;
import android.service.autofill.SaveCallback;
import android.service.autofill.SaveRequest;
import android.util.Log;
import android.view.autofill.AutofillManager;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;

public abstract class AutofillService
extends Service {
    private static final String TAG = "AutofillService";
    public static final String SERVICE_INTERFACE = "android.service.autofill.AutofillService";
    public static final String SERVICE_META_DATA = "android.autofill";
    private static final int MSG_CONNECT = 1;
    private static final int MSG_DISCONNECT = 2;
    private static final int MSG_ON_FILL_REQUEST = 3;
    private static final int MSG_ON_SAVE_REQUEST = 4;
    private final IAutoFillService mInterface = new IAutoFillService.Stub(){

        @Override
        public void onConnectedStateChanged(boolean connected) {
            if (connected) {
                AutofillService.this.mHandlerCaller.obtainMessage(1).sendToTarget();
            } else {
                AutofillService.this.mHandlerCaller.obtainMessage(2).sendToTarget();
            }
        }

        @Override
        public void onFillRequest(FillRequest request, IFillCallback callback) {
            ICancellationSignal transport = CancellationSignal.createTransport();
            try {
                callback.onCancellable(transport);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
            AutofillService.this.mHandlerCaller.obtainMessageOOO(3, request, CancellationSignal.fromTransport(transport), callback).sendToTarget();
        }

        @Override
        public void onSaveRequest(SaveRequest request, ISaveCallback callback) {
            AutofillService.this.mHandlerCaller.obtainMessageOO(4, request, callback).sendToTarget();
        }
    };
    private final HandlerCaller.Callback mHandlerCallback = msg -> {
        switch (msg.what) {
            case 1: {
                this.onConnected();
                break;
            }
            case 3: {
                SomeArgs args = (SomeArgs)msg.obj;
                FillRequest request = (FillRequest)args.arg1;
                CancellationSignal cancellation = (CancellationSignal)args.arg2;
                IFillCallback callback = (IFillCallback)args.arg3;
                FillCallback fillCallback = new FillCallback(callback, request.getId());
                args.recycle();
                this.onFillRequest(request, cancellation, fillCallback);
                break;
            }
            case 4: {
                SomeArgs args = (SomeArgs)msg.obj;
                SaveRequest request = (SaveRequest)args.arg1;
                ISaveCallback callback = (ISaveCallback)args.arg2;
                SaveCallback saveCallback = new SaveCallback(callback);
                args.recycle();
                this.onSaveRequest(request, saveCallback);
                break;
            }
            case 2: {
                this.onDisconnected();
                break;
            }
            default: {
                Log.w(TAG, "MyCallbacks received invalid message type: " + msg);
            }
        }
    };
    private HandlerCaller mHandlerCaller;

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandlerCaller = new HandlerCaller(null, Looper.getMainLooper(), this.mHandlerCallback, true);
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        Log.w(TAG, "Tried to bind to wrong intent: " + intent);
        return null;
    }

    public void onConnected() {
    }

    public abstract void onFillRequest(FillRequest var1, CancellationSignal var2, FillCallback var3);

    public abstract void onSaveRequest(SaveRequest var1, SaveCallback var2);

    public void onDisconnected() {
    }

    public final FillEventHistory getFillEventHistory() {
        AutofillManager afm = this.getSystemService(AutofillManager.class);
        if (afm == null) {
            return null;
        }
        return afm.getFillEventHistory();
    }
}

