/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.content.Context;
import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import com.android.org.conscrypt.TrustedCertificateIndex;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import libcore.io.IoUtils;

public class ResourceCertificateSource
implements CertificateSource {
    private final Object mLock = new Object();
    private final int mResourceId;
    private Set<X509Certificate> mCertificates;
    private Context mContext;
    private TrustedCertificateIndex mIndex;

    public ResourceCertificateSource(int resourceId, Context context) {
        this.mResourceId = resourceId;
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            Collection<? extends Certificate> certs;
            if (this.mCertificates != null) {
                return;
            }
            ArraySet<X509Certificate> certificates = new ArraySet<X509Certificate>();
            InputStream in = null;
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                in = this.mContext.getResources().openRawResource(this.mResourceId);
                certs = factory.generateCertificates(in);
            }
            catch (CertificateException e) {
                try {
                    throw new RuntimeException("Failed to load trust anchors from id " + this.mResourceId, e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(in);
            TrustedCertificateIndex indexLocal = new TrustedCertificateIndex();
            for (Certificate certificate : certs) {
                certificates.add((X509Certificate)certificate);
                indexLocal.index((X509Certificate)certificate);
            }
            this.mCertificates = certificates;
            this.mIndex = indexLocal;
            this.mContext = null;
        }
    }

    @Override
    public Set<X509Certificate> getCertificates() {
        this.ensureInitialized();
        return this.mCertificates;
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findBySubjectAndPublicKey(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findByIssuerAndSignature(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        Set<TrustAnchor> anchors = this.mIndex.findAllByIssuerAndSignature(cert);
        if (anchors.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>(anchors.size());
        for (TrustAnchor anchor : anchors) {
            certs.add(anchor.getTrustedCert());
        }
        return certs;
    }

    @Override
    public void handleTrustStorageUpdate() {
    }
}

