/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import com.android.org.conscrypt.TrustedCertificateIndex;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;

class KeyStoreCertificateSource
implements CertificateSource {
    private final Object mLock = new Object();
    private final KeyStore mKeyStore;
    private TrustedCertificateIndex mIndex;
    private Set<X509Certificate> mCertificates;

    public KeyStoreCertificateSource(KeyStore ks) {
        this.mKeyStore = ks;
    }

    @Override
    public Set<X509Certificate> getCertificates() {
        this.ensureInitialized();
        return this.mCertificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCertificates != null) {
                return;
            }
            try {
                TrustedCertificateIndex localIndex = new TrustedCertificateIndex();
                ArraySet<X509Certificate> certificates = new ArraySet<X509Certificate>(this.mKeyStore.size());
                Enumeration<String> en = this.mKeyStore.aliases();
                while (en.hasMoreElements()) {
                    String alias = en.nextElement();
                    X509Certificate cert = (X509Certificate)this.mKeyStore.getCertificate(alias);
                    if (cert == null) continue;
                    certificates.add(cert);
                    localIndex.index(cert);
                }
                this.mIndex = localIndex;
                this.mCertificates = certificates;
            }
            catch (KeyStoreException e) {
                throw new RuntimeException("Failed to load certificates from KeyStore", e);
            }
        }
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findBySubjectAndPublicKey(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findByIssuerAndSignature(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        Set<TrustAnchor> anchors = this.mIndex.findAllByIssuerAndSignature(cert);
        if (anchors.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>(anchors.size());
        for (TrustAnchor anchor : anchors) {
            certs.add(anchor.getTrustedCert());
        }
        return certs;
    }

    @Override
    public void handleTrustStorageUpdate() {
    }
}

