/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.OperationResult;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.KeyStoreConnectException;
import android.security.keystore.KeyStoreCryptoOperation;
import android.security.keystore.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore.KeyStoreCryptoOperationUtils;
import android.security.keystore.KeymasterUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

public abstract class AndroidKeyStoreHmacSpi
extends MacSpi
implements KeyStoreCryptoOperation {
    private final KeyStore mKeyStore = KeyStore.getInstance();
    private final int mKeymasterDigest;
    private final int mMacSizeBits;
    private AndroidKeyStoreSecretKey mKey;
    private KeyStoreCryptoOperationChunkedStreamer mChunkedStreamer;
    private IBinder mOperationToken;
    private long mOperationHandle;

    protected AndroidKeyStoreHmacSpi(int keymasterDigest) {
        this.mKeymasterDigest = keymasterDigest;
        this.mMacSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
    }

    @Override
    protected int engineGetMacLength() {
        return (this.mMacSizeBits + 7) / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.resetAll();
        boolean success = false;
        try {
            this.init(key, params);
            this.ensureKeystoreOperationInitialized();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    private void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("Only Android KeyStore secret keys supported. Key: " + key);
        }
        this.mKey = (AndroidKeyStoreSecretKey)key;
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + params);
        }
    }

    private void resetAll() {
        this.mKey = null;
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mKeyStore.abort(operationToken);
        }
        this.mOperationToken = null;
        this.mOperationHandle = 0L;
        this.mChunkedStreamer = null;
    }

    private void resetWhilePreservingInitState() {
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mKeyStore.abort(operationToken);
        }
        this.mOperationToken = null;
        this.mOperationHandle = 0L;
        this.mChunkedStreamer = null;
    }

    @Override
    protected void engineReset() {
        this.resetWhilePreservingInitState();
    }

    private void ensureKeystoreOperationInitialized() throws InvalidKeyException {
        if (this.mChunkedStreamer != null) {
            return;
        }
        if (this.mKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        KeymasterArguments keymasterArgs = new KeymasterArguments();
        keymasterArgs.addEnum(0x10000002, 128);
        keymasterArgs.addEnum(0x20000005, this.mKeymasterDigest);
        keymasterArgs.addUnsignedInt(805307371, this.mMacSizeBits);
        OperationResult opResult = this.mKeyStore.begin(this.mKey.getAlias(), 2, true, keymasterArgs, null, this.mKey.getUid());
        if (opResult == null) {
            throw new KeyStoreConnectException();
        }
        this.mOperationToken = opResult.token;
        this.mOperationHandle = opResult.operationHandle;
        InvalidKeyException e = KeyStoreCryptoOperationUtils.getInvalidKeyExceptionForInit(this.mKeyStore, this.mKey, opResult.resultCode);
        if (e != null) {
            throw e;
        }
        if (this.mOperationToken == null) {
            throw new ProviderException("Keystore returned null operation token");
        }
        if (this.mOperationHandle == 0L) {
            throw new ProviderException("Keystore returned invalid operation handle");
        }
        this.mChunkedStreamer = new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(this.mKeyStore, this.mOperationToken));
    }

    @Override
    protected void engineUpdate(byte input) {
        this.engineUpdate(new byte[]{input}, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        byte[] output;
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new ProviderException("Failed to reinitialize MAC", e);
        }
        try {
            output = this.mChunkedStreamer.update(input, offset, len);
        }
        catch (KeyStoreException e) {
            throw new ProviderException("Keystore operation failed", e);
        }
        if (output != null && output.length != 0) {
            throw new ProviderException("Update operation unexpectedly produced output");
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        byte[] result;
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new ProviderException("Failed to reinitialize MAC", e);
        }
        try {
            result = this.mChunkedStreamer.doFinal(null, 0, 0, null, null);
        }
        catch (KeyStoreException e) {
            throw new ProviderException("Keystore operation failed", e);
        }
        this.resetWhilePreservingInitState();
        return result;
    }

    public void finalize() throws Throwable {
        try {
            IBinder operationToken = this.mOperationToken;
            if (operationToken != null) {
                this.mKeyStore.abort(operationToken);
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public long getOperationHandle() {
        return this.mOperationHandle;
    }

    public static class HmacSHA512
    extends AndroidKeyStoreHmacSpi {
        public HmacSHA512() {
            super(6);
        }
    }

    public static class HmacSHA384
    extends AndroidKeyStoreHmacSpi {
        public HmacSHA384() {
            super(5);
        }
    }

    public static class HmacSHA256
    extends AndroidKeyStoreHmacSpi {
        public HmacSHA256() {
            super(4);
        }
    }

    public static class HmacSHA224
    extends AndroidKeyStoreHmacSpi {
        public HmacSHA224() {
            super(3);
        }
    }

    public static class HmacSHA1
    extends AndroidKeyStoreHmacSpi {
        public HmacSHA1() {
            super(2);
        }
    }
}

