/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.CursorEntityIterator;
import android.content.Entity;
import android.content.EntityIterator;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.BaseColumns;
import android.provider.SyncStateContract;

public final class CalendarContract {
    private static final String TAG = "Calendar";
    public static final String ACTION_EVENT_REMINDER = "android.intent.action.EVENT_REMINDER";
    public static final String ACTION_HANDLE_CUSTOM_EVENT = "android.provider.calendar.action.HANDLE_CUSTOM_EVENT";
    public static final String EXTRA_CUSTOM_APP_URI = "customAppUri";
    public static final String EXTRA_EVENT_BEGIN_TIME = "beginTime";
    public static final String EXTRA_EVENT_END_TIME = "endTime";
    public static final String EXTRA_EVENT_ALL_DAY = "allDay";
    public static final String AUTHORITY = "com.android.calendar";
    public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar");
    public static final String CALLER_IS_SYNCADAPTER = "caller_is_syncadapter";
    public static final String ACCOUNT_TYPE_LOCAL = "LOCAL";

    private CalendarContract() {
    }

    public static final class EventsRawTimes
    implements BaseColumns,
    EventsRawTimesColumns {
        private EventsRawTimes() {
        }
    }

    protected static interface EventsRawTimesColumns {
        public static final String EVENT_ID = "event_id";
        public static final String DTSTART_2445 = "dtstart2445";
        public static final String DTEND_2445 = "dtend2445";
        public static final String ORIGINAL_INSTANCE_TIME_2445 = "originalInstanceTime2445";
        public static final String LAST_DATE_2445 = "lastDate2445";
    }

    public static final class SyncState
    implements SyncStateContract.Columns {
        private static final String CONTENT_DIRECTORY = "syncstate";
        public static final Uri CONTENT_URI = Uri.withAppendedPath(CONTENT_URI, "syncstate");

        private SyncState() {
        }
    }

    public static final class ExtendedProperties
    implements BaseColumns,
    ExtendedPropertiesColumns,
    EventsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/extendedproperties");

        private ExtendedProperties() {
        }
    }

    protected static interface ExtendedPropertiesColumns {
        public static final String EVENT_ID = "event_id";
        public static final String NAME = "name";
        public static final String VALUE = "value";
    }

    public static final class Colors
    implements ColorsColumns {
        public static final String TABLE_NAME = "Colors";
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/colors");

        private Colors() {
        }
    }

    protected static interface ColorsColumns
    extends SyncStateContract.Columns {
        public static final String COLOR_TYPE = "color_type";
        public static final int TYPE_CALENDAR = 0;
        public static final int TYPE_EVENT = 1;
        public static final String COLOR_KEY = "color_index";
        public static final String COLOR = "color";
    }

    public static final class CalendarAlerts
    implements BaseColumns,
    CalendarAlertsColumns,
    EventsColumns,
    CalendarColumns {
        public static final String TABLE_NAME = "CalendarAlerts";
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/calendar_alerts");
        private static final String WHERE_ALARM_EXISTS = "event_id=? AND begin=? AND alarmTime=?";
        private static final String WHERE_FINDNEXTALARMTIME = "alarmTime>=?";
        private static final String SORT_ORDER_ALARMTIME_ASC = "alarmTime ASC";
        private static final String WHERE_RESCHEDULE_MISSED_ALARMS = "state=0 AND alarmTime<? AND alarmTime>? AND end>=?";
        public static final Uri CONTENT_URI_BY_INSTANCE = Uri.parse("content://com.android.calendar/calendar_alerts/by_instance");
        private static final boolean DEBUG = false;

        private CalendarAlerts() {
        }

        public static final Uri insert(ContentResolver cr, long eventId, long begin, long end, long alarmTime, int minutes) {
            ContentValues values = new ContentValues();
            values.put("event_id", eventId);
            values.put("begin", begin);
            values.put("end", end);
            values.put("alarmTime", alarmTime);
            long currentTime = System.currentTimeMillis();
            values.put("creationTime", currentTime);
            values.put("receivedTime", 0);
            values.put("notifyTime", 0);
            values.put("state", 0);
            values.put("minutes", minutes);
            return cr.insert(CONTENT_URI, values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final long findNextAlarmTime(ContentResolver cr, long millis) {
            String selection = "alarmTime>=" + millis;
            String[] projection = new String[]{"alarmTime"};
            long alarmTime = -1L;
            try (Cursor cursor = cr.query(CONTENT_URI, projection, WHERE_FINDNEXTALARMTIME, new String[]{Long.toString(millis)}, SORT_ORDER_ALARMTIME_ASC);){
                if (cursor != null && cursor.moveToFirst()) {
                    alarmTime = cursor.getLong(0);
                }
            }
            return alarmTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final void rescheduleMissedAlarms(ContentResolver cr, Context context, AlarmManager manager) {
            long now = System.currentTimeMillis();
            long ancient = now - 86400000L;
            String[] projection = new String[]{"alarmTime"};
            Cursor cursor = cr.query(CONTENT_URI, projection, WHERE_RESCHEDULE_MISSED_ALARMS, new String[]{Long.toString(now), Long.toString(ancient), Long.toString(now)}, SORT_ORDER_ALARMTIME_ASC);
            if (cursor == null) {
                return;
            }
            try {
                long alarmTime = -1L;
                while (cursor.moveToNext()) {
                    long newAlarmTime = cursor.getLong(0);
                    if (alarmTime == newAlarmTime) continue;
                    CalendarAlerts.scheduleAlarm(context, manager, newAlarmTime);
                    alarmTime = newAlarmTime;
                }
            }
            finally {
                cursor.close();
            }
        }

        public static void scheduleAlarm(Context context, AlarmManager manager, long alarmTime) {
            if (manager == null) {
                manager = (AlarmManager)context.getSystemService("alarm");
            }
            Intent intent = new Intent(CalendarContract.ACTION_EVENT_REMINDER);
            intent.setData(ContentUris.withAppendedId(CONTENT_URI, alarmTime));
            intent.putExtra("alarmTime", alarmTime);
            intent.setFlags(0x1000000);
            PendingIntent pi = PendingIntent.getBroadcast(context, 0, intent, 0);
            manager.setExactAndAllowWhileIdle(0, alarmTime, pi);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final boolean alarmExists(ContentResolver cr, long eventId, long begin, long alarmTime) {
            String[] projection = new String[]{"alarmTime"};
            boolean found = false;
            try (Cursor cursor = cr.query(CONTENT_URI, projection, WHERE_ALARM_EXISTS, new String[]{Long.toString(eventId), Long.toString(begin), Long.toString(alarmTime)}, null);){
                if (cursor != null && cursor.getCount() > 0) {
                    found = true;
                }
            }
            return found;
        }
    }

    protected static interface CalendarAlertsColumns {
        public static final String EVENT_ID = "event_id";
        public static final String BEGIN = "begin";
        public static final String END = "end";
        public static final String ALARM_TIME = "alarmTime";
        public static final String CREATION_TIME = "creationTime";
        public static final String RECEIVED_TIME = "receivedTime";
        public static final String NOTIFY_TIME = "notifyTime";
        public static final String STATE = "state";
        public static final int STATE_SCHEDULED = 0;
        public static final int STATE_FIRED = 1;
        public static final int STATE_DISMISSED = 2;
        public static final String MINUTES = "minutes";
        public static final String DEFAULT_SORT_ORDER = "begin ASC,title ASC";
    }

    public static final class Reminders
    implements BaseColumns,
    RemindersColumns,
    EventsColumns {
        private static final String REMINDERS_WHERE = "event_id=?";
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/reminders");

        private Reminders() {
        }

        public static final Cursor query(ContentResolver cr, long eventId, String[] projection) {
            String[] remArgs = new String[]{Long.toString(eventId)};
            return cr.query(CONTENT_URI, projection, REMINDERS_WHERE, remArgs, null);
        }
    }

    protected static interface RemindersColumns {
        public static final String EVENT_ID = "event_id";
        public static final String MINUTES = "minutes";
        public static final int MINUTES_DEFAULT = -1;
        public static final String METHOD = "method";
        public static final int METHOD_DEFAULT = 0;
        public static final int METHOD_ALERT = 1;
        public static final int METHOD_EMAIL = 2;
        public static final int METHOD_SMS = 3;
        public static final int METHOD_ALARM = 4;
    }

    public static final class EventDays
    implements EventDaysColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/instances/groupbyday");
        private static final String SELECTION = "selected=1";

        private EventDays() {
        }

        public static final Cursor query(ContentResolver cr, int startDay, int numDays, String[] projection) {
            if (numDays < 1) {
                return null;
            }
            int endDay = startDay + numDays - 1;
            Uri.Builder builder = CONTENT_URI.buildUpon();
            ContentUris.appendId(builder, startDay);
            ContentUris.appendId(builder, endDay);
            return cr.query(builder.build(), projection, SELECTION, null, "startDay");
        }
    }

    protected static interface EventDaysColumns {
        public static final String STARTDAY = "startDay";
        public static final String ENDDAY = "endDay";
    }

    public static final class CalendarMetaData
    implements CalendarMetaDataColumns,
    BaseColumns {
        private CalendarMetaData() {
        }
    }

    protected static interface CalendarMetaDataColumns {
        public static final String LOCAL_TIMEZONE = "localTimezone";
        public static final String MIN_INSTANCE = "minInstance";
        public static final String MAX_INSTANCE = "maxInstance";
        public static final String MIN_EVENTDAYS = "minEventDays";
        public static final String MAX_EVENTDAYS = "maxEventDays";
    }

    public static final class CalendarCache
    implements CalendarCacheColumns {
        public static final Uri URI = Uri.parse("content://com.android.calendar/properties");
        public static final String KEY_TIMEZONE_TYPE = "timezoneType";
        public static final String KEY_TIMEZONE_INSTANCES = "timezoneInstances";
        public static final String KEY_TIMEZONE_INSTANCES_PREVIOUS = "timezoneInstancesPrevious";
        public static final String TIMEZONE_TYPE_AUTO = "auto";
        public static final String TIMEZONE_TYPE_HOME = "home";

        private CalendarCache() {
        }
    }

    protected static interface CalendarCacheColumns {
        public static final String KEY = "key";
        public static final String VALUE = "value";
    }

    public static final class Instances
    implements BaseColumns,
    EventsColumns,
    CalendarColumns {
        private static final String WHERE_CALENDARS_SELECTED = "visible=?";
        private static final String[] WHERE_CALENDARS_ARGS = new String[]{"1"};
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/instances/when");
        public static final Uri CONTENT_BY_DAY_URI = Uri.parse("content://com.android.calendar/instances/whenbyday");
        public static final Uri CONTENT_SEARCH_URI = Uri.parse("content://com.android.calendar/instances/search");
        public static final Uri CONTENT_SEARCH_BY_DAY_URI = Uri.parse("content://com.android.calendar/instances/searchbyday");
        private static final String DEFAULT_SORT_ORDER = "begin ASC";
        public static final String BEGIN = "begin";
        public static final String END = "end";
        public static final String EVENT_ID = "event_id";
        public static final String START_DAY = "startDay";
        public static final String END_DAY = "endDay";
        public static final String START_MINUTE = "startMinute";
        public static final String END_MINUTE = "endMinute";

        private Instances() {
        }

        public static final Cursor query(ContentResolver cr, String[] projection, long begin, long end) {
            Uri.Builder builder = CONTENT_URI.buildUpon();
            ContentUris.appendId(builder, begin);
            ContentUris.appendId(builder, end);
            return cr.query(builder.build(), projection, WHERE_CALENDARS_SELECTED, WHERE_CALENDARS_ARGS, DEFAULT_SORT_ORDER);
        }

        public static final Cursor query(ContentResolver cr, String[] projection, long begin, long end, String searchQuery) {
            Uri.Builder builder = CONTENT_SEARCH_URI.buildUpon();
            ContentUris.appendId(builder, begin);
            ContentUris.appendId(builder, end);
            builder = builder.appendPath(searchQuery);
            return cr.query(builder.build(), projection, WHERE_CALENDARS_SELECTED, WHERE_CALENDARS_ARGS, DEFAULT_SORT_ORDER);
        }
    }

    public static final class Events
    implements BaseColumns,
    SyncColumns,
    EventsColumns,
    CalendarColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/events");
        public static final Uri CONTENT_EXCEPTION_URI = Uri.parse("content://com.android.calendar/exception");
        private static final String DEFAULT_SORT_ORDER = "";
        public static String[] PROVIDER_WRITABLE_COLUMNS = new String[]{"account_name", "account_type", "cal_sync1", "cal_sync2", "cal_sync3", "cal_sync4", "cal_sync5", "cal_sync6", "cal_sync7", "cal_sync8", "cal_sync9", "cal_sync10", "allowedReminders", "allowedAttendeeTypes", "allowedAvailability", "calendar_access_level", "calendar_color", "calendar_timezone", "canModifyTimeZone", "canOrganizerRespond", "calendar_displayName", "canPartiallyUpdate", "sync_events", "visible"};
        public static final String[] SYNC_WRITABLE_COLUMNS = new String[]{"_sync_id", "dirty", "mutators", "sync_data1", "sync_data2", "sync_data3", "sync_data4", "sync_data5", "sync_data6", "sync_data7", "sync_data8", "sync_data9", "sync_data10"};

        private Events() {
        }
    }

    public static final class EventsEntity
    implements BaseColumns,
    SyncColumns,
    EventsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/event_entities");

        private EventsEntity() {
        }

        public static EntityIterator newEntityIterator(Cursor cursor, ContentResolver resolver) {
            return new EntityIteratorImpl(cursor, resolver);
        }

        public static EntityIterator newEntityIterator(Cursor cursor, ContentProviderClient provider) {
            return new EntityIteratorImpl(cursor, provider);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            private final ContentResolver mResolver;
            private final ContentProviderClient mProvider;
            private static final String[] REMINDERS_PROJECTION = new String[]{"minutes", "method"};
            private static final int COLUMN_MINUTES = 0;
            private static final int COLUMN_METHOD = 1;
            private static final String[] ATTENDEES_PROJECTION = new String[]{"attendeeName", "attendeeEmail", "attendeeRelationship", "attendeeType", "attendeeStatus", "attendeeIdentity", "attendeeIdNamespace"};
            private static final int COLUMN_ATTENDEE_NAME = 0;
            private static final int COLUMN_ATTENDEE_EMAIL = 1;
            private static final int COLUMN_ATTENDEE_RELATIONSHIP = 2;
            private static final int COLUMN_ATTENDEE_TYPE = 3;
            private static final int COLUMN_ATTENDEE_STATUS = 4;
            private static final int COLUMN_ATTENDEE_IDENTITY = 5;
            private static final int COLUMN_ATTENDEE_ID_NAMESPACE = 6;
            private static final String[] EXTENDED_PROJECTION = new String[]{"_id", "name", "value"};
            private static final int COLUMN_ID = 0;
            private static final int COLUMN_NAME = 1;
            private static final int COLUMN_VALUE = 2;
            private static final String WHERE_EVENT_ID = "event_id=?";

            public EntityIteratorImpl(Cursor cursor, ContentResolver resolver) {
                super(cursor);
                this.mResolver = resolver;
                this.mProvider = null;
            }

            public EntityIteratorImpl(Cursor cursor, ContentProviderClient provider) {
                super(cursor);
                this.mResolver = null;
                this.mProvider = provider;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                long eventId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                ContentValues cv = new ContentValues();
                cv.put("_id", eventId);
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "calendar_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "title");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "description");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventLocation");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "eventStatus");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "selfAttendeeStatus");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dtstart");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dtend");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "duration");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventTimezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventEndTimezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, CalendarContract.EXTRA_EVENT_ALL_DAY);
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "accessLevel");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "availability");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "eventColor");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "eventColor_index");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "hasAlarm");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "hasExtendedProperties");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "rrule");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "rdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "exrule");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "exdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "original_sync_id");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "original_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "originalInstanceTime");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "originalAllDay");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "lastDate");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "hasAttendeeData");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "guestsCanInviteOthers");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "guestsCanModify");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "guestsCanSeeGuests");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "customAppPackage");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, CalendarContract.EXTRA_CUSTOM_APP_URI);
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "uid2445");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "organizer");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "isOrganizer");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "_sync_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dirty");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "mutators");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "lastSynced");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "deleted");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data5");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data6");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data7");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data8");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data9");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "sync_data10");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync5");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync6");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync7");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync8");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync9");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync10");
                Entity entity = new Entity(cv);
                try (Cursor subCursor = this.mResolver != null ? this.mResolver.query(Reminders.CONTENT_URI, REMINDERS_PROJECTION, WHERE_EVENT_ID, new String[]{Long.toString(eventId)}, null) : this.mProvider.query(Reminders.CONTENT_URI, REMINDERS_PROJECTION, WHERE_EVENT_ID, new String[]{Long.toString(eventId)}, null);){
                    while (subCursor.moveToNext()) {
                        ContentValues reminderValues = new ContentValues();
                        reminderValues.put("minutes", subCursor.getInt(0));
                        reminderValues.put("method", subCursor.getInt(1));
                        entity.addSubValue(Reminders.CONTENT_URI, reminderValues);
                    }
                }
                subCursor = this.mResolver != null ? this.mResolver.query(Attendees.CONTENT_URI, ATTENDEES_PROJECTION, WHERE_EVENT_ID, new String[]{Long.toString(eventId)}, null) : this.mProvider.query(Attendees.CONTENT_URI, ATTENDEES_PROJECTION, WHERE_EVENT_ID, new String[]{Long.toString(eventId)}, null);
                try {
                    while (subCursor.moveToNext()) {
                        ContentValues attendeeValues = new ContentValues();
                        attendeeValues.put("attendeeName", subCursor.getString(0));
                        attendeeValues.put("attendeeEmail", subCursor.getString(1));
                        attendeeValues.put("attendeeRelationship", subCursor.getInt(2));
                        attendeeValues.put("attendeeType", subCursor.getInt(3));
                        attendeeValues.put("attendeeStatus", subCursor.getInt(4));
                        attendeeValues.put("attendeeIdentity", subCursor.getString(5));
                        attendeeValues.put("attendeeIdNamespace", subCursor.getString(6));
                        entity.addSubValue(Attendees.CONTENT_URI, attendeeValues);
                    }
                }
                finally {
                    subCursor.close();
                }
                subCursor = this.mResolver != null ? this.mResolver.query(ExtendedProperties.CONTENT_URI, EXTENDED_PROJECTION, WHERE_EVENT_ID, new String[]{Long.toString(eventId)}, null) : this.mProvider.query(ExtendedProperties.CONTENT_URI, EXTENDED_PROJECTION, WHERE_EVENT_ID, new String[]{Long.toString(eventId)}, null);
                try {
                    while (subCursor.moveToNext()) {
                        ContentValues extendedValues = new ContentValues();
                        extendedValues.put("_id", subCursor.getString(0));
                        extendedValues.put("name", subCursor.getString(1));
                        extendedValues.put("value", subCursor.getString(2));
                        entity.addSubValue(ExtendedProperties.CONTENT_URI, extendedValues);
                    }
                }
                finally {
                    subCursor.close();
                }
                cursor.moveToNext();
                return entity;
            }
        }
    }

    protected static interface EventsColumns {
        public static final String CALENDAR_ID = "calendar_id";
        public static final String TITLE = "title";
        public static final String DESCRIPTION = "description";
        public static final String EVENT_LOCATION = "eventLocation";
        public static final String EVENT_COLOR = "eventColor";
        public static final String EVENT_COLOR_KEY = "eventColor_index";
        public static final String DISPLAY_COLOR = "displayColor";
        public static final String STATUS = "eventStatus";
        public static final int STATUS_TENTATIVE = 0;
        public static final int STATUS_CONFIRMED = 1;
        public static final int STATUS_CANCELED = 2;
        public static final String SELF_ATTENDEE_STATUS = "selfAttendeeStatus";
        public static final String SYNC_DATA1 = "sync_data1";
        public static final String SYNC_DATA2 = "sync_data2";
        public static final String SYNC_DATA3 = "sync_data3";
        public static final String SYNC_DATA4 = "sync_data4";
        public static final String SYNC_DATA5 = "sync_data5";
        public static final String SYNC_DATA6 = "sync_data6";
        public static final String SYNC_DATA7 = "sync_data7";
        public static final String SYNC_DATA8 = "sync_data8";
        public static final String SYNC_DATA9 = "sync_data9";
        public static final String SYNC_DATA10 = "sync_data10";
        public static final String LAST_SYNCED = "lastSynced";
        public static final String DTSTART = "dtstart";
        public static final String DTEND = "dtend";
        public static final String DURATION = "duration";
        public static final String EVENT_TIMEZONE = "eventTimezone";
        public static final String EVENT_END_TIMEZONE = "eventEndTimezone";
        public static final String ALL_DAY = "allDay";
        public static final String ACCESS_LEVEL = "accessLevel";
        public static final int ACCESS_DEFAULT = 0;
        public static final int ACCESS_CONFIDENTIAL = 1;
        public static final int ACCESS_PRIVATE = 2;
        public static final int ACCESS_PUBLIC = 3;
        public static final String AVAILABILITY = "availability";
        public static final int AVAILABILITY_BUSY = 0;
        public static final int AVAILABILITY_FREE = 1;
        public static final int AVAILABILITY_TENTATIVE = 2;
        public static final String HAS_ALARM = "hasAlarm";
        public static final String HAS_EXTENDED_PROPERTIES = "hasExtendedProperties";
        public static final String RRULE = "rrule";
        public static final String RDATE = "rdate";
        public static final String EXRULE = "exrule";
        public static final String EXDATE = "exdate";
        public static final String ORIGINAL_ID = "original_id";
        public static final String ORIGINAL_SYNC_ID = "original_sync_id";
        public static final String ORIGINAL_INSTANCE_TIME = "originalInstanceTime";
        public static final String ORIGINAL_ALL_DAY = "originalAllDay";
        public static final String LAST_DATE = "lastDate";
        public static final String HAS_ATTENDEE_DATA = "hasAttendeeData";
        public static final String GUESTS_CAN_MODIFY = "guestsCanModify";
        public static final String GUESTS_CAN_INVITE_OTHERS = "guestsCanInviteOthers";
        public static final String GUESTS_CAN_SEE_GUESTS = "guestsCanSeeGuests";
        public static final String ORGANIZER = "organizer";
        public static final String IS_ORGANIZER = "isOrganizer";
        public static final String CAN_INVITE_OTHERS = "canInviteOthers";
        public static final String CUSTOM_APP_PACKAGE = "customAppPackage";
        public static final String CUSTOM_APP_URI = "customAppUri";
        public static final String UID_2445 = "uid2445";
    }

    public static final class Attendees
    implements BaseColumns,
    AttendeesColumns,
    EventsColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/attendees");
        private static final String ATTENDEES_WHERE = "event_id=?";

        private Attendees() {
        }

        public static final Cursor query(ContentResolver cr, long eventId, String[] projection) {
            String[] attArgs = new String[]{Long.toString(eventId)};
            return cr.query(CONTENT_URI, projection, ATTENDEES_WHERE, attArgs, null);
        }
    }

    protected static interface AttendeesColumns {
        public static final String EVENT_ID = "event_id";
        public static final String ATTENDEE_NAME = "attendeeName";
        public static final String ATTENDEE_EMAIL = "attendeeEmail";
        public static final String ATTENDEE_RELATIONSHIP = "attendeeRelationship";
        public static final int RELATIONSHIP_NONE = 0;
        public static final int RELATIONSHIP_ATTENDEE = 1;
        public static final int RELATIONSHIP_ORGANIZER = 2;
        public static final int RELATIONSHIP_PERFORMER = 3;
        public static final int RELATIONSHIP_SPEAKER = 4;
        public static final String ATTENDEE_TYPE = "attendeeType";
        public static final int TYPE_NONE = 0;
        public static final int TYPE_REQUIRED = 1;
        public static final int TYPE_OPTIONAL = 2;
        public static final int TYPE_RESOURCE = 3;
        public static final String ATTENDEE_STATUS = "attendeeStatus";
        public static final int ATTENDEE_STATUS_NONE = 0;
        public static final int ATTENDEE_STATUS_ACCEPTED = 1;
        public static final int ATTENDEE_STATUS_DECLINED = 2;
        public static final int ATTENDEE_STATUS_INVITED = 3;
        public static final int ATTENDEE_STATUS_TENTATIVE = 4;
        public static final String ATTENDEE_IDENTITY = "attendeeIdentity";
        public static final String ATTENDEE_ID_NAMESPACE = "attendeeIdNamespace";
    }

    public static final class Calendars
    implements BaseColumns,
    SyncColumns,
    CalendarColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/calendars");
        public static final String DEFAULT_SORT_ORDER = "calendar_displayName";
        public static final String NAME = "name";
        public static final String CALENDAR_LOCATION = "calendar_location";
        public static final String[] SYNC_WRITABLE_COLUMNS = new String[]{"account_name", "account_type", "_sync_id", "dirty", "mutators", "ownerAccount", "maxReminders", "allowedReminders", "canModifyTimeZone", "canOrganizerRespond", "canPartiallyUpdate", "calendar_location", "calendar_timezone", "calendar_access_level", "deleted", "cal_sync1", "cal_sync2", "cal_sync3", "cal_sync4", "cal_sync5", "cal_sync6", "cal_sync7", "cal_sync8", "cal_sync9", "cal_sync10"};

        private Calendars() {
        }
    }

    public static final class CalendarEntity
    implements BaseColumns,
    SyncColumns,
    CalendarColumns {
        public static final Uri CONTENT_URI = Uri.parse("content://com.android.calendar/calendar_entities");

        private CalendarEntity() {
        }

        public static EntityIterator newEntityIterator(Cursor cursor) {
            return new EntityIteratorImpl(cursor);
        }

        private static class EntityIteratorImpl
        extends CursorEntityIterator {
            public EntityIteratorImpl(Cursor cursor) {
                super(cursor);
            }

            @Override
            public Entity getEntityAndIncrementCursor(Cursor cursor) throws RemoteException {
                long calendarId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                ContentValues cv = new ContentValues();
                cv.put("_id", calendarId);
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "account_type");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "_sync_id");
                DatabaseUtils.cursorLongToContentValuesIfPresent(cursor, cv, "dirty");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "mutators");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync1");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync2");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync3");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync4");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync5");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync6");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync7");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync8");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync9");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "cal_sync10");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "name");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_displayName");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "calendar_color");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_color_index");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "calendar_access_level");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "visible");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "sync_events");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_location");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "calendar_timezone");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "ownerAccount");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "canOrganizerRespond");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "canModifyTimeZone");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "maxReminders");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "canPartiallyUpdate");
                DatabaseUtils.cursorStringToContentValuesIfPresent(cursor, cv, "allowedReminders");
                DatabaseUtils.cursorIntToContentValuesIfPresent(cursor, cv, "deleted");
                Entity entity = new Entity(cv);
                cursor.moveToNext();
                return entity;
            }
        }
    }

    protected static interface CalendarColumns {
        public static final String CALENDAR_COLOR = "calendar_color";
        public static final String CALENDAR_COLOR_KEY = "calendar_color_index";
        public static final String CALENDAR_DISPLAY_NAME = "calendar_displayName";
        public static final String CALENDAR_ACCESS_LEVEL = "calendar_access_level";
        public static final int CAL_ACCESS_NONE = 0;
        public static final int CAL_ACCESS_FREEBUSY = 100;
        public static final int CAL_ACCESS_READ = 200;
        public static final int CAL_ACCESS_RESPOND = 300;
        public static final int CAL_ACCESS_OVERRIDE = 400;
        public static final int CAL_ACCESS_CONTRIBUTOR = 500;
        public static final int CAL_ACCESS_EDITOR = 600;
        public static final int CAL_ACCESS_OWNER = 700;
        public static final int CAL_ACCESS_ROOT = 800;
        public static final String VISIBLE = "visible";
        public static final String CALENDAR_TIME_ZONE = "calendar_timezone";
        public static final String SYNC_EVENTS = "sync_events";
        public static final String OWNER_ACCOUNT = "ownerAccount";
        public static final String CAN_ORGANIZER_RESPOND = "canOrganizerRespond";
        public static final String CAN_MODIFY_TIME_ZONE = "canModifyTimeZone";
        public static final String MAX_REMINDERS = "maxReminders";
        public static final String ALLOWED_REMINDERS = "allowedReminders";
        public static final String ALLOWED_AVAILABILITY = "allowedAvailability";
        public static final String ALLOWED_ATTENDEE_TYPES = "allowedAttendeeTypes";
        public static final String IS_PRIMARY = "isPrimary";
    }

    protected static interface SyncColumns
    extends CalendarSyncColumns {
        public static final String ACCOUNT_NAME = "account_name";
        public static final String ACCOUNT_TYPE = "account_type";
        public static final String _SYNC_ID = "_sync_id";
        public static final String DIRTY = "dirty";
        public static final String MUTATORS = "mutators";
        public static final String DELETED = "deleted";
        public static final String CAN_PARTIALLY_UPDATE = "canPartiallyUpdate";
    }

    protected static interface CalendarSyncColumns {
        public static final String CAL_SYNC1 = "cal_sync1";
        public static final String CAL_SYNC2 = "cal_sync2";
        public static final String CAL_SYNC3 = "cal_sync3";
        public static final String CAL_SYNC4 = "cal_sync4";
        public static final String CAL_SYNC5 = "cal_sync5";
        public static final String CAL_SYNC6 = "cal_sync6";
        public static final String CAL_SYNC7 = "cal_sync7";
        public static final String CAL_SYNC8 = "cal_sync8";
        public static final String CAL_SYNC9 = "cal_sync9";
        public static final String CAL_SYNC10 = "cal_sync10";
    }
}

