/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.IIncidentManager;
import android.os.IncidentReportArgs;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Slog;

public class IncidentManager {
    private static final String TAG = "incident";
    private Context mContext;

    public IncidentManager(Context context) {
        this.mContext = context;
    }

    public void reportIncident(IncidentReportArgs args) {
        IIncidentManager service = IIncidentManager.Stub.asInterface(ServiceManager.getService(TAG));
        if (service == null) {
            Slog.e(TAG, "reportIncident can't find incident binder service");
            return;
        }
        try {
            service.reportIncident(args);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "reportIncident failed", ex);
        }
    }

    public void reportIncident(String settingName, byte[] headerProto) {
        IncidentReportArgs args;
        String setting = Settings.System.getString(this.mContext.getContentResolver(), settingName);
        try {
            args = IncidentReportArgs.parseSetting(setting);
        }
        catch (IllegalArgumentException ex) {
            Slog.w(TAG, "Bad value for incident report setting '" + settingName + "'", ex);
            return;
        }
        if (args == null) {
            Slog.i(TAG, "Incident report requested but disabled: " + settingName);
            return;
        }
        args.addHeader(headerProto);
        IIncidentManager service = IIncidentManager.Stub.asInterface(ServiceManager.getService(TAG));
        if (service == null) {
            Slog.e(TAG, "reportIncident can't find incident binder service");
            return;
        }
        Slog.i(TAG, "Taking incident report: " + settingName);
        try {
            service.reportIncident(args);
        }
        catch (RemoteException ex) {
            Slog.e(TAG, "reportIncident failed", ex);
        }
    }
}

