/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.Trace;
import android.util.Log;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

final class BinderProxy
implements IBinder {
    volatile boolean mWarnOnBlocking = Binder.sWarnOnBlocking;
    private final WeakReference mSelf = new WeakReference<BinderProxy>(this);
    private long mObject;
    private long mOrgue;

    @Override
    public native boolean pingBinder();

    @Override
    public native boolean isBinderAlive();

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        boolean tracingEnabled;
        Binder.checkParcel(this, code, data, "Unreasonably large binder buffer");
        if (this.mWarnOnBlocking && (flags & 1) == 0) {
            this.mWarnOnBlocking = false;
            Log.w("Binder", "Outgoing transactions from this process must be FLAG_ONEWAY", new Throwable());
        }
        if (tracingEnabled = Binder.isTracingEnabled()) {
            Throwable tr = new Throwable();
            Binder.getTransactionTracker().addTrace(tr);
            StackTraceElement stackTraceElement = tr.getStackTrace()[1];
            Trace.traceBegin(1L, stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
        }
        try {
            boolean bl = this.transactNative(code, data, reply, flags);
            return bl;
        }
        finally {
            if (tracingEnabled) {
                Trace.traceEnd(1L);
            }
        }
    }

    @Override
    public native String getInterfaceDescriptor() throws RemoteException;

    public native boolean transactNative(int var1, Parcel var2, Parcel var3, int var4) throws RemoteException;

    @Override
    public native void linkToDeath(IBinder.DeathRecipient var1, int var2) throws RemoteException;

    @Override
    public native boolean unlinkToDeath(IBinder.DeathRecipient var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 1);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(in);
        data.writeFileDescriptor(out);
        data.writeFileDescriptor(err);
        data.writeStringArray(args);
        ShellCallback.writeToParcel(callback, data);
        resultReceiver.writeToParcel(data, 0);
        try {
            this.transact(1598246212, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    BinderProxy() {
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private final native void destroy();

    private static final void sendDeathNotice(IBinder.DeathRecipient recipient) {
        try {
            recipient.binderDied();
        }
        catch (RuntimeException exc) {
            Log.w("BinderNative", "Uncaught exception from death notification", exc);
        }
    }
}

