/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StructNlAttr {
    public static final int NLA_HEADERLEN = 4;
    public static final int NLA_F_NESTED = 32768;
    public short nla_len = (short)4;
    public short nla_type;
    public byte[] nla_value;
    private ByteOrder mByteOrder = ByteOrder.nativeOrder();

    public static short makeNestedType(short type) {
        return (short)(type | 0x8000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructNlAttr peek(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.remaining() < 4) {
            return null;
        }
        int baseOffset = byteBuffer.position();
        StructNlAttr struct = new StructNlAttr(byteBuffer.order());
        ByteOrder originalOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.nativeOrder());
        try {
            struct.nla_len = byteBuffer.getShort();
            struct.nla_type = byteBuffer.getShort();
        }
        finally {
            byteBuffer.order(originalOrder);
        }
        byteBuffer.position(baseOffset);
        if (struct.nla_len < 4) {
            return null;
        }
        return struct;
    }

    public static StructNlAttr parse(ByteBuffer byteBuffer) {
        StructNlAttr struct = StructNlAttr.peek(byteBuffer);
        if (struct == null || byteBuffer.remaining() < struct.getAlignedLength()) {
            return null;
        }
        int baseOffset = byteBuffer.position();
        byteBuffer.position(baseOffset + 4);
        int valueLen = struct.nla_len & 0xFFFF;
        if ((valueLen -= 4) > 0) {
            struct.nla_value = new byte[valueLen];
            byteBuffer.get(struct.nla_value, 0, valueLen);
            byteBuffer.position(baseOffset + struct.getAlignedLength());
        }
        return struct;
    }

    public StructNlAttr() {
    }

    public StructNlAttr(ByteOrder byteOrder) {
        this.mByteOrder = byteOrder;
    }

    public StructNlAttr(short type, byte value) {
        this.nla_type = type;
        this.setValue(new byte[1]);
        this.nla_value[0] = value;
    }

    public StructNlAttr(short type, short value) {
        this(type, value, ByteOrder.nativeOrder());
    }

    public StructNlAttr(short type, short value, ByteOrder order) {
        this(order);
        this.nla_type = type;
        this.setValue(new byte[2]);
        this.getValueAsByteBuffer().putShort(value);
    }

    public StructNlAttr(short type, int value) {
        this(type, value, ByteOrder.nativeOrder());
    }

    public StructNlAttr(short type, int value, ByteOrder order) {
        this(order);
        this.nla_type = type;
        this.setValue(new byte[4]);
        this.getValueAsByteBuffer().putInt(value);
    }

    public StructNlAttr(short type, InetAddress ip) {
        this.nla_type = type;
        this.setValue(ip.getAddress());
    }

    public StructNlAttr(short type, StructNlAttr ... nested) {
        this();
        this.nla_type = StructNlAttr.makeNestedType(type);
        int payloadLength = 0;
        for (StructNlAttr nla : nested) {
            payloadLength += nla.getAlignedLength();
        }
        this.setValue(new byte[payloadLength]);
        ByteBuffer buf = this.getValueAsByteBuffer();
        for (StructNlAttr nla : nested) {
            nla.pack(buf);
        }
    }

    public int getAlignedLength() {
        return NetlinkConstants.alignedLengthOf(this.nla_len);
    }

    public ByteBuffer getValueAsByteBuffer() {
        if (this.nla_value == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.nla_value);
        byteBuffer.order(this.mByteOrder);
        return byteBuffer;
    }

    public int getValueAsInt(int defaultValue) {
        ByteBuffer byteBuffer = this.getValueAsByteBuffer();
        if (byteBuffer == null || byteBuffer.remaining() != 4) {
            return defaultValue;
        }
        return this.getValueAsByteBuffer().getInt();
    }

    public InetAddress getValueAsInetAddress() {
        if (this.nla_value == null) {
            return null;
        }
        try {
            return InetAddress.getByAddress(this.nla_value);
        }
        catch (UnknownHostException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pack(ByteBuffer byteBuffer) {
        ByteOrder originalOrder = byteBuffer.order();
        int originalPosition = byteBuffer.position();
        byteBuffer.order(ByteOrder.nativeOrder());
        try {
            byteBuffer.putShort(this.nla_len);
            byteBuffer.putShort(this.nla_type);
            if (this.nla_value != null) {
                byteBuffer.put(this.nla_value);
            }
        }
        finally {
            byteBuffer.order(originalOrder);
        }
        byteBuffer.position(originalPosition + this.getAlignedLength());
    }

    private void setValue(byte[] value) {
        this.nla_value = value;
        this.nla_len = (short)(4 + (this.nla_value != null ? this.nla_value.length : 0));
    }

    public String toString() {
        return "StructNlAttr{ nla_len{" + this.nla_len + "}, nla_type{" + this.nla_type + "}, nla_value{" + NetlinkConstants.hexify(this.nla_value) + "}, }";
    }
}

