/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.DhcpResults;
import android.net.INetd;
import android.net.InterfaceConfiguration;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.StaticIpConfiguration;
import android.net.apf.ApfCapabilities;
import android.net.apf.ApfFilter;
import android.net.dhcp.DhcpClient;
import android.net.ip.ConnectivityPacketTracker;
import android.net.ip.IpReachabilityMonitor;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.IpManagerEvent;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.NetdService;
import android.net.util.SharedLog;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemClock;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.IState;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.internal.util.WakeupMessage;
import com.android.server.net.NetlinkTracker;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IpManager
extends StateMachine {
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private static final Class[] sMessageClasses = new Class[]{IpManager.class, DhcpClient.class};
    private static final SparseArray<String> sWhatToString = MessageUtils.findMessageNames(sMessageClasses);
    public static final String DUMP_ARG = "ipmanager";
    public static final String DUMP_ARG_CONFIRM = "confirm";
    private static final int CMD_STOP = 1;
    private static final int CMD_START = 2;
    private static final int CMD_CONFIRM = 3;
    private static final int EVENT_PRE_DHCP_ACTION_COMPLETE = 4;
    private static final int EVENT_NETLINK_LINKPROPERTIES_CHANGED = 5;
    private static final int CMD_UPDATE_TCP_BUFFER_SIZES = 6;
    private static final int CMD_UPDATE_HTTP_PROXY = 7;
    private static final int CMD_SET_MULTICAST_FILTER = 8;
    private static final int EVENT_PROVISIONING_TIMEOUT = 9;
    private static final int EVENT_DHCPACTION_TIMEOUT = 10;
    private static final int MAX_LOG_RECORDS = 500;
    private static final int MAX_PACKET_RECORDS = 100;
    private static final boolean NO_CALLBACKS = false;
    private static final boolean SEND_CALLBACKS = true;
    private static final String CLAT_PREFIX = "v4-";
    private final State mStoppedState = new StoppedState();
    private final State mStoppingState = new StoppingState();
    private final State mStartedState = new StartedState();
    private final State mRunningState = new RunningState();
    private final String mTag;
    private final Context mContext;
    private final String mInterfaceName;
    private final String mClatInterfaceName;
    protected final Callback mCallback;
    private final INetworkManagementService mNwService;
    private final NetlinkTracker mNetlinkTracker;
    private final WakeupMessage mProvisioningTimeoutAlarm;
    private final WakeupMessage mDhcpActionTimeoutAlarm;
    private final MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    private final SharedLog mLog;
    private final LocalLog mConnectivityPacketLog;
    private final MessageHandlingLogger mMsgStateLogger;
    private final IpConnectivityLog mMetricsLog = new IpConnectivityLog();
    private final INetd mNetd;
    private NetworkInterface mNetworkInterface;
    private LinkProperties mLinkProperties;
    private ProvisioningConfiguration mConfiguration;
    private IpReachabilityMonitor mIpReachabilityMonitor;
    private DhcpClient mDhcpClient;
    private DhcpResults mDhcpResults;
    private String mTcpBufferSizes;
    private ProxyInfo mHttpProxy;
    private ApfFilter mApfFilter;
    private boolean mMulticastFiltering;
    private long mStartTimeMillis;

    public IpManager(Context context, String ifName, Callback callback) {
        this(context, ifName, callback, INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management")), NetdService.getInstance());
    }

    public IpManager(Context context, String ifName, Callback callback, INetworkManagementService nwService) {
        this(context, ifName, callback, nwService, NetdService.getInstance());
    }

    IpManager(Context context, String ifName, Callback callback, INetworkManagementService nwService, INetd netd) {
        super(IpManager.class.getSimpleName() + "." + ifName);
        this.mTag = this.getName();
        this.mContext = context;
        this.mInterfaceName = ifName;
        this.mClatInterfaceName = CLAT_PREFIX + ifName;
        this.mCallback = new LoggingCallbackWrapper(callback);
        this.mNwService = nwService;
        this.mNetd = netd;
        this.mLog = new SharedLog(500, this.mTag);
        this.mConnectivityPacketLog = new LocalLog(100);
        this.mMsgStateLogger = new MessageHandlingLogger();
        this.mNetlinkTracker = new NetlinkTracker(this.mInterfaceName, new NetlinkTracker.Callback(){

            @Override
            public void update() {
                IpManager.this.sendMessage(5);
            }
        }){

            @Override
            public void interfaceAdded(String iface) {
                super.interfaceAdded(iface);
                if (IpManager.this.mClatInterfaceName.equals(iface)) {
                    IpManager.this.mCallback.setNeighborDiscoveryOffload(false);
                } else if (!IpManager.this.mInterfaceName.equals(iface)) {
                    return;
                }
                String msg = "interfaceAdded(" + iface + ")";
                this.logMsg(msg);
            }

            @Override
            public void interfaceRemoved(String iface) {
                super.interfaceRemoved(iface);
                if (IpManager.this.mClatInterfaceName.equals(iface)) {
                    IpManager.this.mCallback.setNeighborDiscoveryOffload(true);
                } else if (!IpManager.this.mInterfaceName.equals(iface)) {
                    return;
                }
                String msg = "interfaceRemoved(" + iface + ")";
                this.logMsg(msg);
            }

            private void logMsg(String msg) {
                Log.d(IpManager.this.mTag, msg);
                IpManager.this.getHandler().post(() -> IpManager.this.mLog.log("OBSERVED " + msg));
            }
        };
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
        this.mMultinetworkPolicyTracker = new MultinetworkPolicyTracker(this.mContext, this.getHandler(), () -> this.mLog.log("OBSERVED AvoidBadWifi changed"));
        this.mProvisioningTimeoutAlarm = new WakeupMessage(this.mContext, this.getHandler(), this.mTag + ".EVENT_PROVISIONING_TIMEOUT", 9);
        this.mDhcpActionTimeoutAlarm = new WakeupMessage(this.mContext, this.getHandler(), this.mTag + ".EVENT_DHCPACTION_TIMEOUT", 10);
        this.configureAndStartStateMachine();
        this.startStateMachineUpdaters();
    }

    private void configureAndStartStateMachine() {
        this.addState(this.mStoppedState);
        this.addState(this.mStartedState);
        this.addState(this.mRunningState, this.mStartedState);
        this.addState(this.mStoppingState);
        this.setInitialState(this.mStoppedState);
        super.start();
    }

    private void startStateMachineUpdaters() {
        try {
            this.mNwService.registerObserver(this.mNetlinkTracker);
        }
        catch (RemoteException e) {
            this.logError("Couldn't register NetlinkTracker: %s", e);
        }
        this.mMultinetworkPolicyTracker.start();
    }

    @Override
    protected void onQuitting() {
        this.mCallback.onQuit();
    }

    public void shutdown() {
        this.stop();
        this.mMultinetworkPolicyTracker.shutdown();
        this.quit();
    }

    public static ProvisioningConfiguration.Builder buildProvisioningConfiguration() {
        return new ProvisioningConfiguration.Builder();
    }

    public void startProvisioning(ProvisioningConfiguration req) {
        if (!req.isValid()) {
            this.doImmediateProvisioningFailure(7);
            return;
        }
        this.getNetworkInterface();
        this.mCallback.setNeighborDiscoveryOffload(true);
        this.sendMessage(2, new ProvisioningConfiguration(req));
    }

    public void startProvisioning(StaticIpConfiguration staticIpConfig) {
        this.startProvisioning(IpManager.buildProvisioningConfiguration().withStaticConfiguration(staticIpConfig).build());
    }

    public void startProvisioning() {
        this.startProvisioning(new ProvisioningConfiguration());
    }

    public void stop() {
        this.sendMessage(1);
    }

    public void confirmConfiguration() {
        this.sendMessage(3);
    }

    public void completedPreDhcpAction() {
        this.sendMessage(4);
    }

    public void setTcpBufferSizes(String tcpBufferSizes) {
        this.sendMessage(6, tcpBufferSizes);
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        this.sendMessage(7, proxyInfo);
    }

    public void setMulticastFilter(boolean enabled) {
        this.sendMessage(8, enabled);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (args != null && args.length > 0 && DUMP_ARG_CONFIRM.equals(args[0])) {
            this.confirmConfiguration();
            return;
        }
        ApfFilter apfFilter = this.mApfFilter;
        ProvisioningConfiguration provisioningConfig = this.mConfiguration;
        ApfCapabilities apfCapabilities = provisioningConfig != null ? provisioningConfig.mApfCapabilities : null;
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.mTag + " APF dump:");
        pw.increaseIndent();
        if (apfFilter != null) {
            apfFilter.dump(pw);
        } else {
            pw.print("No active ApfFilter; ");
            if (provisioningConfig == null) {
                pw.println("IpManager not yet started.");
            } else if (apfCapabilities == null || apfCapabilities.apfVersionSupported == 0) {
                pw.println("Hardware does not support APF.");
            } else {
                pw.println("ApfFilter not yet started, APF capabilities: " + apfCapabilities);
            }
        }
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " current ProvisioningConfiguration:");
        pw.increaseIndent();
        pw.println(Objects.toString(provisioningConfig, "N/A"));
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " StateMachine dump:");
        pw.increaseIndent();
        this.mLog.dump(fd, pw, args);
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " connectivity packet log:");
        pw.println();
        pw.println("Debug with python and scapy via:");
        pw.println("shell$ python");
        pw.println(">>> from scapy import all as scapy");
        pw.println(">>> scapy.Ether(\"<paste_hex_string>\".decode(\"hex\")).show2()");
        pw.println();
        pw.increaseIndent();
        this.mConnectivityPacketLog.readOnlyLocalLog().dump(fd, pw, args);
        pw.decreaseIndent();
    }

    @Override
    protected String getWhatToString(int what) {
        return sWhatToString.get(what, "UNKNOWN: " + Integer.toString(what));
    }

    @Override
    protected String getLogRecString(Message msg) {
        String logLine = String.format("%s/%d %d %d %s [%s]", this.mInterfaceName, this.mNetworkInterface == null ? -1 : this.mNetworkInterface.getIndex(), msg.arg1, msg.arg2, Objects.toString(msg.obj), this.mMsgStateLogger);
        String richerLogLine = this.getWhatToString(msg.what) + " " + logLine;
        this.mLog.log(richerLogLine);
        this.mMsgStateLogger.reset();
        return logLine;
    }

    @Override
    protected boolean recordLogRec(Message msg) {
        boolean shouldLog;
        boolean bl = shouldLog = msg.what != 5;
        if (!shouldLog) {
            this.mMsgStateLogger.reset();
        }
        return shouldLog;
    }

    private void logError(String fmt, Object ... args) {
        String msg = "ERROR " + String.format(fmt, args);
        Log.e(this.mTag, msg);
        this.mLog.log(msg);
    }

    private void getNetworkInterface() {
        try {
            this.mNetworkInterface = NetworkInterface.getByName(this.mInterfaceName);
        }
        catch (NullPointerException | SocketException e) {
            this.logError("Failed to get interface object: %s", e);
        }
    }

    private void resetLinkProperties() {
        this.mNetlinkTracker.clearLinkProperties();
        this.mConfiguration = null;
        this.mDhcpResults = null;
        this.mTcpBufferSizes = "";
        this.mHttpProxy = null;
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
    }

    private void recordMetric(int type) {
        if (this.mStartTimeMillis <= 0L) {
            Log.wtf(this.mTag, "Start time undefined!");
        }
        long duration = SystemClock.elapsedRealtime() - this.mStartTimeMillis;
        this.mMetricsLog.log(this.mInterfaceName, (Parcelable)new IpManagerEvent(type, duration));
    }

    static boolean isProvisioned(LinkProperties lp, InitialConfiguration config) {
        if (lp.hasIPv4Address() || lp.isProvisioned()) {
            return true;
        }
        if (config == null) {
            return false;
        }
        return config.isProvisionedBy(lp.getLinkAddresses(), lp.getRoutes());
    }

    private LinkProperties.ProvisioningChange compareProvisioning(LinkProperties oldLp, LinkProperties newLp) {
        boolean ignoreIPv6ProvisioningLoss;
        InitialConfiguration config = this.mConfiguration != null ? this.mConfiguration.mInitialConfig : null;
        boolean wasProvisioned = IpManager.isProvisioned(oldLp, config);
        boolean isProvisioned = IpManager.isProvisioned(newLp, config);
        LinkProperties.ProvisioningChange delta = !wasProvisioned && isProvisioned ? LinkProperties.ProvisioningChange.GAINED_PROVISIONING : (wasProvisioned && isProvisioned ? LinkProperties.ProvisioningChange.STILL_PROVISIONED : (!wasProvisioned && !isProvisioned ? LinkProperties.ProvisioningChange.STILL_NOT_PROVISIONED : LinkProperties.ProvisioningChange.LOST_PROVISIONING));
        boolean lostIPv6 = oldLp.isIPv6Provisioned() && !newLp.isIPv6Provisioned();
        boolean lostIPv4Address = oldLp.hasIPv4Address() && !newLp.hasIPv4Address();
        boolean lostIPv6Router = oldLp.hasIPv6DefaultRoute() && !newLp.hasIPv6DefaultRoute();
        boolean bl = ignoreIPv6ProvisioningLoss = !this.mMultinetworkPolicyTracker.getAvoidBadWifi();
        if (lostIPv4Address || lostIPv6 && !ignoreIPv6ProvisioningLoss) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        if (oldLp.hasGlobalIPv6Address() && lostIPv6Router && !ignoreIPv6ProvisioningLoss) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        return delta;
    }

    private void dispatchCallback(LinkProperties.ProvisioningChange delta, LinkProperties newLp) {
        switch (delta) {
            case GAINED_PROVISIONING: {
                this.recordMetric(1);
                this.mCallback.onProvisioningSuccess(newLp);
                break;
            }
            case LOST_PROVISIONING: {
                this.recordMetric(2);
                this.mCallback.onProvisioningFailure(newLp);
                break;
            }
            default: {
                this.mCallback.onLinkPropertiesChange(newLp);
            }
        }
    }

    private LinkProperties.ProvisioningChange setLinkProperties(LinkProperties newLp) {
        if (this.mApfFilter != null) {
            this.mApfFilter.setLinkProperties(newLp);
        }
        if (this.mIpReachabilityMonitor != null) {
            this.mIpReachabilityMonitor.updateLinkProperties(newLp);
        }
        LinkProperties.ProvisioningChange delta = this.compareProvisioning(this.mLinkProperties, newLp);
        this.mLinkProperties = new LinkProperties(newLp);
        if (delta == LinkProperties.ProvisioningChange.GAINED_PROVISIONING) {
            this.mProvisioningTimeoutAlarm.cancel();
        }
        return delta;
    }

    private LinkProperties assembleLinkProperties() {
        LinkProperties newLp = new LinkProperties();
        newLp.setInterfaceName(this.mInterfaceName);
        LinkProperties netlinkLinkProperties = this.mNetlinkTracker.getLinkProperties();
        newLp.setLinkAddresses(netlinkLinkProperties.getLinkAddresses());
        for (RouteInfo route : netlinkLinkProperties.getRoutes()) {
            newLp.addRoute(route);
        }
        IpManager.addAllReachableDnsServers(newLp, netlinkLinkProperties.getDnsServers());
        if (this.mDhcpResults != null) {
            for (RouteInfo route : this.mDhcpResults.getRoutes(this.mInterfaceName)) {
                newLp.addRoute(route);
            }
            IpManager.addAllReachableDnsServers(newLp, this.mDhcpResults.dnsServers);
            newLp.setDomains(this.mDhcpResults.domains);
            if (this.mDhcpResults.mtu != 0) {
                newLp.setMtu(this.mDhcpResults.mtu);
            }
        }
        if (!TextUtils.isEmpty(this.mTcpBufferSizes)) {
            newLp.setTcpBufferSizes(this.mTcpBufferSizes);
        }
        if (this.mHttpProxy != null) {
            newLp.setHttpProxy(this.mHttpProxy);
        }
        if (this.mConfiguration != null && this.mConfiguration.mInitialConfig != null) {
            InitialConfiguration config = this.mConfiguration.mInitialConfig;
            if (config.isProvisionedBy(newLp.getLinkAddresses(), null)) {
                for (IpPrefix prefix : config.directlyConnectedRoutes) {
                    newLp.addRoute(new RouteInfo(prefix, null, this.mInterfaceName));
                }
            }
            IpManager.addAllReachableDnsServers(newLp, config.dnsServers);
        }
        LinkProperties oldLp = this.mLinkProperties;
        return newLp;
    }

    private static void addAllReachableDnsServers(LinkProperties lp, Iterable<InetAddress> dnses) {
        for (InetAddress dns : dnses) {
            if (dns.isAnyLocalAddress() || !lp.isReachable(dns)) continue;
            lp.addDnsServer(dns);
        }
    }

    private boolean handleLinkPropertiesUpdate(boolean sendCallbacks) {
        LinkProperties newLp = this.assembleLinkProperties();
        if (Objects.equals(newLp, this.mLinkProperties)) {
            return true;
        }
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        if (sendCallbacks) {
            this.dispatchCallback(delta, newLp);
        }
        return delta != LinkProperties.ProvisioningChange.LOST_PROVISIONING;
    }

    private boolean setIPv4Address(LinkAddress address) {
        InterfaceConfiguration ifcg = new InterfaceConfiguration();
        ifcg.setLinkAddress(address);
        try {
            this.mNwService.setInterfaceConfig(this.mInterfaceName, ifcg);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("IPv4 configuration failed: %s", e);
            return false;
        }
        return true;
    }

    private void clearIPv4Address() {
        try {
            InterfaceConfiguration ifcg = new InterfaceConfiguration();
            ifcg.setLinkAddress(new LinkAddress("0.0.0.0/0"));
            this.mNwService.setInterfaceConfig(this.mInterfaceName, ifcg);
        }
        catch (RemoteException | IllegalStateException e) {
            this.logError("Failed to clear IPv4 address on interface %s: %s", this.mInterfaceName, e);
        }
    }

    private void handleIPv4Success(DhcpResults dhcpResults) {
        this.mDhcpResults = new DhcpResults(dhcpResults);
        LinkProperties newLp = this.assembleLinkProperties();
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        this.mCallback.onNewDhcpResults(dhcpResults);
        this.dispatchCallback(delta, newLp);
    }

    private void handleIPv4Failure() {
        this.clearIPv4Address();
        this.mDhcpResults = null;
        this.mCallback.onNewDhcpResults(null);
        this.handleProvisioningFailure();
    }

    private void handleProvisioningFailure() {
        LinkProperties newLp = this.assembleLinkProperties();
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        if (delta == LinkProperties.ProvisioningChange.STILL_NOT_PROVISIONED) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        this.dispatchCallback(delta, newLp);
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            this.transitionTo(this.mStoppingState);
        }
    }

    private void doImmediateProvisioningFailure(int failureType) {
        this.logError("onProvisioningFailure(): %s", failureType);
        this.recordMetric(failureType);
        this.mCallback.onProvisioningFailure(new LinkProperties(this.mLinkProperties));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean startIPv4() {
        if (this.mConfiguration.mStaticIpConfig != null) {
            if (!this.setIPv4Address(this.mConfiguration.mStaticIpConfig.ipAddress)) return false;
            this.handleIPv4Success(new DhcpResults(this.mConfiguration.mStaticIpConfig));
            return true;
        } else {
            this.mDhcpClient = DhcpClient.makeDhcpClient(this.mContext, this, this.mInterfaceName);
            this.mDhcpClient.registerForPreDhcpNotification();
            this.mDhcpClient.sendMessage(196609);
        }
        return true;
    }

    private void setIPv6AddrGenModeIfSupported() throws RemoteException {
        block2: {
            try {
                this.mNwService.setIPv6AddrGenMode(this.mInterfaceName, this.mConfiguration.mIPv6AddrGenMode);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == OsConstants.EOPNOTSUPP) break block2;
                this.logError("Unable to set IPv6 addrgen mode: %s", e);
            }
        }
    }

    private boolean startIPv6() {
        try {
            this.mNwService.setInterfaceIpv6PrivacyExtensions(this.mInterfaceName, true);
            this.setIPv6AddrGenModeIfSupported();
            this.mNwService.enableIpv6(this.mInterfaceName);
        }
        catch (RemoteException | ServiceSpecificException | IllegalStateException e) {
            this.logError("Unable to change interface settings: %s", e);
            return false;
        }
        return true;
    }

    private boolean applyInitialConfig(InitialConfiguration config) {
        if (this.mNetd == null) {
            this.logError("tried to add %s to %s but INetd was null", config, this.mInterfaceName);
            return false;
        }
        for (LinkAddress addr : IpManager.findAll(config.ipAddresses, LinkAddress::isIPv6)) {
            try {
                this.mNetd.interfaceAddAddress(this.mInterfaceName, addr.getAddress().getHostAddress(), addr.getPrefixLength());
            }
            catch (RemoteException | ServiceSpecificException e) {
                this.logError("failed to add %s to %s: %s", addr, this.mInterfaceName, e);
                return false;
            }
        }
        return true;
    }

    private boolean startIpReachabilityMonitor() {
        try {
            this.mIpReachabilityMonitor = new IpReachabilityMonitor(this.mContext, this.mInterfaceName, this.mLog, new IpReachabilityMonitor.Callback(){

                @Override
                public void notifyLost(InetAddress ip, String logMsg) {
                    IpManager.this.mCallback.onReachabilityLost(logMsg);
                }
            }, this.mMultinetworkPolicyTracker);
        }
        catch (IllegalArgumentException iae) {
            this.logError("IpReachabilityMonitor failure: %s", iae);
            this.mIpReachabilityMonitor = null;
        }
        return this.mIpReachabilityMonitor != null;
    }

    private void stopAllIP() {
        try {
            this.mNwService.disableIpv6(this.mInterfaceName);
        }
        catch (Exception e) {
            this.logError("Failed to disable IPv6: %s", e);
        }
        try {
            this.mNwService.clearInterfaceAddresses(this.mInterfaceName);
        }
        catch (Exception e) {
            this.logError("Failed to clear addresses: %s", e);
        }
    }

    static <T> boolean any(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return true;
        }
        return false;
    }

    static <T> boolean all(Iterable<T> coll, Predicate<T> fn) {
        return !IpManager.any(coll, IpManager.not(fn));
    }

    static <T> Predicate<T> not(Predicate<T> fn) {
        return t -> !fn.test(t);
    }

    static <T> String join(String delimiter, Collection<T> coll) {
        return coll.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    static <T> T find(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return t;
        }
        return null;
    }

    static <T> List<T> findAll(Collection<T> coll, Predicate<T> fn) {
        return coll.stream().filter(fn).collect(Collectors.toList());
    }

    private static class MessageHandlingLogger {
        public String processedInState;
        public String receivedInState;

        private MessageHandlingLogger() {
        }

        public void reset() {
            this.processedInState = null;
            this.receivedInState = null;
        }

        public void handled(State processedIn, IState receivedIn) {
            this.processedInState = processedIn.getClass().getSimpleName();
            this.receivedInState = receivedIn.getName();
        }

        public String toString() {
            return String.format("rcvd_in=%s, proc_in=%s", this.receivedInState, this.processedInState);
        }
    }

    class RunningState
    extends State {
        private ConnectivityPacketTracker mPacketTracker;
        private boolean mDhcpActionInFlight;

        RunningState() {
        }

        @Override
        public void enter() {
            boolean filter802_3Frames = IpManager.this.mContext.getResources().getBoolean(17956889);
            IpManager.this.mApfFilter = ApfFilter.maybeCreate(((IpManager)IpManager.this).mConfiguration.mApfCapabilities, IpManager.this.mNetworkInterface, IpManager.this.mCallback, IpManager.this.mMulticastFiltering, filter802_3Frames);
            if (IpManager.this.mApfFilter == null) {
                IpManager.this.mCallback.setFallbackMulticastFilter(IpManager.this.mMulticastFiltering);
            }
            this.mPacketTracker = this.createPacketTracker();
            if (this.mPacketTracker != null) {
                this.mPacketTracker.start();
            }
            if (((IpManager)IpManager.this).mConfiguration.mEnableIPv6 && !IpManager.this.startIPv6()) {
                IpManager.this.doImmediateProvisioningFailure(5);
                IpManager.this.transitionTo(IpManager.this.mStoppingState);
                return;
            }
            if (((IpManager)IpManager.this).mConfiguration.mEnableIPv4 && !IpManager.this.startIPv4()) {
                IpManager.this.doImmediateProvisioningFailure(4);
                IpManager.this.transitionTo(IpManager.this.mStoppingState);
                return;
            }
            InitialConfiguration config = ((IpManager)IpManager.this).mConfiguration.mInitialConfig;
            if (config != null && !IpManager.this.applyInitialConfig(config)) {
                IpManager.this.doImmediateProvisioningFailure(7);
                IpManager.this.transitionTo(IpManager.this.mStoppingState);
                return;
            }
            if (((IpManager)IpManager.this).mConfiguration.mUsingIpReachabilityMonitor && !IpManager.this.startIpReachabilityMonitor()) {
                IpManager.this.doImmediateProvisioningFailure(6);
                IpManager.this.transitionTo(IpManager.this.mStoppingState);
                return;
            }
        }

        @Override
        public void exit() {
            this.stopDhcpAction();
            if (IpManager.this.mIpReachabilityMonitor != null) {
                IpManager.this.mIpReachabilityMonitor.stop();
                IpManager.this.mIpReachabilityMonitor = null;
            }
            if (IpManager.this.mDhcpClient != null) {
                IpManager.this.mDhcpClient.sendMessage(196610);
                IpManager.this.mDhcpClient.doQuit();
            }
            if (this.mPacketTracker != null) {
                this.mPacketTracker.stop();
                this.mPacketTracker = null;
            }
            if (IpManager.this.mApfFilter != null) {
                IpManager.this.mApfFilter.shutdown();
                IpManager.this.mApfFilter = null;
            }
            IpManager.this.resetLinkProperties();
        }

        private ConnectivityPacketTracker createPacketTracker() {
            try {
                return new ConnectivityPacketTracker(IpManager.this.mNetworkInterface, IpManager.this.mConnectivityPacketLog);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private void ensureDhcpAction() {
            if (!this.mDhcpActionInFlight) {
                IpManager.this.mCallback.onPreDhcpAction();
                this.mDhcpActionInFlight = true;
                long alarmTime = SystemClock.elapsedRealtime() + (long)((IpManager)IpManager.this).mConfiguration.mRequestedPreDhcpActionMs;
                IpManager.this.mDhcpActionTimeoutAlarm.schedule(alarmTime);
            }
        }

        private void stopDhcpAction() {
            IpManager.this.mDhcpActionTimeoutAlarm.cancel();
            if (this.mDhcpActionInFlight) {
                IpManager.this.mCallback.onPostDhcpAction();
                this.mDhcpActionInFlight = false;
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            block0 : switch (msg.what) {
                case 1: {
                    IpManager.this.transitionTo(IpManager.this.mStoppingState);
                    break;
                }
                case 2: {
                    IpManager.this.logError("ALERT: START received in StartedState. Please fix caller.", new Object[0]);
                    break;
                }
                case 3: {
                    if (IpManager.this.mIpReachabilityMonitor == null) break;
                    IpManager.this.mIpReachabilityMonitor.probeAll();
                    break;
                }
                case 4: {
                    if (IpManager.this.mDhcpClient == null) break;
                    IpManager.this.mDhcpClient.sendMessage(196614);
                    break;
                }
                case 5: {
                    if (IpManager.this.handleLinkPropertiesUpdate(true)) break;
                    IpManager.this.transitionTo(IpManager.this.mStoppingState);
                    break;
                }
                case 6: {
                    IpManager.this.mTcpBufferSizes = (String)msg.obj;
                    IpManager.this.handleLinkPropertiesUpdate(true);
                    break;
                }
                case 7: {
                    IpManager.this.mHttpProxy = (ProxyInfo)msg.obj;
                    IpManager.this.handleLinkPropertiesUpdate(true);
                    break;
                }
                case 8: {
                    IpManager.this.mMulticastFiltering = (Boolean)msg.obj;
                    if (IpManager.this.mApfFilter != null) {
                        IpManager.this.mApfFilter.setMulticastFilter(IpManager.this.mMulticastFiltering);
                        break;
                    }
                    IpManager.this.mCallback.setFallbackMulticastFilter(IpManager.this.mMulticastFiltering);
                    break;
                }
                case 10: {
                    this.stopDhcpAction();
                    break;
                }
                case 196611: {
                    if (((IpManager)IpManager.this).mConfiguration.mRequestedPreDhcpActionMs > 0) {
                        this.ensureDhcpAction();
                        break;
                    }
                    IpManager.this.sendMessage(4);
                    break;
                }
                case 196615: {
                    IpManager.this.clearIPv4Address();
                    break;
                }
                case 196616: {
                    LinkAddress ipAddress = (LinkAddress)msg.obj;
                    if (IpManager.this.setIPv4Address(ipAddress)) {
                        IpManager.this.mDhcpClient.sendMessage(196617);
                        break;
                    }
                    IpManager.this.logError("Failed to set IPv4 address.", new Object[0]);
                    IpManager.this.dispatchCallback(LinkProperties.ProvisioningChange.LOST_PROVISIONING, new LinkProperties(IpManager.this.mLinkProperties));
                    IpManager.this.transitionTo(IpManager.this.mStoppingState);
                    break;
                }
                case 196612: {
                    this.stopDhcpAction();
                    switch (msg.arg1) {
                        case 1: {
                            IpManager.this.handleIPv4Success((DhcpResults)msg.obj);
                            break block0;
                        }
                        case 2: {
                            IpManager.this.handleIPv4Failure();
                            break block0;
                        }
                    }
                    IpManager.this.logError("Unknown CMD_POST_DHCP_ACTION status: %s", new Object[]{msg.arg1});
                    break;
                }
                case 196613: {
                    IpManager.this.logError("Unexpected CMD_ON_QUIT.", new Object[0]);
                    IpManager.this.mDhcpClient = null;
                    break;
                }
                default: {
                    return false;
                }
            }
            IpManager.this.mMsgStateLogger.handled(this, IpManager.this.getCurrentState());
            return true;
        }
    }

    class StartedState
    extends State {
        StartedState() {
        }

        @Override
        public void enter() {
            IpManager.this.mStartTimeMillis = SystemClock.elapsedRealtime();
            if (((IpManager)IpManager.this).mConfiguration.mProvisioningTimeoutMs > 0) {
                long alarmTime = SystemClock.elapsedRealtime() + (long)((IpManager)IpManager.this).mConfiguration.mProvisioningTimeoutMs;
                IpManager.this.mProvisioningTimeoutAlarm.schedule(alarmTime);
            }
            if (this.readyToProceed()) {
                IpManager.this.transitionTo(IpManager.this.mRunningState);
            } else {
                IpManager.this.stopAllIP();
            }
        }

        @Override
        public void exit() {
            IpManager.this.mProvisioningTimeoutAlarm.cancel();
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    IpManager.this.transitionTo(IpManager.this.mStoppingState);
                    break;
                }
                case 5: {
                    IpManager.this.handleLinkPropertiesUpdate(false);
                    if (!this.readyToProceed()) break;
                    IpManager.this.transitionTo(IpManager.this.mRunningState);
                    break;
                }
                case 9: {
                    IpManager.this.handleProvisioningFailure();
                    break;
                }
                default: {
                    IpManager.this.deferMessage(msg);
                }
            }
            IpManager.this.mMsgStateLogger.handled(this, IpManager.this.getCurrentState());
            return true;
        }

        boolean readyToProceed() {
            return !IpManager.this.mLinkProperties.hasIPv4Address() && !IpManager.this.mLinkProperties.hasGlobalIPv6Address();
        }
    }

    class StoppingState
    extends State {
        StoppingState() {
        }

        @Override
        public void enter() {
            if (IpManager.this.mDhcpClient == null) {
                IpManager.this.transitionTo(IpManager.this.mStoppedState);
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    break;
                }
                case 196615: {
                    IpManager.this.clearIPv4Address();
                    break;
                }
                case 196613: {
                    IpManager.this.mDhcpClient = null;
                    IpManager.this.transitionTo(IpManager.this.mStoppedState);
                    break;
                }
                default: {
                    IpManager.this.deferMessage(msg);
                }
            }
            IpManager.this.mMsgStateLogger.handled(this, IpManager.this.getCurrentState());
            return true;
        }
    }

    class StoppedState
    extends State {
        StoppedState() {
        }

        @Override
        public void enter() {
            IpManager.this.stopAllIP();
            IpManager.this.resetLinkProperties();
            if (IpManager.this.mStartTimeMillis > 0L) {
                IpManager.this.recordMetric(3);
                IpManager.this.mStartTimeMillis = 0L;
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    break;
                }
                case 2: {
                    IpManager.this.mConfiguration = (ProvisioningConfiguration)msg.obj;
                    IpManager.this.transitionTo(IpManager.this.mStartedState);
                    break;
                }
                case 5: {
                    IpManager.this.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 6: {
                    IpManager.this.mTcpBufferSizes = (String)msg.obj;
                    IpManager.this.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 7: {
                    IpManager.this.mHttpProxy = (ProxyInfo)msg.obj;
                    IpManager.this.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 8: {
                    IpManager.this.mMulticastFiltering = (Boolean)msg.obj;
                    break;
                }
                case 196613: {
                    IpManager.this.logError("Unexpected CMD_ON_QUIT (already stopped).", new Object[0]);
                    break;
                }
                default: {
                    return false;
                }
            }
            IpManager.this.mMsgStateLogger.handled(this, IpManager.this.getCurrentState());
            return true;
        }
    }

    public static class InitialConfiguration {
        public final Set<LinkAddress> ipAddresses = new HashSet<LinkAddress>();
        public final Set<IpPrefix> directlyConnectedRoutes = new HashSet<IpPrefix>();
        public final Set<InetAddress> dnsServers = new HashSet<InetAddress>();
        public Inet4Address gateway;

        public static InitialConfiguration copy(InitialConfiguration config) {
            if (config == null) {
                return null;
            }
            InitialConfiguration configCopy = new InitialConfiguration();
            configCopy.ipAddresses.addAll(config.ipAddresses);
            configCopy.directlyConnectedRoutes.addAll(config.directlyConnectedRoutes);
            configCopy.dnsServers.addAll(config.dnsServers);
            return configCopy;
        }

        public String toString() {
            return String.format("InitialConfiguration(IPs: {%s}, prefixes: {%s}, DNS: {%s}, v4 gateway: %s)", IpManager.join(", ", this.ipAddresses), IpManager.join(", ", this.directlyConnectedRoutes), IpManager.join(", ", this.dnsServers), this.gateway);
        }

        public boolean isValid() {
            if (this.ipAddresses.isEmpty()) {
                return false;
            }
            for (LinkAddress linkAddress : this.ipAddresses) {
                if (IpManager.any(this.directlyConnectedRoutes, p -> p.contains(linkAddress.getAddress()))) continue;
                return false;
            }
            for (InetAddress inetAddress : this.dnsServers) {
                if (IpManager.any(this.directlyConnectedRoutes, p -> p.contains(inetAddress))) continue;
                return false;
            }
            if (IpManager.any(this.ipAddresses, IpManager.not(InitialConfiguration::isPrefixLengthCompliant))) {
                return false;
            }
            if (IpManager.any(this.directlyConnectedRoutes, InitialConfiguration::isIPv6DefaultRoute) && IpManager.all(this.ipAddresses, IpManager.not(InitialConfiguration::isIPv6GUA))) {
                return false;
            }
            if (IpManager.any(this.directlyConnectedRoutes, IpManager.not(InitialConfiguration::isPrefixLengthCompliant))) {
                return false;
            }
            return this.ipAddresses.stream().filter(Inet4Address.class::isInstance).count() <= 1L;
        }

        public boolean isProvisionedBy(List<LinkAddress> addresses, List<RouteInfo> routes) {
            if (this.ipAddresses.isEmpty()) {
                return false;
            }
            for (LinkAddress addr : this.ipAddresses) {
                if (IpManager.any(addresses, addrSeen -> addr.isSameAddressAs((LinkAddress)addrSeen))) continue;
                return false;
            }
            if (routes != null) {
                for (IpPrefix prefix : this.directlyConnectedRoutes) {
                    if (IpManager.any(routes, routeSeen -> InitialConfiguration.isDirectlyConnectedRoute(routeSeen, prefix))) continue;
                    return false;
                }
            }
            return true;
        }

        private static boolean isDirectlyConnectedRoute(RouteInfo route, IpPrefix prefix) {
            return !route.hasGateway() && prefix.equals(route.getDestination());
        }

        private static boolean isPrefixLengthCompliant(LinkAddress addr) {
            return addr.isIPv4() || InitialConfiguration.isCompliantIPv6PrefixLength(addr.getPrefixLength());
        }

        private static boolean isPrefixLengthCompliant(IpPrefix prefix) {
            return prefix.isIPv4() || InitialConfiguration.isCompliantIPv6PrefixLength(prefix.getPrefixLength());
        }

        private static boolean isCompliantIPv6PrefixLength(int prefixLength) {
            return 48 <= prefixLength && prefixLength <= 64;
        }

        private static boolean isIPv6DefaultRoute(IpPrefix prefix) {
            return prefix.getAddress().equals(Inet6Address.ANY);
        }

        private static boolean isIPv6GUA(LinkAddress addr) {
            return addr.isIPv6() && addr.isGlobalPreferred();
        }
    }

    public static class ProvisioningConfiguration {
        private static final int DEFAULT_TIMEOUT_MS = 36000;
        boolean mEnableIPv4 = true;
        boolean mEnableIPv6 = true;
        boolean mUsingIpReachabilityMonitor = true;
        int mRequestedPreDhcpActionMs;
        InitialConfiguration mInitialConfig;
        StaticIpConfiguration mStaticIpConfig;
        ApfCapabilities mApfCapabilities;
        int mProvisioningTimeoutMs = 36000;
        int mIPv6AddrGenMode = 2;

        public ProvisioningConfiguration() {
        }

        public ProvisioningConfiguration(ProvisioningConfiguration other) {
            this.mEnableIPv4 = other.mEnableIPv4;
            this.mEnableIPv6 = other.mEnableIPv6;
            this.mUsingIpReachabilityMonitor = other.mUsingIpReachabilityMonitor;
            this.mRequestedPreDhcpActionMs = other.mRequestedPreDhcpActionMs;
            this.mInitialConfig = InitialConfiguration.copy(other.mInitialConfig);
            this.mStaticIpConfig = other.mStaticIpConfig;
            this.mApfCapabilities = other.mApfCapabilities;
            this.mProvisioningTimeoutMs = other.mProvisioningTimeoutMs;
        }

        public String toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("mEnableIPv4: " + this.mEnableIPv4).add("mEnableIPv6: " + this.mEnableIPv6).add("mUsingIpReachabilityMonitor: " + this.mUsingIpReachabilityMonitor).add("mRequestedPreDhcpActionMs: " + this.mRequestedPreDhcpActionMs).add("mInitialConfig: " + this.mInitialConfig).add("mStaticIpConfig: " + this.mStaticIpConfig).add("mApfCapabilities: " + this.mApfCapabilities).add("mProvisioningTimeoutMs: " + this.mProvisioningTimeoutMs).add("mIPv6AddrGenMode: " + this.mIPv6AddrGenMode).toString();
        }

        public boolean isValid() {
            return this.mInitialConfig == null || this.mInitialConfig.isValid();
        }

        public static class Builder {
            private ProvisioningConfiguration mConfig = new ProvisioningConfiguration();

            public Builder withoutIPv4() {
                this.mConfig.mEnableIPv4 = false;
                return this;
            }

            public Builder withoutIPv6() {
                this.mConfig.mEnableIPv6 = false;
                return this;
            }

            public Builder withoutIpReachabilityMonitor() {
                this.mConfig.mUsingIpReachabilityMonitor = false;
                return this;
            }

            public Builder withPreDhcpAction() {
                this.mConfig.mRequestedPreDhcpActionMs = 36000;
                return this;
            }

            public Builder withPreDhcpAction(int dhcpActionTimeoutMs) {
                this.mConfig.mRequestedPreDhcpActionMs = dhcpActionTimeoutMs;
                return this;
            }

            public Builder withInitialConfiguration(InitialConfiguration initialConfig) {
                this.mConfig.mInitialConfig = initialConfig;
                return this;
            }

            public Builder withStaticConfiguration(StaticIpConfiguration staticConfig) {
                this.mConfig.mStaticIpConfig = staticConfig;
                return this;
            }

            public Builder withApfCapabilities(ApfCapabilities apfCapabilities) {
                this.mConfig.mApfCapabilities = apfCapabilities;
                return this;
            }

            public Builder withProvisioningTimeoutMs(int timeoutMs) {
                this.mConfig.mProvisioningTimeoutMs = timeoutMs;
                return this;
            }

            public Builder withIPv6AddrGenModeEUI64() {
                this.mConfig.mIPv6AddrGenMode = 0;
                return this;
            }

            public Builder withIPv6AddrGenModeStablePrivacy() {
                this.mConfig.mIPv6AddrGenMode = 2;
                return this;
            }

            public ProvisioningConfiguration build() {
                return new ProvisioningConfiguration(this.mConfig);
            }
        }
    }

    private class LoggingCallbackWrapper
    extends Callback {
        private static final String PREFIX = "INVOKE ";
        private Callback mCallback;

        public LoggingCallbackWrapper(Callback callback) {
            this.mCallback = callback;
        }

        private void log(String msg) {
            IpManager.this.mLog.log(PREFIX + msg);
        }

        @Override
        public void onPreDhcpAction() {
            this.mCallback.onPreDhcpAction();
            this.log("onPreDhcpAction()");
        }

        @Override
        public void onPostDhcpAction() {
            this.mCallback.onPostDhcpAction();
            this.log("onPostDhcpAction()");
        }

        @Override
        public void onNewDhcpResults(DhcpResults dhcpResults) {
            this.mCallback.onNewDhcpResults(dhcpResults);
            this.log("onNewDhcpResults({" + dhcpResults + "})");
        }

        @Override
        public void onProvisioningSuccess(LinkProperties newLp) {
            this.mCallback.onProvisioningSuccess(newLp);
            this.log("onProvisioningSuccess({" + newLp + "})");
        }

        @Override
        public void onProvisioningFailure(LinkProperties newLp) {
            this.mCallback.onProvisioningFailure(newLp);
            this.log("onProvisioningFailure({" + newLp + "})");
        }

        @Override
        public void onLinkPropertiesChange(LinkProperties newLp) {
            this.mCallback.onLinkPropertiesChange(newLp);
            this.log("onLinkPropertiesChange({" + newLp + "})");
        }

        @Override
        public void onReachabilityLost(String logMsg) {
            this.mCallback.onReachabilityLost(logMsg);
            this.log("onReachabilityLost(" + logMsg + ")");
        }

        @Override
        public void onQuit() {
            this.mCallback.onQuit();
            this.log("onQuit()");
        }

        @Override
        public void installPacketFilter(byte[] filter) {
            this.mCallback.installPacketFilter(filter);
            this.log("installPacketFilter(byte[" + filter.length + "])");
        }

        @Override
        public void setFallbackMulticastFilter(boolean enabled) {
            this.mCallback.setFallbackMulticastFilter(enabled);
            this.log("setFallbackMulticastFilter(" + enabled + ")");
        }

        @Override
        public void setNeighborDiscoveryOffload(boolean enable) {
            this.mCallback.setNeighborDiscoveryOffload(enable);
            this.log("setNeighborDiscoveryOffload(" + enable + ")");
        }
    }

    public static class WaitForProvisioningCallback
    extends Callback {
        private LinkProperties mCallbackLinkProperties;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LinkProperties waitForProvisioning() {
            WaitForProvisioningCallback waitForProvisioningCallback = this;
            synchronized (waitForProvisioningCallback) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.mCallbackLinkProperties;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisioningSuccess(LinkProperties newLp) {
            WaitForProvisioningCallback waitForProvisioningCallback = this;
            synchronized (waitForProvisioningCallback) {
                this.mCallbackLinkProperties = newLp;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProvisioningFailure(LinkProperties newLp) {
            WaitForProvisioningCallback waitForProvisioningCallback = this;
            synchronized (waitForProvisioningCallback) {
                this.mCallbackLinkProperties = null;
                this.notify();
            }
        }
    }

    public static class Callback {
        public void onPreDhcpAction() {
        }

        public void onPostDhcpAction() {
        }

        public void onNewDhcpResults(DhcpResults dhcpResults) {
        }

        public void onProvisioningSuccess(LinkProperties newLp) {
        }

        public void onProvisioningFailure(LinkProperties newLp) {
        }

        public void onLinkPropertiesChange(LinkProperties newLp) {
        }

        public void onReachabilityLost(String logMsg) {
        }

        public void onQuit() {
        }

        public void installPacketFilter(byte[] filter) {
        }

        public void setFallbackMulticastFilter(boolean enabled) {
        }

        public void setNeighborDiscoveryOffload(boolean enable) {
        }
    }
}

