/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import java.nio.ByteBuffer;

class DhcpDiscoverPacket
extends DhcpPacket {
    DhcpDiscoverPacket(int transId, short secs, byte[] clientMac, boolean broadcast) {
        super(transId, secs, INADDR_ANY, INADDR_ANY, INADDR_ANY, INADDR_ANY, clientMac, broadcast);
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + " DISCOVER " + (this.mBroadcast ? "broadcast " : "unicast ");
    }

    @Override
    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        this.fillInPacket(encap, INADDR_BROADCAST, INADDR_ANY, destUdp, srcUdp, result, (byte)1, this.mBroadcast);
        result.flip();
        return result;
    }

    @Override
    void finishPacket(ByteBuffer buffer) {
        DhcpDiscoverPacket.addTlv(buffer, (byte)53, (byte)1);
        DhcpDiscoverPacket.addTlv(buffer, (byte)61, this.getClientId());
        this.addCommonClientTlvs(buffer);
        DhcpDiscoverPacket.addTlv(buffer, (byte)55, this.mRequestedParams);
        DhcpDiscoverPacket.addTlvEnd(buffer);
    }
}

