/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.dhcp.DhcpPacket;
import java.net.Inet4Address;
import java.nio.ByteBuffer;

class DhcpDeclinePacket
extends DhcpPacket {
    DhcpDeclinePacket(int transId, short secs, Inet4Address clientIp, Inet4Address yourIp, Inet4Address nextIp, Inet4Address relayIp, byte[] clientMac) {
        super(transId, secs, clientIp, yourIp, nextIp, relayIp, clientMac, false);
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s + " DECLINE";
    }

    @Override
    public ByteBuffer buildPacket(int encap, short destUdp, short srcUdp) {
        ByteBuffer result = ByteBuffer.allocate(1500);
        this.fillInPacket(encap, this.mClientIp, this.mYourIp, destUdp, srcUdp, result, (byte)1, false);
        result.flip();
        return result;
    }

    @Override
    void finishPacket(ByteBuffer buffer) {
        DhcpDeclinePacket.addTlv(buffer, (byte)53, (byte)4);
        DhcpDeclinePacket.addTlv(buffer, (byte)61, this.getClientId());
        DhcpDeclinePacket.addTlvEnd(buffer);
    }
}

