/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.util.ArrayList;
import java.util.List;

public class DecoderCapabilities {
    public static List<VideoDecoder> getVideoDecoders() {
        ArrayList<VideoDecoder> decoderList = new ArrayList<VideoDecoder>();
        int nDecoders = DecoderCapabilities.native_get_num_video_decoders();
        for (int i = 0; i < nDecoders; ++i) {
            decoderList.add(VideoDecoder.values()[DecoderCapabilities.native_get_video_decoder_type(i)]);
        }
        return decoderList;
    }

    public static List<AudioDecoder> getAudioDecoders() {
        ArrayList<AudioDecoder> decoderList = new ArrayList<AudioDecoder>();
        int nDecoders = DecoderCapabilities.native_get_num_audio_decoders();
        for (int i = 0; i < nDecoders; ++i) {
            decoderList.add(AudioDecoder.values()[DecoderCapabilities.native_get_audio_decoder_type(i)]);
        }
        return decoderList;
    }

    private DecoderCapabilities() {
    }

    private static final native void native_init();

    private static final native int native_get_num_video_decoders();

    private static final native int native_get_video_decoder_type(int var0);

    private static final native int native_get_num_audio_decoders();

    private static final native int native_get_audio_decoder_type(int var0);

    static {
        System.loadLibrary("media_jni");
        DecoderCapabilities.native_init();
    }

    public static enum AudioDecoder {
        AUDIO_DECODER_WMA;

    }

    public static enum VideoDecoder {
        VIDEO_DECODER_WMV;

    }
}

