/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class BufferingParams
implements Parcelable {
    public static final int BUFFERING_MODE_NONE = 0;
    public static final int BUFFERING_MODE_TIME_ONLY = 1;
    public static final int BUFFERING_MODE_SIZE_ONLY = 2;
    public static final int BUFFERING_MODE_TIME_THEN_SIZE = 3;
    private static final int BUFFERING_NO_WATERMARK = -1;
    private int mInitialBufferingMode = 0;
    private int mRebufferingMode = 0;
    private int mInitialWatermarkMs = -1;
    private int mInitialWatermarkKB = -1;
    private int mRebufferingWatermarkLowMs = -1;
    private int mRebufferingWatermarkHighMs = -1;
    private int mRebufferingWatermarkLowKB = -1;
    private int mRebufferingWatermarkHighKB = -1;
    public static final Parcelable.Creator<BufferingParams> CREATOR = new Parcelable.Creator<BufferingParams>(){

        @Override
        public BufferingParams createFromParcel(Parcel in) {
            return new BufferingParams(in);
        }

        public BufferingParams[] newArray(int size) {
            return new BufferingParams[size];
        }
    };

    private BufferingParams() {
    }

    public int getInitialBufferingMode() {
        return this.mInitialBufferingMode;
    }

    public int getRebufferingMode() {
        return this.mRebufferingMode;
    }

    public int getInitialBufferingWatermarkMs() {
        return this.mInitialWatermarkMs;
    }

    public int getInitialBufferingWatermarkKB() {
        return this.mInitialWatermarkKB;
    }

    public int getRebufferingWatermarkLowMs() {
        return this.mRebufferingWatermarkLowMs;
    }

    public int getRebufferingWatermarkHighMs() {
        return this.mRebufferingWatermarkHighMs;
    }

    public int getRebufferingWatermarkLowKB() {
        return this.mRebufferingWatermarkLowKB;
    }

    public int getRebufferingWatermarkHighKB() {
        return this.mRebufferingWatermarkHighKB;
    }

    private BufferingParams(Parcel in) {
        this.mInitialBufferingMode = in.readInt();
        this.mRebufferingMode = in.readInt();
        this.mInitialWatermarkMs = in.readInt();
        this.mInitialWatermarkKB = in.readInt();
        this.mRebufferingWatermarkLowMs = in.readInt();
        this.mRebufferingWatermarkHighMs = in.readInt();
        this.mRebufferingWatermarkLowKB = in.readInt();
        this.mRebufferingWatermarkHighKB = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mInitialBufferingMode);
        dest.writeInt(this.mRebufferingMode);
        dest.writeInt(this.mInitialWatermarkMs);
        dest.writeInt(this.mInitialWatermarkKB);
        dest.writeInt(this.mRebufferingWatermarkLowMs);
        dest.writeInt(this.mRebufferingWatermarkHighMs);
        dest.writeInt(this.mRebufferingWatermarkLowKB);
        dest.writeInt(this.mRebufferingWatermarkHighKB);
    }

    public static class Builder {
        private int mInitialBufferingMode = 0;
        private int mRebufferingMode = 0;
        private int mInitialWatermarkMs = -1;
        private int mInitialWatermarkKB = -1;
        private int mRebufferingWatermarkLowMs = -1;
        private int mRebufferingWatermarkHighMs = -1;
        private int mRebufferingWatermarkLowKB = -1;
        private int mRebufferingWatermarkHighKB = -1;

        public Builder() {
        }

        public Builder(BufferingParams bp) {
            this.mInitialBufferingMode = bp.mInitialBufferingMode;
            this.mRebufferingMode = bp.mRebufferingMode;
            this.mInitialWatermarkMs = bp.mInitialWatermarkMs;
            this.mInitialWatermarkKB = bp.mInitialWatermarkKB;
            this.mRebufferingWatermarkLowMs = bp.mRebufferingWatermarkLowMs;
            this.mRebufferingWatermarkHighMs = bp.mRebufferingWatermarkHighMs;
            this.mRebufferingWatermarkLowKB = bp.mRebufferingWatermarkLowKB;
            this.mRebufferingWatermarkHighKB = bp.mRebufferingWatermarkHighKB;
        }

        public BufferingParams build() {
            if (this.isTimeBasedMode(this.mRebufferingMode) && this.mRebufferingWatermarkLowMs > this.mRebufferingWatermarkHighMs) {
                throw new IllegalStateException("Illegal watermark:" + this.mRebufferingWatermarkLowMs + " : " + this.mRebufferingWatermarkHighMs);
            }
            if (this.isSizeBasedMode(this.mRebufferingMode) && this.mRebufferingWatermarkLowKB > this.mRebufferingWatermarkHighKB) {
                throw new IllegalStateException("Illegal watermark:" + this.mRebufferingWatermarkLowKB + " : " + this.mRebufferingWatermarkHighKB);
            }
            BufferingParams bp = new BufferingParams();
            bp.mInitialBufferingMode = this.mInitialBufferingMode;
            bp.mRebufferingMode = this.mRebufferingMode;
            bp.mInitialWatermarkMs = this.mInitialWatermarkMs;
            bp.mInitialWatermarkKB = this.mInitialWatermarkKB;
            bp.mRebufferingWatermarkLowMs = this.mRebufferingWatermarkLowMs;
            bp.mRebufferingWatermarkHighMs = this.mRebufferingWatermarkHighMs;
            bp.mRebufferingWatermarkLowKB = this.mRebufferingWatermarkLowKB;
            bp.mRebufferingWatermarkHighKB = this.mRebufferingWatermarkHighKB;
            return bp;
        }

        private boolean isTimeBasedMode(int mode) {
            return mode == 1 || mode == 3;
        }

        private boolean isSizeBasedMode(int mode) {
            return mode == 2 || mode == 3;
        }

        public Builder setInitialBufferingMode(int mode) {
            switch (mode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.mInitialBufferingMode = mode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal buffering mode " + mode);
                }
            }
            return this;
        }

        public Builder setRebufferingMode(int mode) {
            switch (mode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.mRebufferingMode = mode;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal buffering mode " + mode);
                }
            }
            return this;
        }

        public Builder setInitialBufferingWatermarkMs(int watermarkMs) {
            this.mInitialWatermarkMs = watermarkMs;
            return this;
        }

        public Builder setInitialBufferingWatermarkKB(int watermarkKB) {
            this.mInitialWatermarkKB = watermarkKB;
            return this;
        }

        public Builder setRebufferingWatermarkLowMs(int watermarkMs) {
            this.mRebufferingWatermarkLowMs = watermarkMs;
            return this;
        }

        public Builder setRebufferingWatermarkHighMs(int watermarkMs) {
            this.mRebufferingWatermarkHighMs = watermarkMs;
            return this;
        }

        public Builder setRebufferingWatermarkLowKB(int watermarkKB) {
            this.mRebufferingWatermarkLowKB = watermarkKB;
            return this;
        }

        public Builder setRebufferingWatermarkHighKB(int watermarkKB) {
            this.mRebufferingWatermarkHighKB = watermarkKB;
            return this;
        }

        public Builder setRebufferingWatermarksMs(int lowWatermarkMs, int highWatermarkMs) {
            this.mRebufferingWatermarkLowMs = lowWatermarkMs;
            this.mRebufferingWatermarkHighMs = highWatermarkMs;
            return this;
        }

        public Builder setRebufferingWatermarksKB(int lowWatermarkKB, int highWatermarkKB) {
            this.mRebufferingWatermarkLowKB = lowWatermarkKB;
            this.mRebufferingWatermarkHighKB = highWatermarkKB;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferingMode {
    }
}

