/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class AmrInputStream
extends InputStream {
    private static final String TAG = "AmrInputStream";
    private static final int SAMPLES_PER_FRAME = 160;
    MediaCodec mCodec;
    MediaCodec.BufferInfo mInfo;
    boolean mSawOutputEOS;
    boolean mSawInputEOS;
    private InputStream mInputStream;
    private final byte[] mBuf = new byte[320];
    private int mBufIn = 0;
    private int mBufOut = 0;
    private byte[] mOneByte = new byte[1];

    public AmrInputStream(InputStream inputStream) {
        this.mInputStream = inputStream;
        MediaFormat format = new MediaFormat();
        format.setString("mime", "audio/3gpp");
        format.setInteger("sample-rate", 8000);
        format.setInteger("channel-count", 1);
        format.setInteger("bitrate", 12200);
        MediaCodecList mcl = new MediaCodecList(0);
        String name = mcl.findEncoderForFormat(format);
        if (name != null) {
            try {
                this.mCodec = MediaCodec.createByCodecName(name);
                this.mCodec.configure(format, null, null, 1);
                this.mCodec.start();
            }
            catch (IOException e) {
                if (this.mCodec != null) {
                    this.mCodec.release();
                }
                this.mCodec = null;
            }
        }
        this.mInfo = new MediaCodec.BufferInfo();
    }

    @Override
    public int read() throws IOException {
        int rtn = this.read(this.mOneByte, 0, 1);
        return rtn == 1 ? 0xFF & this.mOneByte[0] : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.mCodec == null) {
            throw new IllegalStateException("not open");
        }
        if (this.mBufOut >= this.mBufIn && !this.mSawOutputEOS) {
            int index;
            this.mBufOut = 0;
            this.mBufIn = 0;
            while (!this.mSawInputEOS && (index = this.mCodec.dequeueInputBuffer(0L)) >= 0) {
                int numRead;
                int n;
                for (numRead = 0; numRead < 320; numRead += n) {
                    n = this.mInputStream.read(this.mBuf, numRead, 320 - numRead);
                    if (n != -1) continue;
                    this.mSawInputEOS = true;
                    break;
                }
                ByteBuffer buf = this.mCodec.getInputBuffer(index);
                buf.put(this.mBuf, 0, numRead);
                this.mCodec.queueInputBuffer(index, 0, numRead, 0L, this.mSawInputEOS ? 4 : 0);
            }
            while ((index = this.mCodec.dequeueOutputBuffer(this.mInfo, -1L)) < 0) {
            }
            this.mBufIn = this.mInfo.size;
            ByteBuffer out = this.mCodec.getOutputBuffer(index);
            out.get(this.mBuf, 0, this.mBufIn);
            this.mCodec.releaseOutputBuffer(index, false);
            if ((this.mInfo.flags & 4) != 0) {
                this.mSawOutputEOS = true;
            }
        }
        if (this.mBufOut < this.mBufIn) {
            if (length > this.mBufIn - this.mBufOut) {
                length = this.mBufIn - this.mBufOut;
            }
            System.arraycopy((byte[])this.mBuf, (int)this.mBufOut, (byte[])b, (int)offset, (int)length);
            this.mBufOut += length;
            return length;
        }
        if (this.mSawInputEOS && this.mSawOutputEOS) {
            return -1;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        finally {
            this.mInputStream = null;
            try {
                if (this.mCodec != null) {
                    this.mCodec.release();
                }
            }
            finally {
                this.mCodec = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.mCodec != null) {
            Log.w(TAG, "AmrInputStream wasn't closed");
            this.mCodec.release();
        }
    }
}

