/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.weaver.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class WeaverConfig {
    public int slots;
    public int keySize;
    public int valueSize;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != WeaverConfig.class) {
            return false;
        }
        WeaverConfig other = (WeaverConfig)otherObject;
        if (this.slots != other.slots) {
            return false;
        }
        if (this.keySize != other.keySize) {
            return false;
        }
        return this.valueSize == other.valueSize;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.slots), HidlSupport.deepHashCode(this.keySize), HidlSupport.deepHashCode(this.valueSize));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".slots = ");
        builder.append(this.slots);
        builder.append(", .keySize = ");
        builder.append(this.keySize);
        builder.append(", .valueSize = ");
        builder.append(this.valueSize);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(12L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<WeaverConfig> readVectorFromParcel(HwParcel parcel) {
        ArrayList<WeaverConfig> _hidl_vec = new ArrayList<WeaverConfig>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 12, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            WeaverConfig _hidl_vec_element = new WeaverConfig();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 12);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.slots = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.keySize = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.valueSize = _hidl_blob.getInt32(_hidl_offset + 8L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(12);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<WeaverConfig> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 12);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 12);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.slots);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.keySize);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.valueSize);
    }
}

