/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.weaver.V1_0;

import android.hardware.weaver.V1_0.WeaverConfig;
import android.hardware.weaver.V1_0.WeaverReadResponse;
import android.hidl.base.V1_0.DebugInfo;
import android.hidl.base.V1_0.IBase;
import android.os.HwBinder;
import android.os.HwBlob;
import android.os.HwParcel;
import android.os.IHwBinder;
import android.os.IHwInterface;
import android.os.RemoteException;
import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public interface IWeaver
extends IBase {
    public static final String kInterfaceName = "android.hardware.weaver@1.0::IWeaver";

    public static IWeaver asInterface(IHwBinder binder) {
        if (binder == null) {
            return null;
        }
        IHwInterface iface = binder.queryLocalInterface(kInterfaceName);
        if (iface != null && iface instanceof IWeaver) {
            return (IWeaver)iface;
        }
        Proxy proxy = new Proxy(binder);
        for (String descriptor : proxy.interfaceChain()) {
            if (descriptor.equals(kInterfaceName)) {
                return proxy;
            }
            try {
            }
            catch (RemoteException remoteException) {
                // empty catch block
                break;
            }
        }
        return null;
    }

    public static IWeaver castFrom(IHwInterface iface) {
        return iface == null ? null : IWeaver.asInterface(iface.asBinder());
    }

    @Override
    public IHwBinder asBinder();

    public static IWeaver getService(String serviceName) throws RemoteException {
        return IWeaver.asInterface(HwBinder.getService(kInterfaceName, serviceName));
    }

    public static IWeaver getService() throws RemoteException {
        return IWeaver.asInterface(HwBinder.getService(kInterfaceName, "default"));
    }

    public void getConfig(getConfigCallback var1) throws RemoteException;

    public int write(int var1, ArrayList<Byte> var2, ArrayList<Byte> var3) throws RemoteException;

    public void read(int var1, ArrayList<Byte> var2, readCallback var3) throws RemoteException;

    @Override
    public ArrayList<String> interfaceChain() throws RemoteException;

    @Override
    public String interfaceDescriptor() throws RemoteException;

    @Override
    public ArrayList<byte[]> getHashChain() throws RemoteException;

    @Override
    public void setHALInstrumentation() throws RemoteException;

    @Override
    public boolean linkToDeath(IHwBinder.DeathRecipient var1, long var2) throws RemoteException;

    @Override
    public void ping() throws RemoteException;

    @Override
    public DebugInfo getDebugInfo() throws RemoteException;

    @Override
    public void notifySyspropsChanged() throws RemoteException;

    @Override
    public boolean unlinkToDeath(IHwBinder.DeathRecipient var1) throws RemoteException;

    public static abstract class Stub
    extends HwBinder
    implements IWeaver {
        @Override
        public IHwBinder asBinder() {
            return this;
        }

        @Override
        public final ArrayList<String> interfaceChain() {
            return new ArrayList<String>(Arrays.asList(IWeaver.kInterfaceName, "android.hidl.base@1.0::IBase"));
        }

        @Override
        public final String interfaceDescriptor() {
            return IWeaver.kInterfaceName;
        }

        @Override
        public final ArrayList<byte[]> getHashChain() {
            return new ArrayList<byte[]>(Arrays.asList({-101, -60, 52, 19, -72, 12, -48, -59, -102, 2, 46, -109, -38, 20, 72, -36, -72, 45, -47, 12, 109, -45, 25, 50, -33, 70, 89, -28, -67, -53, 19, 104}, {-67, -38, -74, 24, 77, 122, 52, 109, -90, -96, 125, -64, -126, -116, -15, -102, 105, 111, 76, -86, 54, 17, -59, 31, 46, 20, 86, 90, 20, -76, 15, -39}));
        }

        @Override
        public final void setHALInstrumentation() {
        }

        @Override
        public final boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) {
            return true;
        }

        @Override
        public final void ping() {
        }

        @Override
        public final DebugInfo getDebugInfo() {
            DebugInfo info = new DebugInfo();
            info.pid = -1;
            info.ptr = 0L;
            info.arch = 0;
            return info;
        }

        @Override
        public final void notifySyspropsChanged() {
            SystemProperties.reportSyspropChanged();
        }

        @Override
        public final boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) {
            return true;
        }

        @Override
        public IHwInterface queryLocalInterface(String descriptor) {
            if (IWeaver.kInterfaceName.equals(descriptor)) {
                return this;
            }
            return null;
        }

        public void registerAsService(String serviceName) throws RemoteException {
            this.registerService(serviceName);
        }

        public String toString() {
            return this.interfaceDescriptor() + "@Stub";
        }

        @Override
        public void onTransact(int _hidl_code, HwParcel _hidl_request, final HwParcel _hidl_reply, int _hidl_flags) throws RemoteException {
            switch (_hidl_code) {
                case 1: {
                    _hidl_request.enforceInterface(IWeaver.kInterfaceName);
                    this.getConfig(new getConfigCallback(){

                        @Override
                        public void onValues(int status, WeaverConfig config) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeInt32(status);
                            config.writeToParcel(_hidl_reply);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 2: {
                    _hidl_request.enforceInterface(IWeaver.kInterfaceName);
                    int slotId = _hidl_request.readInt32();
                    ArrayList<Byte> key = _hidl_request.readInt8Vector();
                    ArrayList<Byte> value = _hidl_request.readInt8Vector();
                    int _hidl_out_status = this.write(slotId, key, value);
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeInt32(_hidl_out_status);
                    _hidl_reply.send();
                    break;
                }
                case 3: {
                    _hidl_request.enforceInterface(IWeaver.kInterfaceName);
                    int slotId = _hidl_request.readInt32();
                    ArrayList<Byte> key = _hidl_request.readInt8Vector();
                    this.read(slotId, key, new readCallback(){

                        @Override
                        public void onValues(int status, WeaverReadResponse readResponse) {
                            _hidl_reply.writeStatus(0);
                            _hidl_reply.writeInt32(status);
                            readResponse.writeToParcel(_hidl_reply);
                            _hidl_reply.send();
                        }
                    });
                    break;
                }
                case 256067662: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<String> _hidl_out_descriptors = this.interfaceChain();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeStringVector(_hidl_out_descriptors);
                    _hidl_reply.send();
                    break;
                }
                case 256131655: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.send();
                    break;
                }
                case 256136003: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    String _hidl_out_descriptor = this.interfaceDescriptor();
                    _hidl_reply.writeStatus(0);
                    _hidl_reply.writeString(_hidl_out_descriptor);
                    _hidl_reply.send();
                    break;
                }
                case 256398152: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    ArrayList<byte[]> _hidl_out_hashchain = this.getHashChain();
                    _hidl_reply.writeStatus(0);
                    HwBlob _hidl_blob = new HwBlob(16);
                    int _hidl_vec_size = _hidl_out_hashchain.size();
                    _hidl_blob.putInt32(8L, _hidl_vec_size);
                    _hidl_blob.putBool(12L, false);
                    HwBlob childBlob = new HwBlob(_hidl_vec_size * 32);
                    for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                        long _hidl_array_offset_1 = _hidl_index_0 * 32;
                        for (int _hidl_index_1_0 = 0; _hidl_index_1_0 < 32; ++_hidl_index_1_0) {
                            childBlob.putInt8(_hidl_array_offset_1, _hidl_out_hashchain.get(_hidl_index_0)[_hidl_index_1_0]);
                            ++_hidl_array_offset_1;
                        }
                    }
                    _hidl_blob.putBlob(0L, childBlob);
                    _hidl_reply.writeBuffer(_hidl_blob);
                    _hidl_reply.send();
                    break;
                }
                case 256462420: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.setHALInstrumentation();
                    break;
                }
                case 256660548: {
                    break;
                }
                case 256921159: {
                    break;
                }
                case 257049926: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    DebugInfo _hidl_out_info = this.getDebugInfo();
                    _hidl_reply.writeStatus(0);
                    _hidl_out_info.writeToParcel(_hidl_reply);
                    _hidl_reply.send();
                    break;
                }
                case 257120595: {
                    _hidl_request.enforceInterface("android.hidl.base@1.0::IBase");
                    this.notifySyspropsChanged();
                    break;
                }
            }
        }
    }

    public static final class Proxy
    implements IWeaver {
        private IHwBinder mRemote;

        public Proxy(IHwBinder remote) {
            this.mRemote = Objects.requireNonNull(remote);
        }

        @Override
        public IHwBinder asBinder() {
            return this.mRemote;
        }

        public String toString() {
            try {
                return this.interfaceDescriptor() + "@Proxy";
            }
            catch (RemoteException remoteException) {
                return "[class or subclass of android.hardware.weaver@1.0::IWeaver]@Proxy";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getConfig(getConfigCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IWeaver.kInterfaceName);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(1, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int _hidl_out_status = _hidl_reply.readInt32();
                WeaverConfig _hidl_out_config = new WeaverConfig();
                _hidl_out_config.readFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_config);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(int slotId, ArrayList<Byte> key, ArrayList<Byte> value) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IWeaver.kInterfaceName);
            _hidl_request.writeInt32(slotId);
            _hidl_request.writeInt8Vector(key);
            _hidl_request.writeInt8Vector(value);
            HwParcel _hidl_reply = new HwParcel();
            try {
                int _hidl_out_status;
                this.mRemote.transact(2, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int n = _hidl_out_status = _hidl_reply.readInt32();
                return n;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read(int slotId, ArrayList<Byte> key, readCallback _hidl_cb) throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken(IWeaver.kInterfaceName);
            _hidl_request.writeInt32(slotId);
            _hidl_request.writeInt8Vector(key);
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(3, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                int _hidl_out_status = _hidl_reply.readInt32();
                WeaverReadResponse _hidl_out_readResponse = new WeaverReadResponse();
                _hidl_out_readResponse.readFromParcel(_hidl_reply);
                _hidl_cb.onValues(_hidl_out_status, _hidl_out_readResponse);
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<String> interfaceChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                ArrayList<String> _hidl_out_descriptors;
                this.mRemote.transact(256067662, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<String> arrayList = _hidl_out_descriptors = _hidl_reply.readStringVector();
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String interfaceDescriptor() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                String _hidl_out_descriptor;
                this.mRemote.transact(256136003, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                String string2 = _hidl_out_descriptor = _hidl_reply.readString();
                return string2;
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList<byte[]> getHashChain() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256398152, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                ArrayList<byte[]> _hidl_out_hashchain = new ArrayList<byte[]>();
                HwBlob _hidl_blob = _hidl_reply.readBuffer(16L);
                int _hidl_vec_size = _hidl_blob.getInt32(8L);
                HwBlob childBlob = _hidl_reply.readEmbeddedBuffer(_hidl_vec_size * 32, _hidl_blob.handle(), 0L, true);
                _hidl_out_hashchain.clear();
                for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
                    byte[] _hidl_vec_element = new byte[32];
                    long _hidl_array_offset_1 = _hidl_index_0 * 32;
                    for (int _hidl_index_1_0 = 0; _hidl_index_1_0 < 32; ++_hidl_index_1_0) {
                        _hidl_vec_element[_hidl_index_1_0] = childBlob.getInt8(_hidl_array_offset_1);
                        ++_hidl_array_offset_1;
                    }
                    _hidl_out_hashchain.add(_hidl_vec_element);
                }
                ArrayList<byte[]> arrayList = _hidl_out_hashchain;
                return arrayList;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void setHALInstrumentation() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256462420, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean linkToDeath(IHwBinder.DeathRecipient recipient, long cookie) throws RemoteException {
            return this.mRemote.linkToDeath(recipient, cookie);
        }

        @Override
        public void ping() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(256921159, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DebugInfo getDebugInfo() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257049926, _hidl_request, _hidl_reply, 0);
                _hidl_reply.verifySuccess();
                _hidl_request.releaseTemporaryStorage();
                DebugInfo _hidl_out_info = new DebugInfo();
                _hidl_out_info.readFromParcel(_hidl_reply);
                DebugInfo debugInfo = _hidl_out_info;
                return debugInfo;
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public void notifySyspropsChanged() throws RemoteException {
            HwParcel _hidl_request = new HwParcel();
            _hidl_request.writeInterfaceToken("android.hidl.base@1.0::IBase");
            HwParcel _hidl_reply = new HwParcel();
            try {
                this.mRemote.transact(257120595, _hidl_request, _hidl_reply, 1);
                _hidl_request.releaseTemporaryStorage();
            }
            finally {
                _hidl_reply.release();
            }
        }

        @Override
        public boolean unlinkToDeath(IHwBinder.DeathRecipient recipient) throws RemoteException {
            return this.mRemote.unlinkToDeath(recipient);
        }
    }

    @FunctionalInterface
    public static interface readCallback {
        public void onValues(int var1, WeaverReadResponse var2);
    }

    @FunctionalInterface
    public static interface getConfigCallback {
        public void onValues(int var1, WeaverConfig var2);
    }
}

