/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.soundtrigger;

import android.hardware.soundtrigger.SoundTrigger;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;

public class SoundTriggerModule {
    private long mNativeContext;
    private int mId;
    private NativeEventHandlerDelegate mEventHandlerDelegate;
    private static final int EVENT_RECOGNITION = 1;
    private static final int EVENT_SERVICE_DIED = 2;
    private static final int EVENT_SOUNDMODEL = 3;
    private static final int EVENT_SERVICE_STATE_CHANGE = 4;

    SoundTriggerModule(int moduleId, SoundTrigger.StatusListener listener, Handler handler) {
        this.mId = moduleId;
        this.mEventHandlerDelegate = new NativeEventHandlerDelegate(listener, handler);
        this.native_setup(new WeakReference<SoundTriggerModule>(this));
    }

    private native void native_setup(Object var1);

    protected void finalize() {
        this.native_finalize();
    }

    private native void native_finalize();

    public native void detach();

    public native int loadSoundModel(SoundTrigger.SoundModel var1, int[] var2);

    public native int unloadSoundModel(int var1);

    public native int startRecognition(int var1, SoundTrigger.RecognitionConfig var2);

    public native int stopRecognition(int var1);

    private static void postEventFromNative(Object module_ref, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        SoundTriggerModule module = (SoundTriggerModule)((WeakReference)module_ref).get();
        if (module == null) {
            return;
        }
        NativeEventHandlerDelegate delegate = module.mEventHandlerDelegate;
        if (delegate != null && (handler = delegate.handler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            handler.sendMessage(m);
        }
    }

    private class NativeEventHandlerDelegate {
        private final Handler mHandler;

        NativeEventHandlerDelegate(final SoundTrigger.StatusListener listener, Handler handler) {
            Looper looper = handler != null ? handler.getLooper() : Looper.getMainLooper();
            this.mHandler = looper != null ? new Handler(looper){

                @Override
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            if (listener == null) break;
                            listener.onRecognition((SoundTrigger.RecognitionEvent)msg.obj);
                            break;
                        }
                        case 3: {
                            if (listener == null) break;
                            listener.onSoundModelUpdate((SoundTrigger.SoundModelEvent)msg.obj);
                            break;
                        }
                        case 4: {
                            if (listener == null) break;
                            listener.onServiceStateChange(msg.arg1);
                            break;
                        }
                        case 2: {
                            if (listener == null) break;
                            listener.onServiceDied();
                            break;
                        }
                    }
                }
            } : null;
        }

        Handler handler() {
            return this.mHandler;
        }
    }
}

