/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CdmaSignalInfoRecord {
    public boolean isPresent;
    public byte signalType;
    public byte alertPitch;
    public byte signal;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CdmaSignalInfoRecord.class) {
            return false;
        }
        CdmaSignalInfoRecord other = (CdmaSignalInfoRecord)otherObject;
        if (this.isPresent != other.isPresent) {
            return false;
        }
        if (this.signalType != other.signalType) {
            return false;
        }
        if (this.alertPitch != other.alertPitch) {
            return false;
        }
        return this.signal == other.signal;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.isPresent), HidlSupport.deepHashCode(this.signalType), HidlSupport.deepHashCode(this.alertPitch), HidlSupport.deepHashCode(this.signal));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".isPresent = ");
        builder.append(this.isPresent);
        builder.append(", .signalType = ");
        builder.append(this.signalType);
        builder.append(", .alertPitch = ");
        builder.append(this.alertPitch);
        builder.append(", .signal = ");
        builder.append(this.signal);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(4L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CdmaSignalInfoRecord> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CdmaSignalInfoRecord> _hidl_vec = new ArrayList<CdmaSignalInfoRecord>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 4, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CdmaSignalInfoRecord _hidl_vec_element = new CdmaSignalInfoRecord();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 4);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.isPresent = _hidl_blob.getBool(_hidl_offset + 0L);
        this.signalType = _hidl_blob.getInt8(_hidl_offset + 1L);
        this.alertPitch = _hidl_blob.getInt8(_hidl_offset + 2L);
        this.signal = _hidl_blob.getInt8(_hidl_offset + 3L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(4);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CdmaSignalInfoRecord> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 4);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 4);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putBool(_hidl_offset + 0L, this.isPresent);
        _hidl_blob.putInt8(_hidl_offset + 1L, this.signalType);
        _hidl_blob.putInt8(_hidl_offset + 2L, this.alertPitch);
        _hidl_blob.putInt8(_hidl_offset + 3L, this.signal);
    }
}

