/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class CdmaNumberInfoRecord {
    public String number = new String();
    public byte numberType;
    public byte numberPlan;
    public byte pi;
    public byte si;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != CdmaNumberInfoRecord.class) {
            return false;
        }
        CdmaNumberInfoRecord other = (CdmaNumberInfoRecord)otherObject;
        if (!HidlSupport.deepEquals(this.number, other.number)) {
            return false;
        }
        if (this.numberType != other.numberType) {
            return false;
        }
        if (this.numberPlan != other.numberPlan) {
            return false;
        }
        if (this.pi != other.pi) {
            return false;
        }
        return this.si == other.si;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.number), HidlSupport.deepHashCode(this.numberType), HidlSupport.deepHashCode(this.numberPlan), HidlSupport.deepHashCode(this.pi), HidlSupport.deepHashCode(this.si));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".number = ");
        builder.append(this.number);
        builder.append(", .numberType = ");
        builder.append(this.numberType);
        builder.append(", .numberPlan = ");
        builder.append(this.numberPlan);
        builder.append(", .pi = ");
        builder.append(this.pi);
        builder.append(", .si = ");
        builder.append(this.si);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<CdmaNumberInfoRecord> readVectorFromParcel(HwParcel parcel) {
        ArrayList<CdmaNumberInfoRecord> _hidl_vec = new ArrayList<CdmaNumberInfoRecord>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            CdmaNumberInfoRecord _hidl_vec_element = new CdmaNumberInfoRecord();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.number = _hidl_blob.getString(_hidl_offset + 0L);
        parcel.readEmbeddedBuffer(this.number.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 0L + 0L, false);
        this.numberType = _hidl_blob.getInt8(_hidl_offset + 16L);
        this.numberPlan = _hidl_blob.getInt8(_hidl_offset + 17L);
        this.pi = _hidl_blob.getInt8(_hidl_offset + 18L);
        this.si = _hidl_blob.getInt8(_hidl_offset + 19L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<CdmaNumberInfoRecord> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putString(_hidl_offset + 0L, this.number);
        _hidl_blob.putInt8(_hidl_offset + 16L, this.numberType);
        _hidl_blob.putInt8(_hidl_offset + 17L, this.numberPlan);
        _hidl_blob.putInt8(_hidl_offset + 18L, this.pi);
        _hidl_blob.putInt8(_hidl_offset + 19L, this.si);
    }
}

