/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio.V1_0;

import android.hardware.radio.V1_0.AppState;
import android.hardware.radio.V1_0.AppType;
import android.hardware.radio.V1_0.PersoSubstate;
import android.hardware.radio.V1_0.PinState;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class AppStatus {
    public int appType;
    public int appState;
    public int persoSubstate;
    public String aidPtr = new String();
    public String appLabelPtr = new String();
    public int pin1Replaced;
    public int pin1;
    public int pin2;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != AppStatus.class) {
            return false;
        }
        AppStatus other = (AppStatus)otherObject;
        if (this.appType != other.appType) {
            return false;
        }
        if (this.appState != other.appState) {
            return false;
        }
        if (this.persoSubstate != other.persoSubstate) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.aidPtr, other.aidPtr)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.appLabelPtr, other.appLabelPtr)) {
            return false;
        }
        if (this.pin1Replaced != other.pin1Replaced) {
            return false;
        }
        if (this.pin1 != other.pin1) {
            return false;
        }
        return this.pin2 == other.pin2;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.appType), HidlSupport.deepHashCode(this.appState), HidlSupport.deepHashCode(this.persoSubstate), HidlSupport.deepHashCode(this.aidPtr), HidlSupport.deepHashCode(this.appLabelPtr), HidlSupport.deepHashCode(this.pin1Replaced), HidlSupport.deepHashCode(this.pin1), HidlSupport.deepHashCode(this.pin2));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".appType = ");
        builder.append(AppType.toString(this.appType));
        builder.append(", .appState = ");
        builder.append(AppState.toString(this.appState));
        builder.append(", .persoSubstate = ");
        builder.append(PersoSubstate.toString(this.persoSubstate));
        builder.append(", .aidPtr = ");
        builder.append(this.aidPtr);
        builder.append(", .appLabelPtr = ");
        builder.append(this.appLabelPtr);
        builder.append(", .pin1Replaced = ");
        builder.append(this.pin1Replaced);
        builder.append(", .pin1 = ");
        builder.append(PinState.toString(this.pin1));
        builder.append(", .pin2 = ");
        builder.append(PinState.toString(this.pin2));
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(64L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<AppStatus> readVectorFromParcel(HwParcel parcel) {
        ArrayList<AppStatus> _hidl_vec = new ArrayList<AppStatus>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 64, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            AppStatus _hidl_vec_element = new AppStatus();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 64);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.appType = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.appState = _hidl_blob.getInt32(_hidl_offset + 4L);
        this.persoSubstate = _hidl_blob.getInt32(_hidl_offset + 8L);
        this.aidPtr = _hidl_blob.getString(_hidl_offset + 16L);
        parcel.readEmbeddedBuffer(this.aidPtr.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 16L + 0L, false);
        this.appLabelPtr = _hidl_blob.getString(_hidl_offset + 32L);
        parcel.readEmbeddedBuffer(this.appLabelPtr.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 32L + 0L, false);
        this.pin1Replaced = _hidl_blob.getInt32(_hidl_offset + 48L);
        this.pin1 = _hidl_blob.getInt32(_hidl_offset + 52L);
        this.pin2 = _hidl_blob.getInt32(_hidl_offset + 56L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(64);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<AppStatus> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 64);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 64);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.appType);
        _hidl_blob.putInt32(_hidl_offset + 4L, this.appState);
        _hidl_blob.putInt32(_hidl_offset + 8L, this.persoSubstate);
        _hidl_blob.putString(_hidl_offset + 16L, this.aidPtr);
        _hidl_blob.putString(_hidl_offset + 32L, this.appLabelPtr);
        _hidl_blob.putInt32(_hidl_offset + 48L, this.pin1Replaced);
        _hidl_blob.putInt32(_hidl_offset + 52L, this.pin1);
        _hidl_blob.putInt32(_hidl_offset + 56L, this.pin2);
    }
}

