/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatedRotateDrawable
extends DrawableWrapper
implements Animatable {
    private AnimatedRotateState mState;
    private float mCurrentDegrees;
    private float mIncrement;
    private boolean mRunning;
    private final Runnable mNextFrame = new Runnable(){

        @Override
        public void run() {
            AnimatedRotateDrawable.this.mCurrentDegrees = AnimatedRotateDrawable.this.mCurrentDegrees + AnimatedRotateDrawable.this.mIncrement;
            if (AnimatedRotateDrawable.this.mCurrentDegrees > 360.0f - AnimatedRotateDrawable.this.mIncrement) {
                AnimatedRotateDrawable.this.mCurrentDegrees = 0.0f;
            }
            AnimatedRotateDrawable.this.invalidateSelf();
            AnimatedRotateDrawable.this.nextFrame();
        }
    };

    public AnimatedRotateDrawable() {
        this(new AnimatedRotateState(null, null), null);
    }

    @Override
    public void draw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        Rect bounds = drawable2.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        AnimatedRotateState st = this.mState;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        int saveCount = canvas.save();
        canvas.rotate(this.mCurrentDegrees, px + (float)bounds.left, py + (float)bounds.top);
        drawable2.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    @Override
    public void start() {
        if (!this.mRunning) {
            this.mRunning = true;
            this.nextFrame();
        }
    }

    @Override
    public void stop() {
        this.mRunning = false;
        this.unscheduleSelf(this.mNextFrame);
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    private void nextFrame() {
        this.unscheduleSelf(this.mNextFrame);
        this.scheduleSelf(this.mNextFrame, SystemClock.uptimeMillis() + (long)this.mState.mFrameDuration);
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (visible) {
            if (changed || restart) {
                this.mCurrentDegrees = 0.0f;
                this.nextFrame();
            }
        } else {
            this.unscheduleSelf(this.mNextFrame);
        }
        return changed;
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = AnimatedRotateDrawable.obtainAttributes(r, theme, attrs, R.styleable.AnimatedRotateDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
        this.updateLocalState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        AnimatedRotateState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.AnimatedRotateDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                AnimatedRotateDrawable.rethrowAsRuntimeException(e);
            }
            finally {
                a.recycle();
            }
        }
        this.updateLocalState();
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <animated-rotate> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private void updateStateFromTypedArray(TypedArray a) {
        TypedValue tv;
        AnimatedRotateState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        AnimatedRotateState.access$002(state, a.extractThemeAttrs());
        if (a.hasValue(2)) {
            tv = a.peekValue(2);
            state.mPivotXRel = tv.type == 6;
            float f = state.mPivotX = state.mPivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        if (a.hasValue(3)) {
            tv = a.peekValue(3);
            state.mPivotYRel = tv.type == 6;
            state.mPivotY = state.mPivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        this.setFramesCount(a.getInt(5, state.mFramesCount));
        this.setFramesDuration(a.getInt(4, state.mFrameDuration));
    }

    public void setFramesCount(int framesCount) {
        this.mState.mFramesCount = framesCount;
        this.mIncrement = 360.0f / (float)this.mState.mFramesCount;
    }

    public void setFramesDuration(int framesDuration) {
        this.mState.mFrameDuration = framesDuration;
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new AnimatedRotateState(this.mState, null);
        return this.mState;
    }

    private AnimatedRotateDrawable(AnimatedRotateState state, Resources res) {
        super(state, res);
        this.mState = state;
        this.updateLocalState();
    }

    private void updateLocalState() {
        AnimatedRotateState state = this.mState;
        this.mIncrement = 360.0f / (float)state.mFramesCount;
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            drawable2.setFilterBitmap(true);
            if (drawable2 instanceof BitmapDrawable) {
                ((BitmapDrawable)drawable2).setAntiAlias(true);
            }
        }
    }

    static final class AnimatedRotateState
    extends DrawableWrapper.DrawableWrapperState {
        private int[] mThemeAttrs;
        boolean mPivotXRel = false;
        float mPivotX = 0.0f;
        boolean mPivotYRel = false;
        float mPivotY = 0.0f;
        int mFrameDuration = 150;
        int mFramesCount = 12;

        public AnimatedRotateState(AnimatedRotateState orig, Resources res) {
            super(orig, res);
            if (orig != null) {
                this.mPivotXRel = orig.mPivotXRel;
                this.mPivotX = orig.mPivotX;
                this.mPivotYRel = orig.mPivotYRel;
                this.mPivotY = orig.mPivotY;
                this.mFramesCount = orig.mFramesCount;
                this.mFrameDuration = orig.mFrameDuration;
            }
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new AnimatedRotateDrawable(this, res);
        }

        static /* synthetic */ int[] access$002(AnimatedRotateState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }
    }
}

