/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;

public class PathMeasure {
    private Path mPath;
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    private long native_instance;

    public PathMeasure() {
        this.mPath = null;
        this.native_instance = PathMeasure.native_create(0L, false);
    }

    public PathMeasure(Path path, boolean forceClosed) {
        this.mPath = path;
        this.native_instance = PathMeasure.native_create(path != null ? path.readOnlyNI() : 0L, forceClosed);
    }

    public void setPath(Path path, boolean forceClosed) {
        this.mPath = path;
        PathMeasure.native_setPath(this.native_instance, path != null ? path.readOnlyNI() : 0L, forceClosed);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getPosTan(float distance, float[] pos, float[] tan) {
        if (pos != null && pos.length < 2 || tan != null && tan.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, distance, pos, tan);
    }

    public boolean getMatrix(float distance, Matrix matrix, int flags) {
        return PathMeasure.native_getMatrix(this.native_instance, distance, matrix.native_instance, flags);
    }

    public boolean getSegment(float startD, float stopD, Path dst, boolean startWithMoveTo) {
        float length = this.getLength();
        if (startD < 0.0f) {
            startD = 0.0f;
        }
        if (stopD > length) {
            stopD = length;
        }
        if (startD >= stopD) {
            return false;
        }
        return PathMeasure.native_getSegment(this.native_instance, startD, stopD, dst.mutateNI(), startWithMoveTo);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    protected void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
        this.native_instance = 0L;
    }

    private static native long native_create(long var0, boolean var2);

    private static native void native_setPath(long var0, long var2, boolean var4);

    private static native float native_getLength(long var0);

    private static native boolean native_getPosTan(long var0, float var2, float[] var3, float[] var4);

    private static native boolean native_getMatrix(long var0, float var2, long var3, int var5);

    private static native boolean native_getSegment(long var0, float var2, float var3, long var4, boolean var6);

    private static native boolean native_isClosed(long var0);

    private static native boolean native_nextContour(long var0);

    private static native void native_destroy(long var0);
}

