/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;

public class VignetteFilter
extends Filter {
    @GenerateFieldPort(name="scale", hasDefault=true)
    private float mScale = 0.0f;
    @GenerateFieldPort(name="tile_size", hasDefault=true)
    private int mTileSize = 640;
    private Program mProgram;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mTarget = 0;
    private final float mSlope = 20.0f;
    private final float mShade = 0.85f;
    private final String mVignetteShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float range;\nuniform float inv_max_dist;\nuniform float shade;\nuniform vec2 scale;\nvarying vec2 v_texcoord;\nvoid main() {\n  const float slope = 20.0;\n  vec2 coord = v_texcoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float lumen = shade / (1.0 + exp((dist * inv_max_dist - range) * slope)) + (1.0 - shade);\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  gl_FragColor = vec4(color.rgb * lumen, color.a);\n}\n";

    public VignetteFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addOutputBasedOnInput("image", "image");
    }

    @Override
    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    public void initProgram(FilterContext context, int target) {
        switch (target) {
            case 3: {
                ShaderProgram shaderProgram = new ShaderProgram(context, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nuniform float range;\nuniform float inv_max_dist;\nuniform float shade;\nuniform vec2 scale;\nvarying vec2 v_texcoord;\nvoid main() {\n  const float slope = 20.0;\n  vec2 coord = v_texcoord - vec2(0.5, 0.5);\n  float dist = length(coord * scale);\n  float lumen = shade / (1.0 + exp((dist * inv_max_dist - range) * slope)) + (1.0 - shade);\n  vec4 color = texture2D(tex_sampler_0, v_texcoord);\n  gl_FragColor = vec4(color.rgb * lumen, color.a);\n}\n");
                shaderProgram.setMaximumTileSize(this.mTileSize);
                this.mProgram = shaderProgram;
                break;
            }
            default: {
                throw new RuntimeException("Filter Sharpen does not support frames of target " + target + "!");
            }
        }
        this.mTarget = target;
    }

    private void initParameters() {
        if (this.mProgram != null) {
            float[] scale = new float[2];
            if (this.mWidth > this.mHeight) {
                scale[0] = 1.0f;
                scale[1] = (float)this.mHeight / (float)this.mWidth;
            } else {
                scale[0] = (float)this.mWidth / (float)this.mHeight;
                scale[1] = 1.0f;
            }
            float max_dist = (float)Math.sqrt(scale[0] * scale[0] + scale[1] * scale[1]) * 0.5f;
            this.mProgram.setHostValue("scale", scale);
            this.mProgram.setHostValue("inv_max_dist", Float.valueOf(1.0f / max_dist));
            this.mProgram.setHostValue("shade", Float.valueOf(0.85f));
            this.updateParameters();
        }
    }

    private void updateParameters() {
        this.mProgram.setHostValue("range", Float.valueOf(1.3f - (float)Math.sqrt(this.mScale) * 0.7f));
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (this.mProgram != null) {
            this.updateParameters();
        }
    }

    @Override
    public void process(FilterContext context) {
        Frame input = this.pullInput("image");
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null || inputFormat.getTarget() != this.mTarget) {
            this.initProgram(context, inputFormat.getTarget());
        }
        if (inputFormat.getWidth() != this.mWidth || inputFormat.getHeight() != this.mHeight) {
            this.mWidth = inputFormat.getWidth();
            this.mHeight = inputFormat.getHeight();
            this.initParameters();
        }
        Frame output = context.getFrameManager().newFrame(inputFormat);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }
}

