/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;

public class FixedRotationFilter
extends Filter {
    @GenerateFieldPort(name="rotation", hasDefault=true)
    private int mRotation = 0;
    private ShaderProgram mProgram = null;

    public FixedRotationFilter(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }

    @Override
    public FrameFormat getOutputFormat(String portName, FrameFormat inputFormat) {
        return inputFormat;
    }

    @Override
    public void process(FilterContext context) {
        Quad sourceRegion;
        Frame input = this.pullInput("image");
        if (this.mRotation == 0) {
            this.pushOutput("image", input);
            return;
        }
        FrameFormat inputFormat = input.getFormat();
        if (this.mProgram == null) {
            this.mProgram = ShaderProgram.createIdentity(context);
        }
        MutableFrameFormat outputFormat = inputFormat.mutableCopy();
        int width = inputFormat.getWidth();
        int height = inputFormat.getHeight();
        Point p1 = new Point(0.0f, 0.0f);
        Point p2 = new Point(1.0f, 0.0f);
        Point p3 = new Point(0.0f, 1.0f);
        Point p4 = new Point(1.0f, 1.0f);
        switch (Math.round((float)this.mRotation / 90.0f) % 4) {
            case 1: {
                sourceRegion = new Quad(p3, p1, p4, p2);
                outputFormat.setDimensions(height, width);
                break;
            }
            case 2: {
                sourceRegion = new Quad(p4, p3, p2, p1);
                break;
            }
            case 3: {
                sourceRegion = new Quad(p2, p4, p1, p3);
                outputFormat.setDimensions(height, width);
                break;
            }
            default: {
                sourceRegion = new Quad(p1, p2, p3, p4);
            }
        }
        Frame output = context.getFrameManager().newFrame(outputFormat);
        this.mProgram.setSourceRegion(sourceRegion);
        this.mProgram.process(input, output);
        this.pushOutput("image", output);
        output.release();
    }
}

