/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.base;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ObjectFormat;

public class ObjectSource
extends Filter {
    @GenerateFieldPort(name="object")
    private Object mObject;
    @GenerateFinalPort(name="format", hasDefault=true)
    private FrameFormat mOutputFormat = FrameFormat.unspecified();
    @GenerateFieldPort(name="repeatFrame", hasDefault=true)
    boolean mRepeatFrame = false;
    private Frame mFrame;

    public ObjectSource(String name) {
        super(name);
    }

    @Override
    public void setupPorts() {
        this.addOutputPort("frame", this.mOutputFormat);
    }

    @Override
    public void process(FilterContext context) {
        if (this.mFrame == null) {
            if (this.mObject == null) {
                throw new NullPointerException("ObjectSource producing frame with no object set!");
            }
            MutableFrameFormat outputFormat = ObjectFormat.fromObject(this.mObject, 1);
            this.mFrame = context.getFrameManager().newFrame(outputFormat);
            this.mFrame.setObjectValue(this.mObject);
            this.mFrame.setTimestamp(-1L);
        }
        this.pushOutput("frame", this.mFrame);
        if (!this.mRepeatFrame) {
            this.closeOutputPort("frame");
        }
    }

    @Override
    public void tearDown(FilterContext context) {
        this.mFrame.release();
    }

    @Override
    public void fieldPortValueUpdated(String name, FilterContext context) {
        if (name.equals("object") && this.mFrame != null) {
            this.mFrame.release();
            this.mFrame = null;
        }
    }
}

