/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.VertexFrame;

public class SimpleFrameManager
extends FrameManager {
    @Override
    public Frame newFrame(FrameFormat format) {
        return this.createNewFrame(format);
    }

    @Override
    public Frame newBoundFrame(FrameFormat format, int bindingType, long bindingId) {
        GLFrame result = null;
        switch (format.getTarget()) {
            case 3: {
                GLFrame glFrame = new GLFrame(format, this, bindingType, bindingId);
                glFrame.init(this.getGLEnvironment());
                result = glFrame;
                break;
            }
            default: {
                throw new RuntimeException("Attached frames are not supported for target type: " + FrameFormat.targetToString(format.getTarget()) + "!");
            }
        }
        return result;
    }

    private Frame createNewFrame(FrameFormat format) {
        Frame result = null;
        switch (format.getTarget()) {
            case 1: {
                result = new SimpleFrame(format, this);
                break;
            }
            case 2: {
                result = new NativeFrame(format, this);
                break;
            }
            case 3: {
                GLFrame glFrame = new GLFrame(format, this);
                glFrame.init(this.getGLEnvironment());
                result = glFrame;
                break;
            }
            case 4: {
                result = new VertexFrame(format, this);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported frame target type: " + FrameFormat.targetToString(format.getTarget()) + "!");
            }
        }
        return result;
    }

    @Override
    public Frame retainFrame(Frame frame) {
        frame.incRefCount();
        return frame;
    }

    @Override
    public Frame releaseFrame(Frame frame) {
        int refCount = frame.decRefCount();
        if (refCount == 0 && frame.hasNativeAllocation()) {
            frame.releaseNativeAllocation();
            return null;
        }
        if (refCount < 0) {
            throw new RuntimeException("Frame reference count dropped below 0!");
        }
        return frame;
    }
}

