/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.format.ObjectFormat;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public class SimpleFrame
extends Frame {
    private Object mObject;

    SimpleFrame(FrameFormat format, FrameManager frameManager) {
        super(format, frameManager);
        this.initWithFormat(format);
        this.setReusable(false);
    }

    static SimpleFrame wrapObject(Object object, FrameManager frameManager) {
        MutableFrameFormat format = ObjectFormat.fromObject(object, 1);
        SimpleFrame result = new SimpleFrame(format, frameManager);
        result.setObjectValue(object);
        return result;
    }

    private void initWithFormat(FrameFormat format) {
        int count = format.getLength();
        int baseType = format.getBaseType();
        switch (baseType) {
            case 2: {
                this.mObject = new byte[count];
                break;
            }
            case 3: {
                this.mObject = new short[count];
                break;
            }
            case 4: {
                this.mObject = new int[count];
                break;
            }
            case 5: {
                this.mObject = new float[count];
                break;
            }
            case 6: {
                this.mObject = new double[count];
                break;
            }
            default: {
                this.mObject = null;
            }
        }
    }

    @Override
    protected boolean hasNativeAllocation() {
        return false;
    }

    @Override
    protected void releaseNativeAllocation() {
    }

    @Override
    public Object getObjectValue() {
        return this.mObject;
    }

    @Override
    public void setInts(int[] ints) {
        this.assertFrameMutable();
        this.setGenericObjectValue(ints);
    }

    @Override
    public int[] getInts() {
        return this.mObject instanceof int[] ? (int[])this.mObject : null;
    }

    @Override
    public void setFloats(float[] floats) {
        this.assertFrameMutable();
        this.setGenericObjectValue(floats);
    }

    @Override
    public float[] getFloats() {
        return this.mObject instanceof float[] ? (float[])this.mObject : null;
    }

    @Override
    public void setData(ByteBuffer buffer, int offset, int length) {
        this.assertFrameMutable();
        this.setGenericObjectValue(ByteBuffer.wrap(buffer.array(), offset, length));
    }

    @Override
    public ByteBuffer getData() {
        return this.mObject instanceof ByteBuffer ? (ByteBuffer)this.mObject : null;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        this.setGenericObjectValue(bitmap);
    }

    @Override
    public Bitmap getBitmap() {
        return this.mObject instanceof Bitmap ? (Bitmap)this.mObject : null;
    }

    private void setFormatObjectClass(Class objectClass) {
        MutableFrameFormat format = this.getFormat().mutableCopy();
        format.setObjectClass(objectClass);
        this.setFormat(format);
    }

    @Override
    protected void setGenericObjectValue(Object object) {
        FrameFormat format = this.getFormat();
        if (format.getObjectClass() == null) {
            this.setFormatObjectClass(object.getClass());
        } else if (!format.getObjectClass().isAssignableFrom(object.getClass())) {
            throw new RuntimeException("Attempting to set object value of type '" + object.getClass() + "' on SimpleFrame of type '" + format.getObjectClass() + "'!");
        }
        this.mObject = object;
    }

    public String toString() {
        return "SimpleFrame (" + this.getFormat() + ")";
    }
}

