/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.Program;

public class NativeProgram
extends Program {
    private int nativeProgramId;
    private boolean mHasInitFunction = false;
    private boolean mHasTeardownFunction = false;
    private boolean mHasSetValueFunction = false;
    private boolean mHasGetValueFunction = false;
    private boolean mHasResetFunction = false;
    private boolean mTornDown = false;

    public NativeProgram(String nativeLibName, String nativeFunctionPrefix) {
        this.allocate();
        String fullLibName = "lib" + nativeLibName + ".so";
        if (!this.openNativeLibrary(fullLibName)) {
            throw new RuntimeException("Could not find native library named '" + fullLibName + "' required for native program!");
        }
        String processFuncName = nativeFunctionPrefix + "_process";
        if (!this.bindProcessFunction(processFuncName)) {
            throw new RuntimeException("Could not find native program function name " + processFuncName + " in library " + fullLibName + "! This function is required!");
        }
        String initFuncName = nativeFunctionPrefix + "_init";
        this.mHasInitFunction = this.bindInitFunction(initFuncName);
        String teardownFuncName = nativeFunctionPrefix + "_teardown";
        this.mHasTeardownFunction = this.bindTeardownFunction(teardownFuncName);
        String setValueFuncName = nativeFunctionPrefix + "_setvalue";
        this.mHasSetValueFunction = this.bindSetValueFunction(setValueFuncName);
        String getValueFuncName = nativeFunctionPrefix + "_getvalue";
        this.mHasGetValueFunction = this.bindGetValueFunction(getValueFuncName);
        String resetFuncName = nativeFunctionPrefix + "_reset";
        this.mHasResetFunction = this.bindResetFunction(resetFuncName);
        if (this.mHasInitFunction && !this.callNativeInit()) {
            throw new RuntimeException("Could not initialize NativeProgram!");
        }
    }

    public void tearDown() {
        if (this.mTornDown) {
            return;
        }
        if (this.mHasTeardownFunction && !this.callNativeTeardown()) {
            throw new RuntimeException("Could not tear down NativeProgram!");
        }
        this.deallocate();
        this.mTornDown = true;
    }

    @Override
    public void reset() {
        if (this.mHasResetFunction && !this.callNativeReset()) {
            throw new RuntimeException("Could not reset NativeProgram!");
        }
    }

    protected void finalize() throws Throwable {
        this.tearDown();
    }

    @Override
    public void process(Frame[] inputs, Frame output) {
        if (this.mTornDown) {
            throw new RuntimeException("NativeProgram already torn down!");
        }
        NativeFrame[] nativeInputs = new NativeFrame[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != null && !(inputs[i] instanceof NativeFrame)) {
                throw new RuntimeException("NativeProgram got non-native frame as input " + i + "!");
            }
            nativeInputs[i] = (NativeFrame)inputs[i];
        }
        NativeFrame nativeOutput = null;
        if (output != null && !(output instanceof NativeFrame)) {
            throw new RuntimeException("NativeProgram got non-native output frame!");
        }
        nativeOutput = (NativeFrame)output;
        if (!this.callNativeProcess(nativeInputs, nativeOutput)) {
            throw new RuntimeException("Calling native process() caused error!");
        }
    }

    @Override
    public void setHostValue(String variableName, Object value) {
        if (this.mTornDown) {
            throw new RuntimeException("NativeProgram already torn down!");
        }
        if (!this.mHasSetValueFunction) {
            throw new RuntimeException("Attempting to set native variable, but native code does not define native setvalue function!");
        }
        if (!this.callNativeSetValue(variableName, value.toString())) {
            throw new RuntimeException("Error setting native value for variable '" + variableName + "'!");
        }
    }

    @Override
    public Object getHostValue(String variableName) {
        if (this.mTornDown) {
            throw new RuntimeException("NativeProgram already torn down!");
        }
        if (!this.mHasGetValueFunction) {
            throw new RuntimeException("Attempting to get native variable, but native code does not define native getvalue function!");
        }
        return this.callNativeGetValue(variableName);
    }

    private native boolean allocate();

    private native boolean deallocate();

    private native boolean nativeInit();

    private native boolean openNativeLibrary(String var1);

    private native boolean bindInitFunction(String var1);

    private native boolean bindSetValueFunction(String var1);

    private native boolean bindGetValueFunction(String var1);

    private native boolean bindProcessFunction(String var1);

    private native boolean bindResetFunction(String var1);

    private native boolean bindTeardownFunction(String var1);

    private native boolean callNativeInit();

    private native boolean callNativeSetValue(String var1, String var2);

    private native String callNativeGetValue(String var1);

    private native boolean callNativeProcess(NativeFrame[] var1, NativeFrame var2);

    private native boolean callNativeReset();

    private native boolean callNativeTeardown();

    static {
        System.loadLibrary("filterfw");
    }
}

