/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GLEnvironment;

public abstract class GraphRunner {
    protected FilterContext mFilterContext = null;
    public static final int RESULT_UNKNOWN = 0;
    public static final int RESULT_RUNNING = 1;
    public static final int RESULT_FINISHED = 2;
    public static final int RESULT_SLEEPING = 3;
    public static final int RESULT_BLOCKED = 4;
    public static final int RESULT_STOPPED = 5;
    public static final int RESULT_ERROR = 6;

    public GraphRunner(FilterContext context) {
        this.mFilterContext = context;
    }

    public abstract FilterGraph getGraph();

    public FilterContext getContext() {
        return this.mFilterContext;
    }

    protected boolean activateGlContext() {
        GLEnvironment glEnv = this.mFilterContext.getGLEnvironment();
        if (glEnv != null && !glEnv.isActive()) {
            glEnv.activate();
            return true;
        }
        return false;
    }

    protected void deactivateGlContext() {
        GLEnvironment glEnv = this.mFilterContext.getGLEnvironment();
        if (glEnv != null) {
            glEnv.deactivate();
        }
    }

    public abstract void run();

    public abstract void setDoneCallback(OnRunnerDoneListener var1);

    public abstract boolean isRunning();

    public abstract void stop();

    public abstract void close();

    public abstract Exception getError();

    public static interface OnRunnerDoneListener {
        public void onRunnerDone(int var1);
    }
}

