/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrameTimer;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.StopWatchMap;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.GLES20;
import java.nio.ByteBuffer;

public class GLFrame
extends Frame {
    public static final int EXISTING_TEXTURE_BINDING = 100;
    public static final int EXISTING_FBO_BINDING = 101;
    public static final int NEW_TEXTURE_BINDING = 102;
    public static final int NEW_FBO_BINDING = 103;
    public static final int EXTERNAL_TEXTURE = 104;
    private int glFrameId = -1;
    private boolean mOwnsTexture = true;
    private GLEnvironment mGLEnvironment;

    GLFrame(FrameFormat format, FrameManager frameManager) {
        super(format, frameManager);
    }

    GLFrame(FrameFormat format, FrameManager frameManager, int bindingType, long bindingId) {
        super(format, frameManager, bindingType, bindingId);
    }

    void init(GLEnvironment glEnv) {
        FrameFormat format = this.getFormat();
        this.mGLEnvironment = glEnv;
        if (format.getBytesPerSample() != 4) {
            throw new IllegalArgumentException("GL frames must have 4 bytes per sample!");
        }
        if (format.getDimensionCount() != 2) {
            throw new IllegalArgumentException("GL frames must be 2-dimensional!");
        }
        if (this.getFormat().getSize() < 0) {
            throw new IllegalArgumentException("Initializing GL frame with zero size!");
        }
        int bindingType = this.getBindingType();
        boolean reusable = true;
        if (bindingType == 0) {
            this.initNew(false);
        } else if (bindingType == 104) {
            this.initNew(true);
            reusable = false;
        } else if (bindingType == 100) {
            this.initWithTexture((int)this.getBindingId());
        } else if (bindingType == 101) {
            this.initWithFbo((int)this.getBindingId());
        } else if (bindingType == 102) {
            this.initWithTexture((int)this.getBindingId());
        } else if (bindingType == 103) {
            this.initWithFbo((int)this.getBindingId());
        } else {
            throw new RuntimeException("Attempting to create GL frame with unknown binding type " + bindingType + "!");
        }
        this.setReusable(reusable);
    }

    private void initNew(boolean isExternal) {
        if (isExternal) {
            if (!this.nativeAllocateExternal(this.mGLEnvironment)) {
                throw new RuntimeException("Could not allocate external GL frame!");
            }
        } else if (!this.nativeAllocate(this.mGLEnvironment, this.getFormat().getWidth(), this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate GL frame!");
        }
    }

    private void initWithTexture(int texId) {
        int height;
        int width = this.getFormat().getWidth();
        if (!this.nativeAllocateWithTexture(this.mGLEnvironment, texId, width, height = this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate texture backed GL frame!");
        }
        this.mOwnsTexture = false;
        this.markReadOnly();
    }

    private void initWithFbo(int fboId) {
        int height;
        int width = this.getFormat().getWidth();
        if (!this.nativeAllocateWithFbo(this.mGLEnvironment, fboId, width, height = this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate FBO backed GL frame!");
        }
    }

    void flushGPU(String message) {
        StopWatchMap timer = GLFrameTimer.get();
        if (timer.LOG_MFF_RUNNING_TIMES) {
            timer.start("glFinish " + message);
            GLES20.glFinish();
            timer.stop("glFinish " + message);
        }
    }

    @Override
    protected synchronized boolean hasNativeAllocation() {
        return this.glFrameId != -1;
    }

    @Override
    protected synchronized void releaseNativeAllocation() {
        this.nativeDeallocate();
        this.glFrameId = -1;
    }

    public GLEnvironment getGLEnvironment() {
        return this.mGLEnvironment;
    }

    @Override
    public Object getObjectValue() {
        this.assertGLEnvValid();
        return ByteBuffer.wrap(this.getNativeData());
    }

    @Override
    public void setInts(int[] ints) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeInts(ints)) {
            throw new RuntimeException("Could not set int values for GL frame!");
        }
    }

    @Override
    public int[] getInts() {
        this.assertGLEnvValid();
        this.flushGPU("getInts");
        return this.getNativeInts();
    }

    @Override
    public void setFloats(float[] floats) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeFloats(floats)) {
            throw new RuntimeException("Could not set int values for GL frame!");
        }
    }

    @Override
    public float[] getFloats() {
        this.assertGLEnvValid();
        this.flushGPU("getFloats");
        return this.getNativeFloats();
    }

    @Override
    public void setData(ByteBuffer buffer, int offset, int length) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        byte[] bytes = buffer.array();
        if (this.getFormat().getSize() != bytes.length) {
            throw new RuntimeException("Data size in setData does not match GL frame size!");
        }
        if (!this.setNativeData(bytes, offset, length)) {
            throw new RuntimeException("Could not set GL frame data!");
        }
    }

    @Override
    public ByteBuffer getData() {
        this.assertGLEnvValid();
        this.flushGPU("getData");
        return ByteBuffer.wrap(this.getNativeData());
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (this.getFormat().getWidth() != bitmap.getWidth() || this.getFormat().getHeight() != bitmap.getHeight()) {
            throw new RuntimeException("Bitmap dimensions do not match GL frame dimensions!");
        }
        Bitmap rgbaBitmap = GLFrame.convertBitmapToRGBA(bitmap);
        if (!this.setNativeBitmap(rgbaBitmap, rgbaBitmap.getByteCount())) {
            throw new RuntimeException("Could not set GL frame bitmap data!");
        }
    }

    @Override
    public Bitmap getBitmap() {
        this.assertGLEnvValid();
        this.flushGPU("getBitmap");
        Bitmap result = Bitmap.createBitmap(this.getFormat().getWidth(), this.getFormat().getHeight(), Bitmap.Config.ARGB_8888);
        if (!this.getNativeBitmap(result)) {
            throw new RuntimeException("Could not get bitmap data from GL frame!");
        }
        return result;
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        this.assertGLEnvValid();
        if (this.getFormat().getSize() < frame.getFormat().getSize()) {
            throw new RuntimeException("Attempting to assign frame of size " + frame.getFormat().getSize() + " to smaller GL frame of size " + this.getFormat().getSize() + "!");
        }
        if (frame instanceof NativeFrame) {
            this.nativeCopyFromNative((NativeFrame)frame);
        } else if (frame instanceof GLFrame) {
            this.nativeCopyFromGL((GLFrame)frame);
        } else if (frame instanceof SimpleFrame) {
            this.setObjectValue(frame.getObjectValue());
        } else {
            super.setDataFromFrame(frame);
        }
    }

    public void setViewport(int x, int y, int width, int height) {
        this.assertFrameMutable();
        this.setNativeViewport(x, y, width, height);
    }

    public void setViewport(Rect rect) {
        this.assertFrameMutable();
        this.setNativeViewport(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void generateMipMap() {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.generateNativeMipMap()) {
            throw new RuntimeException("Could not generate mip-map for GL frame!");
        }
    }

    public void setTextureParameter(int param, int value) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeTextureParam(param, value)) {
            throw new RuntimeException("Could not set texture value " + param + " = " + value + " for GLFrame!");
        }
    }

    public int getTextureId() {
        return this.getNativeTextureId();
    }

    public int getFboId() {
        return this.getNativeFboId();
    }

    public void focus() {
        if (!this.nativeFocus()) {
            throw new RuntimeException("Could not focus on GLFrame for drawing!");
        }
    }

    public String toString() {
        return "GLFrame id: " + this.glFrameId + " (" + this.getFormat() + ") with texture ID " + this.getTextureId() + ", FBO ID " + this.getFboId();
    }

    @Override
    protected void reset(FrameFormat newFormat) {
        if (!this.nativeResetParams()) {
            throw new RuntimeException("Could not reset GLFrame texture parameters!");
        }
        super.reset(newFormat);
    }

    @Override
    protected void onFrameStore() {
        if (!this.mOwnsTexture) {
            this.nativeDetachTexFromFbo();
        }
    }

    @Override
    protected void onFrameFetch() {
        if (!this.mOwnsTexture) {
            this.nativeReattachTexToFbo();
        }
    }

    private void assertGLEnvValid() {
        if (!this.mGLEnvironment.isContextActive()) {
            if (GLEnvironment.isAnyContextActive()) {
                throw new RuntimeException("Attempting to access " + this + " with foreign GL context active!");
            }
            throw new RuntimeException("Attempting to access " + this + " with no GL context  active!");
        }
    }

    private native boolean nativeAllocate(GLEnvironment var1, int var2, int var3);

    private native boolean nativeAllocateWithTexture(GLEnvironment var1, int var2, int var3, int var4);

    private native boolean nativeAllocateWithFbo(GLEnvironment var1, int var2, int var3, int var4);

    private native boolean nativeAllocateExternal(GLEnvironment var1);

    private native boolean nativeDeallocate();

    private native boolean setNativeData(byte[] var1, int var2, int var3);

    private native byte[] getNativeData();

    private native boolean setNativeInts(int[] var1);

    private native boolean setNativeFloats(float[] var1);

    private native int[] getNativeInts();

    private native float[] getNativeFloats();

    private native boolean setNativeBitmap(Bitmap var1, int var2);

    private native boolean getNativeBitmap(Bitmap var1);

    private native boolean setNativeViewport(int var1, int var2, int var3, int var4);

    private native int getNativeTextureId();

    private native int getNativeFboId();

    private native boolean generateNativeMipMap();

    private native boolean setNativeTextureParam(int var1, int var2);

    private native boolean nativeResetParams();

    private native boolean nativeCopyFromNative(NativeFrame var1);

    private native boolean nativeCopyFromGL(GLFrame var1);

    private native boolean nativeFocus();

    private native boolean nativeReattachTexToFbo();

    private native boolean nativeDetachTexFromFbo();

    static {
        System.loadLibrary("filterfw");
    }
}

