/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.SimpleScheduler;
import android.filterfw.core.SyncRunner;
import android.os.AsyncTask;
import android.util.Log;

public class AsyncRunner
extends GraphRunner {
    private Class mSchedulerClass;
    private SyncRunner mRunner;
    private AsyncRunnerTask mRunTask;
    private GraphRunner.OnRunnerDoneListener mDoneListener;
    private boolean isProcessing;
    private Exception mException;
    private boolean mLogVerbose;
    private static final String TAG = "AsyncRunner";

    public AsyncRunner(FilterContext context, Class schedulerClass) {
        super(context);
        this.mSchedulerClass = schedulerClass;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    public AsyncRunner(FilterContext context) {
        super(context);
        this.mSchedulerClass = SimpleScheduler.class;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    @Override
    public void setDoneCallback(GraphRunner.OnRunnerDoneListener listener) {
        this.mDoneListener = listener;
    }

    public synchronized void setGraph(FilterGraph graph) {
        if (this.isRunning()) {
            throw new RuntimeException("Graph is already running!");
        }
        this.mRunner = new SyncRunner(this.mFilterContext, graph, this.mSchedulerClass);
    }

    @Override
    public FilterGraph getGraph() {
        return this.mRunner != null ? this.mRunner.getGraph() : null;
    }

    @Override
    public synchronized void run() {
        if (this.mLogVerbose) {
            Log.v(TAG, "Running graph.");
        }
        this.setException(null);
        if (this.isRunning()) {
            throw new RuntimeException("Graph is already running!");
        }
        if (this.mRunner == null) {
            throw new RuntimeException("Cannot run before a graph is set!");
        }
        this.mRunTask = new AsyncRunnerTask();
        this.setRunning(true);
        this.mRunTask.execute(this.mRunner);
    }

    @Override
    public synchronized void stop() {
        if (this.mRunTask != null && !this.mRunTask.isCancelled()) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Stopping graph.");
            }
            this.mRunTask.cancel(false);
        }
    }

    @Override
    public synchronized void close() {
        if (this.isRunning()) {
            throw new RuntimeException("Cannot close graph while it is running!");
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Closing filters.");
        }
        this.mRunner.close();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.isProcessing;
    }

    @Override
    public synchronized Exception getError() {
        return this.mException;
    }

    private synchronized void setRunning(boolean running) {
        this.isProcessing = running;
    }

    private synchronized void setException(Exception exception) {
        this.mException = exception;
    }

    private class AsyncRunnerTask
    extends AsyncTask<SyncRunner, Void, RunnerResult> {
        private static final String TAG = "AsyncRunnerTask";

        private AsyncRunnerTask() {
        }

        protected RunnerResult doInBackground(SyncRunner ... runner) {
            RunnerResult result = new RunnerResult();
            try {
                if (runner.length > 1) {
                    throw new RuntimeException("More than one runner received!");
                }
                runner[0].assertReadyToStep();
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Starting background graph processing.");
                }
                AsyncRunner.this.activateGlContext();
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Preparing filter graph for processing.");
                }
                runner[0].beginProcessing();
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Running graph.");
                }
                result.status = 1;
                while (!this.isCancelled() && result.status == 1) {
                    if (runner[0].performStep()) continue;
                    result.status = runner[0].determinePostRunState();
                    if (result.status != 3) continue;
                    runner[0].waitUntilWake();
                    result.status = 1;
                }
                if (this.isCancelled()) {
                    result.status = 5;
                }
            }
            catch (Exception exception) {
                result.exception = exception;
                result.status = 6;
            }
            try {
                AsyncRunner.this.deactivateGlContext();
            }
            catch (Exception exception) {
                result.exception = exception;
                result.status = 6;
            }
            if (AsyncRunner.this.mLogVerbose) {
                Log.v(TAG, "Done with background graph processing.");
            }
            return result;
        }

        @Override
        protected void onCancelled(RunnerResult result) {
            this.onPostExecute(result);
        }

        @Override
        protected void onPostExecute(RunnerResult result) {
            if (AsyncRunner.this.mLogVerbose) {
                Log.v(TAG, "Starting post-execute.");
            }
            AsyncRunner.this.setRunning(false);
            if (result == null) {
                result = new RunnerResult();
                result.status = 5;
            }
            AsyncRunner.this.setException(result.exception);
            if (result.status == 5 || result.status == 6) {
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Closing filters.");
                }
                try {
                    AsyncRunner.this.mRunner.close();
                }
                catch (Exception exception) {
                    result.status = 6;
                    AsyncRunner.this.setException(exception);
                }
            }
            if (AsyncRunner.this.mDoneListener != null) {
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Calling graph done callback.");
                }
                AsyncRunner.this.mDoneListener.onRunnerDone(result.status);
            }
            if (AsyncRunner.this.mLogVerbose) {
                Log.v(TAG, "Completed post-execute.");
            }
        }
    }

    private class RunnerResult {
        public int status = 0;
        public Exception exception;

        private RunnerResult() {
        }
    }
}

