/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import android.os.CancellationSignal;

public final class SQLiteDirectCursorDriver
implements SQLiteCursorDriver {
    private final SQLiteDatabase mDatabase;
    private final String mEditTable;
    private final String mSql;
    private final CancellationSignal mCancellationSignal;
    private SQLiteQuery mQuery;

    public SQLiteDirectCursorDriver(SQLiteDatabase db, String sql, String editTable, CancellationSignal cancellationSignal) {
        this.mDatabase = db;
        this.mEditTable = editTable;
        this.mSql = sql;
        this.mCancellationSignal = cancellationSignal;
    }

    @Override
    public Cursor query(SQLiteDatabase.CursorFactory factory, String[] selectionArgs) {
        Cursor cursor;
        SQLiteQuery query = new SQLiteQuery(this.mDatabase, this.mSql, this.mCancellationSignal);
        try {
            query.bindAllArgsAsStrings(selectionArgs);
            cursor = factory == null ? new SQLiteCursor(this, this.mEditTable, query) : factory.newCursor(this.mDatabase, this, this.mEditTable, query);
        }
        catch (RuntimeException ex) {
            query.close();
            throw ex;
        }
        this.mQuery = query;
        return cursor;
    }

    @Override
    public void cursorClosed() {
    }

    @Override
    public void setBindArguments(String[] bindArgs) {
        this.mQuery.bindAllArgsAsStrings(bindArgs);
    }

    @Override
    public void cursorDeactivated() {
    }

    @Override
    public void cursorRequeried(Cursor cursor) {
    }

    public String toString() {
        return "SQLiteDirectCursorDriver: " + this.mSql;
    }
}

