/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.content.res.Resources;
import android.database.CharArrayBuffer;
import android.database.CursorWindowAllocationException;
import android.database.sqlite.SQLiteClosable;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseIntArray;
import dalvik.system.CloseGuard;

public class CursorWindow
extends SQLiteClosable
implements Parcelable {
    private static final String STATS_TAG = "CursorWindowStats";
    private static int sCursorWindowSize = -1;
    public long mWindowPtr;
    private int mStartPos;
    private final String mName;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    public static final Parcelable.Creator<CursorWindow> CREATOR = new Parcelable.Creator<CursorWindow>(){

        @Override
        public CursorWindow createFromParcel(Parcel source) {
            return new CursorWindow(source);
        }

        public CursorWindow[] newArray(int size) {
            return new CursorWindow[size];
        }
    };
    private static final LongSparseArray<Integer> sWindowToPidMap = new LongSparseArray();

    private static native long nativeCreate(String var0, int var1);

    private static native long nativeCreateFromParcel(Parcel var0);

    private static native void nativeDispose(long var0);

    private static native void nativeWriteToParcel(long var0, Parcel var2);

    private static native void nativeClear(long var0);

    private static native int nativeGetNumRows(long var0);

    private static native boolean nativeSetNumColumns(long var0, int var2);

    private static native boolean nativeAllocRow(long var0);

    private static native void nativeFreeLastRow(long var0);

    private static native int nativeGetType(long var0, int var2, int var3);

    private static native byte[] nativeGetBlob(long var0, int var2, int var3);

    private static native String nativeGetString(long var0, int var2, int var3);

    private static native long nativeGetLong(long var0, int var2, int var3);

    private static native double nativeGetDouble(long var0, int var2, int var3);

    private static native void nativeCopyStringToBuffer(long var0, int var2, int var3, CharArrayBuffer var4);

    private static native boolean nativePutBlob(long var0, byte[] var2, int var3, int var4);

    private static native boolean nativePutString(long var0, String var2, int var3, int var4);

    private static native boolean nativePutLong(long var0, long var2, int var4, int var5);

    private static native boolean nativePutDouble(long var0, double var2, int var4, int var5);

    private static native boolean nativePutNull(long var0, int var2, int var3);

    private static native String nativeGetName(long var0);

    public CursorWindow(String name) {
        this.mStartPos = 0;
        String string2 = this.mName = name != null && name.length() != 0 ? name : "<unnamed>";
        if (sCursorWindowSize < 0) {
            sCursorWindowSize = Resources.getSystem().getInteger(17694757) * 1024;
        }
        this.mWindowPtr = CursorWindow.nativeCreate(this.mName, sCursorWindowSize);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window allocation of " + sCursorWindowSize / 1024 + " kb failed. " + this.printStats());
        }
        this.mCloseGuard.open("close");
        this.recordNewWindow(Binder.getCallingPid(), this.mWindowPtr);
    }

    @Deprecated
    public CursorWindow(boolean localWindow) {
        this((String)null);
    }

    private CursorWindow(Parcel source) {
        this.mStartPos = source.readInt();
        this.mWindowPtr = CursorWindow.nativeCreateFromParcel(source);
        if (this.mWindowPtr == 0L) {
            throw new CursorWindowAllocationException("Cursor window could not be created from binder.");
        }
        this.mName = CursorWindow.nativeGetName(this.mWindowPtr);
        this.mCloseGuard.open("close");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void dispose() {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.close();
        }
        if (this.mWindowPtr != 0L) {
            this.recordClosingOfWindow(this.mWindowPtr);
            CursorWindow.nativeDispose(this.mWindowPtr);
            this.mWindowPtr = 0L;
        }
    }

    public String getName() {
        return this.mName;
    }

    public void clear() {
        this.acquireReference();
        try {
            this.mStartPos = 0;
            CursorWindow.nativeClear(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    public int getStartPosition() {
        return this.mStartPos;
    }

    public void setStartPosition(int pos) {
        this.mStartPos = pos;
    }

    public int getNumRows() {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetNumRows(this.mWindowPtr);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean setNumColumns(int columnNum) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeSetNumColumns(this.mWindowPtr, columnNum);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public boolean allocRow() {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativeAllocRow(this.mWindowPtr);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public void freeLastRow() {
        this.acquireReference();
        try {
            CursorWindow.nativeFreeLastRow(this.mWindowPtr);
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isNull(int row, int column) {
        return this.getType(row, column) == 0;
    }

    @Deprecated
    public boolean isBlob(int row, int column) {
        int type = this.getType(row, column);
        return type == 4 || type == 0;
    }

    @Deprecated
    public boolean isLong(int row, int column) {
        return this.getType(row, column) == 1;
    }

    @Deprecated
    public boolean isFloat(int row, int column) {
        return this.getType(row, column) == 2;
    }

    @Deprecated
    public boolean isString(int row, int column) {
        int type = this.getType(row, column);
        return type == 3 || type == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(int row, int column) {
        this.acquireReference();
        try {
            int n = CursorWindow.nativeGetType(this.mWindowPtr, row - this.mStartPos, column);
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int row, int column) {
        this.acquireReference();
        try {
            byte[] byArray = CursorWindow.nativeGetBlob(this.mWindowPtr, row - this.mStartPos, column);
            return byArray;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int row, int column) {
        this.acquireReference();
        try {
            String string2 = CursorWindow.nativeGetString(this.mWindowPtr, row - this.mStartPos, column);
            return string2;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStringToBuffer(int row, int column, CharArrayBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("CharArrayBuffer should not be null");
        }
        this.acquireReference();
        try {
            CursorWindow.nativeCopyStringToBuffer(this.mWindowPtr, row - this.mStartPos, column, buffer);
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int row, int column) {
        this.acquireReference();
        try {
            long l = CursorWindow.nativeGetLong(this.mWindowPtr, row - this.mStartPos, column);
            return l;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int row, int column) {
        this.acquireReference();
        try {
            double d = CursorWindow.nativeGetDouble(this.mWindowPtr, row - this.mStartPos, column);
            return d;
        }
        finally {
            this.releaseReference();
        }
    }

    public short getShort(int row, int column) {
        return (short)this.getLong(row, column);
    }

    public int getInt(int row, int column) {
        return (int)this.getLong(row, column);
    }

    public float getFloat(int row, int column) {
        return (float)this.getDouble(row, column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putBlob(byte[] value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutBlob(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putString(String value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutString(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putLong(long value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutLong(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putDouble(double value, int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutDouble(this.mWindowPtr, value, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putNull(int row, int column) {
        this.acquireReference();
        try {
            boolean bl = CursorWindow.nativePutNull(this.mWindowPtr, row - this.mStartPos, column);
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public static CursorWindow newFromParcel(Parcel p) {
        return CREATOR.createFromParcel(p);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.acquireReference();
        try {
            dest.writeInt(this.mStartPos);
            CursorWindow.nativeWriteToParcel(this.mWindowPtr, dest);
        }
        finally {
            this.releaseReference();
        }
        if ((flags & 1) != 0) {
            this.releaseReference();
        }
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordNewWindow(int pid, long window) {
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            sWindowToPidMap.put(window, pid);
            if (Log.isLoggable(STATS_TAG, 2)) {
                Log.i(STATS_TAG, "Created a new Cursor. " + this.printStats());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordClosingOfWindow(long window) {
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            if (sWindowToPidMap.size() == 0) {
                return;
            }
            sWindowToPidMap.delete(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String printStats() {
        StringBuilder buff = new StringBuilder();
        int myPid = Process.myPid();
        int total = 0;
        SparseIntArray pidCounts = new SparseIntArray();
        LongSparseArray<Integer> longSparseArray = sWindowToPidMap;
        synchronized (longSparseArray) {
            int size = sWindowToPidMap.size();
            if (size == 0) {
                return "";
            }
            for (int indx = 0; indx < size; ++indx) {
                int pid = sWindowToPidMap.valueAt(indx);
                int value = pidCounts.get(pid);
                pidCounts.put(pid, ++value);
            }
        }
        int numPids = pidCounts.size();
        for (int i = 0; i < numPids; ++i) {
            buff.append(" (# cursors opened by ");
            int pid = pidCounts.keyAt(i);
            if (pid == myPid) {
                buff.append("this proc=");
            } else {
                buff.append("pid " + pid + "=");
            }
            int num = pidCounts.get(pid);
            buff.append(num + ")");
            total += num;
        }
        String s = buff.length() > 980 ? buff.substring(0, 980) : buff.toString();
        return "# Open Cursors=" + total + s;
    }

    public String toString() {
        return this.getName() + " {" + Long.toHexString(this.mWindowPtr) + "}";
    }
}

