/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageParser;
import com.android.internal.util.ArrayUtils;
import java.util.ArrayList;

public class PackageBackwardCompatibility {
    private static final String ANDROID_TEST_MOCK = "android.test.mock";
    private static final String ANDROID_TEST_RUNNER = "android.test.runner";

    public static void modifySharedLibraries(PackageParser.Package pkg) {
        boolean androidTestMockPresent;
        ArrayList<String> usesLibraries = pkg.usesLibraries;
        ArrayList<String> usesOptionalLibraries = pkg.usesOptionalLibraries;
        usesLibraries = PackageBackwardCompatibility.orgApacheHttpLegacy(usesLibraries);
        usesOptionalLibraries = PackageBackwardCompatibility.orgApacheHttpLegacy(usesOptionalLibraries);
        boolean bl = androidTestMockPresent = ArrayUtils.contains(usesLibraries, ANDROID_TEST_MOCK) || ArrayUtils.contains(usesOptionalLibraries, ANDROID_TEST_MOCK);
        if (ArrayUtils.contains(usesLibraries, ANDROID_TEST_RUNNER) && !androidTestMockPresent) {
            usesLibraries.add(ANDROID_TEST_MOCK);
        }
        if (ArrayUtils.contains(usesOptionalLibraries, ANDROID_TEST_RUNNER) && !androidTestMockPresent) {
            usesOptionalLibraries.add(ANDROID_TEST_MOCK);
        }
        pkg.usesLibraries = usesLibraries;
        pkg.usesOptionalLibraries = usesOptionalLibraries;
    }

    private static ArrayList<String> orgApacheHttpLegacy(ArrayList<String> libraries) {
        return ArrayUtils.remove(libraries, "org.apache.http.legacy");
    }
}

