/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothMapClient;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothMapClient
implements BluetoothProfile {
    private static final String TAG = "BluetoothMapClient";
    private static final boolean DBG = Log.isLoggable("BluetoothMapClient", 3);
    private static final boolean VDBG = Log.isLoggable("BluetoothMapClient", 2);
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.mapmce.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_MESSAGE_RECEIVED = "android.bluetooth.mapmce.profile.action.MESSAGE_RECEIVED";
    public static final String ACTION_MESSAGE_SENT_SUCCESSFULLY = "android.bluetooth.mapmce.profile.action.MESSAGE_SENT_SUCCESSFULLY";
    public static final String ACTION_MESSAGE_DELIVERED_SUCCESSFULLY = "android.bluetooth.mapmce.profile.action.MESSAGE_DELIVERED_SUCCESSFULLY";
    public static final String EXTRA_MESSAGE_HANDLE = "android.bluetooth.mapmce.profile.extra.MESSAGE_HANDLE";
    public static final String EXTRA_SENDER_CONTACT_URI = "android.bluetooth.mapmce.profile.extra.SENDER_CONTACT_URI";
    public static final String EXTRA_SENDER_CONTACT_NAME = "android.bluetooth.mapmce.profile.extra.SENDER_CONTACT_NAME";
    private volatile IBluetoothMapClient mService;
    private final Context mContext;
    private BluetoothProfile.ServiceListener mServiceListener;
    private BluetoothAdapter mAdapter;
    public static final int STATE_ERROR = -1;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_CANCELED = 2;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBluetoothStateChange(boolean up) {
            if (DBG) {
                Log.d(BluetoothMapClient.TAG, "onBluetoothStateChange: up=" + up);
            }
            if (!up) {
                if (VDBG) {
                    Log.d(BluetoothMapClient.TAG, "Unbinding service...");
                }
                ServiceConnection serviceConnection = BluetoothMapClient.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothMapClient.this.mService = null;
                        BluetoothMapClient.this.mContext.unbindService(BluetoothMapClient.this.mConnection);
                    }
                    catch (Exception re) {
                        Log.e(BluetoothMapClient.TAG, "", re);
                    }
                }
            }
            ServiceConnection serviceConnection = BluetoothMapClient.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothMapClient.this.mService == null) {
                        if (VDBG) {
                            Log.d(BluetoothMapClient.TAG, "Binding service...");
                        }
                        BluetoothMapClient.this.doBind();
                    }
                }
                catch (Exception re) {
                    Log.e(BluetoothMapClient.TAG, "", re);
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            if (DBG) {
                Log.d(BluetoothMapClient.TAG, "Proxy object connected");
            }
            BluetoothMapClient.this.mService = IBluetoothMapClient.Stub.asInterface(service);
            if (BluetoothMapClient.this.mServiceListener != null) {
                BluetoothMapClient.this.mServiceListener.onServiceConnected(18, BluetoothMapClient.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            if (DBG) {
                Log.d(BluetoothMapClient.TAG, "Proxy object disconnected");
            }
            BluetoothMapClient.this.mService = null;
            if (BluetoothMapClient.this.mServiceListener != null) {
                BluetoothMapClient.this.mServiceListener.onServiceDisconnected(18);
            }
        }
    };

    BluetoothMapClient(Context context, BluetoothProfile.ServiceListener l) {
        if (DBG) {
            Log.d(TAG, "Create BluetoothMapClient proxy object");
        }
        this.mContext = context;
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        this.doBind();
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothMapClient.class.getName());
        ComponentName comp = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(comp);
        if (comp == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth MAP MCE Service with " + intent);
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        IBluetoothManager mgr = this.mAdapter.getBluetoothManager();
        if (mgr != null) {
            try {
                mgr.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception e) {
                Log.e(TAG, "", e);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            if (this.mService != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception re) {
                    Log.e(TAG, "", re);
                }
            }
        }
        this.mServiceListener = null;
    }

    public boolean isConnected(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (VDBG) {
            Log.d(TAG, "isConnected(" + device + ")");
        }
        if ((service = this.mService) != null) {
            try {
                return service.isConnected(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                Log.d(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    public boolean connect(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "connect(" + device + ")for MAPS MCE");
        }
        if ((service = this.mService) != null) {
            try {
                return service.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, e.toString());
            }
        } else {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                Log.d(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    public boolean disconnect(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "disconnect(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getConnectedDevices()");
        }
        if ((service = this.mService) != null && this.isEnabled()) {
            try {
                return service.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getDevicesMatchingStates()");
        }
        if ((service = this.mService) != null && this.isEnabled()) {
            try {
                return service.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getConnectionState(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean setPriority(BluetoothDevice device, int priority) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "setPriority(" + device + ", " + priority + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return service.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public int getPriority(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (VDBG) {
            Log.d(TAG, "getPriority(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (service == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean sendMessage(BluetoothDevice device, Uri[] contacts, String message, PendingIntent sentIntent, PendingIntent deliveredIntent) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "sendMessage(" + device + ", " + contacts + ", " + message);
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.sendMessage(device, contacts, message, sentIntent, deliveredIntent);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    public boolean getUnreadMessages(BluetoothDevice device) {
        IBluetoothMapClient service;
        if (DBG) {
            Log.d(TAG, "getUnreadMessages(" + device + ")");
        }
        if ((service = this.mService) != null && this.isEnabled() && BluetoothMapClient.isValidDevice(device)) {
            try {
                return service.getUnreadMessages(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        return false;
    }

    private boolean isEnabled() {
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.getState() == 12) {
            return true;
        }
        if (DBG) {
            Log.d(TAG, "Bluetooth is Not enabled");
        }
        return false;
    }

    private static boolean isValidDevice(BluetoothDevice device) {
        return device != null && BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }
}

