/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataInput {
    long mBackupReader;
    private EntityHeader mHeader = new EntityHeader();
    private boolean mHeaderReady;

    public BackupDataInput(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException();
        }
        this.mBackupReader = BackupDataInput.ctor(fd);
        if (this.mBackupReader == 0L) {
            throw new RuntimeException("Native initialization failed with fd=" + fd);
        }
    }

    protected void finalize() throws Throwable {
        try {
            BackupDataInput.dtor(this.mBackupReader);
        }
        finally {
            super.finalize();
        }
    }

    public boolean readNextHeader() throws IOException {
        int result = this.readNextHeader_native(this.mBackupReader, this.mHeader);
        if (result == 0) {
            this.mHeaderReady = true;
            return true;
        }
        if (result > 0) {
            this.mHeaderReady = false;
            return false;
        }
        this.mHeaderReady = false;
        throw new IOException("failed: 0x" + Integer.toHexString(result));
    }

    public String getKey() {
        if (this.mHeaderReady) {
            return this.mHeader.key;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public int getDataSize() {
        if (this.mHeaderReady) {
            return this.mHeader.dataSize;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public int readEntityData(byte[] data, int offset, int size) throws IOException {
        if (this.mHeaderReady) {
            int result = this.readEntityData_native(this.mBackupReader, data, offset, size);
            if (result >= 0) {
                return result;
            }
            throw new IOException("result=0x" + Integer.toHexString(result));
        }
        throw new IllegalStateException("Entity header not read");
    }

    public void skipEntityData() throws IOException {
        if (!this.mHeaderReady) {
            throw new IllegalStateException("Entity header not read");
        }
        this.skipEntityData_native(this.mBackupReader);
    }

    private static native long ctor(FileDescriptor var0);

    private static native void dtor(long var0);

    private native int readNextHeader_native(long var1, EntityHeader var3);

    private native int readEntityData_native(long var1, byte[] var3, int var4, int var5);

    private native int skipEntityData_native(long var1);

    private static class EntityHeader {
        String key;
        int dataSize;

        private EntityHeader() {
        }
    }
}

