/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.app.IUiAutomationConnection;
import android.content.pm.IPackageManager;
import android.graphics.Bitmap;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.util.Log;
import android.view.IWindowManager;
import android.view.InputEvent;
import android.view.SurfaceControl;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import android.view.accessibility.IAccessibilityManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libcore.io.IoUtils;

public final class UiAutomationConnection
extends IUiAutomationConnection.Stub {
    private static final String TAG = "UiAutomationConnection";
    private static final int INITIAL_FROZEN_ROTATION_UNSPECIFIED = -1;
    private final IWindowManager mWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
    private final IAccessibilityManager mAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
    private final IPackageManager mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
    private final Object mLock = new Object();
    private final Binder mToken = new Binder();
    private int mInitialFrozenRotation = -1;
    private IAccessibilityServiceClient mClient;
    private boolean mIsShutdown;
    private int mOwningUid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(IAccessibilityServiceClient client, int flags) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null!");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfShutdownLocked();
            if (this.isConnectedLocked()) {
                throw new IllegalStateException("Already connected.");
            }
            this.mOwningUid = Binder.getCallingUid();
            this.registerUiTestAutomationServiceLocked(client, flags);
            this.storeRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            if (!this.isConnectedLocked()) {
                throw new IllegalStateException("Already disconnected.");
            }
            this.mOwningUid = -1;
            this.unregisterUiTestAutomationServiceLocked();
            this.restoreRotationStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean injectInputEvent(InputEvent event, boolean sync) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int mode = sync ? 2 : 0;
        long identity = Binder.clearCallingIdentity();
        try {
            boolean bl = InputManager.getInstance().injectInputEvent(event, mode);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (rotation == -2) {
                this.mWindowManager.thawRotation();
            } else {
                this.mWindowManager.freezeRotation(rotation);
            }
            boolean bl = true;
            return bl;
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap takeScreenshot(int width, int height) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            Bitmap bitmap = SurfaceControl.screenshot(width, height);
            return bitmap;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearWindowContentFrameStats(int windowId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int callingUserId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            IBinder token = this.mAccessibilityManager.getWindowToken(windowId, callingUserId);
            if (token == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.mWindowManager.clearWindowContentFrameStats(token);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowContentFrameStats getWindowContentFrameStats(int windowId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        int callingUserId = UserHandle.getCallingUserId();
        long identity = Binder.clearCallingIdentity();
        try {
            IBinder token = this.mAccessibilityManager.getWindowToken(windowId, callingUserId);
            if (token == null) {
                WindowContentFrameStats windowContentFrameStats = null;
                return windowContentFrameStats;
            }
            WindowContentFrameStats windowContentFrameStats = this.mWindowManager.getWindowContentFrameStats(token);
            return windowContentFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            SurfaceControl.clearAnimationFrameStats();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowAnimationFrameStats getWindowAnimationFrameStats() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            WindowAnimationFrameStats stats = new WindowAnimationFrameStats();
            SurfaceControl.getAnimationFrameStats(stats);
            WindowAnimationFrameStats windowAnimationFrameStats = stats;
            return windowAnimationFrameStats;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRuntimePermission(String packageName, String permission2, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPackageManager.grantRuntimePermission(packageName, permission2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRuntimePermission(String packageName, String permission2, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            this.mPackageManager.revokeRuntimePermission(packageName, permission2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeShellCommand(String command, final ParcelFileDescriptor sink, final ParcelFileDescriptor source) throws RemoteException {
        Thread writeToProcess;
        Thread readFromProcess;
        Process process;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCalledByNotTrustedUidLocked();
            this.throwIfShutdownLocked();
            this.throwIfNotConnectedLocked();
        }
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException exc) {
            throw new RuntimeException("Error running shell command '" + command + "'", exc);
        }
        if (sink != null) {
            InputStream sink_in = process.getInputStream();
            FileOutputStream sink_out = new FileOutputStream(sink.getFileDescriptor());
            readFromProcess = new Thread(new Repeater(sink_in, sink_out));
            readFromProcess.start();
        } else {
            readFromProcess = null;
        }
        if (source != null) {
            OutputStream source_out = process.getOutputStream();
            FileInputStream source_in = new FileInputStream(source.getFileDescriptor());
            writeToProcess = new Thread(new Repeater(source_in, source_out));
            writeToProcess.start();
        } else {
            writeToProcess = null;
        }
        Thread cleanup = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (writeToProcess != null) {
                        writeToProcess.join();
                    }
                    if (readFromProcess != null) {
                        readFromProcess.join();
                    }
                }
                catch (InterruptedException exc) {
                    Log.e(UiAutomationConnection.TAG, "At least one of the threads was interrupted");
                }
                IoUtils.closeQuietly(sink);
                IoUtils.closeQuietly(source);
                process.destroy();
            }
        });
        cleanup.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isConnectedLocked()) {
                this.throwIfCalledByNotTrustedUidLocked();
            }
            this.throwIfShutdownLocked();
            this.mIsShutdown = true;
            if (this.isConnectedLocked()) {
                this.disconnect();
            }
        }
    }

    private void registerUiTestAutomationServiceLocked(IAccessibilityServiceClient client, int flags) {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        AccessibilityServiceInfo info = new AccessibilityServiceInfo();
        info.eventTypes = -1;
        info.feedbackType = 16;
        info.flags |= 0x10012;
        info.setCapabilities(15);
        try {
            manager.registerUiTestAutomationService(this.mToken, client, info, flags);
            this.mClient = client;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while registering UiTestAutomationService.", re);
        }
    }

    private void unregisterUiTestAutomationServiceLocked() {
        IAccessibilityManager manager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        try {
            manager.unregisterUiTestAutomationService(this.mClient);
            this.mClient = null;
        }
        catch (RemoteException re) {
            throw new IllegalStateException("Error while unregistering UiTestAutomationService", re);
        }
    }

    private void storeRotationStateLocked() {
        try {
            if (this.mWindowManager.isRotationFrozen()) {
                this.mInitialFrozenRotation = this.mWindowManager.getDefaultDisplayRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void restoreRotationStateLocked() {
        try {
            if (this.mInitialFrozenRotation != -1) {
                this.mWindowManager.freezeRotation(this.mInitialFrozenRotation);
            } else {
                this.mWindowManager.thawRotation();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private boolean isConnectedLocked() {
        return this.mClient != null;
    }

    private void throwIfShutdownLocked() {
        if (this.mIsShutdown) {
            throw new IllegalStateException("Connection shutdown!");
        }
    }

    private void throwIfNotConnectedLocked() {
        if (!this.isConnectedLocked()) {
            throw new IllegalStateException("Not connected!");
        }
    }

    private void throwIfCalledByNotTrustedUidLocked() {
        int callingUid = Binder.getCallingUid();
        if (callingUid != this.mOwningUid && this.mOwningUid != 1000 && callingUid != 0) {
            throw new SecurityException("Calling from not trusted UID!");
        }
    }

    public class Repeater
    implements Runnable {
        private final InputStream readFrom;
        private final OutputStream writeTo;

        public Repeater(InputStream readFrom, OutputStream writeTo) {
            this.readFrom = readFrom;
            this.writeTo = writeTo;
        }

        @Override
        public void run() {
            try {
                int readByteCount;
                byte[] buffer = new byte[8192];
                while ((readByteCount = this.readFrom.read(buffer)) >= 0) {
                    this.writeTo.write(buffer, 0, readByteCount);
                    this.writeTo.flush();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error while reading/writing ", ioe);
            }
            finally {
                IoUtils.closeQuietly(this.readFrom);
                IoUtils.closeQuietly(this.writeTo);
            }
        }
    }
}

