/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import libcore.io.IoUtils;
import org.apache.harmony.xml.ExpatAttributes;
import org.apache.harmony.xml.ExpatException;
import org.apache.harmony.xml.ExpatReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

class ExpatParser {
    private static final int BUFFER_SIZE = 8096;
    private long pointer;
    private boolean inStartElement = false;
    private int attributeCount = -1;
    private long attributePointer = 0L;
    private final Locator locator = new ExpatLocator();
    private final ExpatReader xmlReader;
    private final String publicId;
    private final String systemId;
    private final String encoding;
    private final ExpatAttributes attributes = new CurrentAttributes();
    private static final String OUTSIDE_START_ELEMENT = "Attributes can only be used within the scope of startElement().";
    private static final String DEFAULT_ENCODING = "UTF-8";
    static final String CHARACTER_ENCODING = "UTF-16";
    private static final int TIMEOUT = 20000;

    ExpatParser(String encoding, ExpatReader xmlReader, boolean processNamespaces, String publicId, String systemId) {
        this.publicId = publicId;
        this.systemId = systemId;
        this.xmlReader = xmlReader;
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
        this.pointer = this.initialize(this.encoding, processNamespaces);
    }

    private ExpatParser(String encoding, ExpatReader xmlReader, long pointer, String publicId, String systemId) {
        this.encoding = encoding;
        this.xmlReader = xmlReader;
        this.pointer = pointer;
        this.systemId = systemId;
        this.publicId = publicId;
    }

    private native long initialize(String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startElement(String uri, String localName, String qName, long attributePointer, int attributeCount) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler == null) {
            return;
        }
        try {
            this.inStartElement = true;
            this.attributePointer = attributePointer;
            this.attributeCount = attributeCount;
            contentHandler.startElement(uri, localName, qName, this.attributes);
        }
        finally {
            this.inStartElement = false;
            this.attributeCount = -1;
            this.attributePointer = 0L;
        }
    }

    void endElement(String uri, String localName, String qName) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.endElement(uri, localName, qName);
        }
    }

    void text(char[] text, int length) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.characters(text, 0, length);
        }
    }

    void comment(char[] text, int length) throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.comment(text, 0, length);
        }
    }

    void startCdata() throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.startCDATA();
        }
    }

    void endCdata() throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.endCDATA();
        }
    }

    void startNamespace(String prefix, String uri) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    void endNamespace(String prefix) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.endPrefixMapping(prefix);
        }
    }

    void startDtd(String name, String publicId, String systemId) throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    void endDtd() throws SAXException {
        LexicalHandler lexicalHandler = this.xmlReader.lexicalHandler;
        if (lexicalHandler != null) {
            lexicalHandler.endDTD();
        }
    }

    void processingInstruction(String target, String data) throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.processingInstruction(target, data);
        }
    }

    void notationDecl(String name, String publicId, String systemId) throws SAXException {
        DTDHandler dtdHandler = this.xmlReader.dtdHandler;
        if (dtdHandler != null) {
            dtdHandler.notationDecl(name, publicId, systemId);
        }
    }

    void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        DTDHandler dtdHandler = this.xmlReader.dtdHandler;
        if (dtdHandler != null) {
            dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleExternalEntity(String context, String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        EntityResolver entityResolver = this.xmlReader.entityResolver;
        if (entityResolver == null) {
            return;
        }
        if (this.systemId != null) {
            try {
                URI systemUri = new URI(systemId);
                if (!systemUri.isAbsolute() && !systemUri.isOpaque()) {
                    URI baseUri = new URI(this.systemId);
                    systemUri = baseUri.resolve(systemUri);
                    systemId = systemUri.toString();
                }
            }
            catch (Exception e) {
                System.logI((String)("Could not resolve '" + systemId + "' relative to" + " '" + this.systemId + "' at " + this.locator), (Throwable)e);
            }
        }
        if ((inputSource = entityResolver.resolveEntity(publicId, systemId)) == null) {
            return;
        }
        String encoding = this.pickEncoding(inputSource);
        long pointer = ExpatParser.createEntityParser(this.pointer, context);
        try {
            EntityParser entityParser = new EntityParser(encoding, this.xmlReader, pointer, inputSource.getPublicId(), inputSource.getSystemId());
            this.parseExternalEntity(entityParser, inputSource);
        }
        finally {
            ExpatParser.releaseParser(pointer);
        }
    }

    private String pickEncoding(InputSource inputSource) {
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            return CHARACTER_ENCODING;
        }
        String encoding = inputSource.getEncoding();
        return encoding == null ? DEFAULT_ENCODING : encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseExternalEntity(ExpatParser entityParser, InputSource inputSource) throws IOException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        if (reader != null) {
            try {
                entityParser.append("<externalEntity>");
                entityParser.parseFragment(reader);
                entityParser.append("</externalEntity>");
            }
            finally {
                IoUtils.closeQuietly(reader);
            }
            return;
        }
        InputStream in = inputSource.getByteStream();
        if (in != null) {
            try {
                entityParser.append("<externalEntity>".getBytes(entityParser.encoding));
                entityParser.parseFragment(in);
                entityParser.append("</externalEntity>".getBytes(entityParser.encoding));
            }
            finally {
                IoUtils.closeQuietly(in);
            }
            return;
        }
        String systemId = inputSource.getSystemId();
        if (systemId == null) {
            throw new ParseException("No input specified.", this.locator);
        }
        in = ExpatParser.openUrl(systemId);
        try {
            entityParser.append("<externalEntity>".getBytes(entityParser.encoding));
            entityParser.parseFragment(in);
            entityParser.append("</externalEntity>".getBytes(entityParser.encoding));
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    private static native long createEntityParser(long var0, String var2);

    void append(String xml2) throws SAXException {
        try {
            this.appendString(this.pointer, xml2, false);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator);
        }
    }

    private native void appendString(long var1, String var3, boolean var4) throws SAXException, ExpatException;

    void append(char[] xml2, int offset, int length) throws SAXException {
        try {
            this.appendChars(this.pointer, xml2, offset, length);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator);
        }
    }

    private native void appendChars(long var1, char[] var3, int var4, int var5) throws SAXException, ExpatException;

    void append(byte[] xml2) throws SAXException {
        this.append(xml2, 0, xml2.length);
    }

    void append(byte[] xml2, int offset, int length) throws SAXException {
        try {
            this.appendBytes(this.pointer, xml2, offset, length);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator);
        }
    }

    private native void appendBytes(long var1, byte[] var3, int var4, int var5) throws SAXException, ExpatException;

    void parseDocument(InputStream in) throws IOException, SAXException {
        this.startDocument();
        this.parseFragment(in);
        this.finish();
        this.endDocument();
    }

    void parseDocument(Reader in) throws IOException, SAXException {
        this.startDocument();
        this.parseFragment(in);
        this.finish();
        this.endDocument();
    }

    private void parseFragment(Reader in) throws IOException, SAXException {
        int length;
        char[] buffer = new char[4048];
        while ((length = in.read(buffer)) != -1) {
            try {
                this.appendChars(this.pointer, buffer, 0, length);
            }
            catch (ExpatException e) {
                throw new ParseException(e.getMessage(), this.locator);
            }
        }
    }

    private void parseFragment(InputStream in) throws IOException, SAXException {
        int length;
        byte[] buffer = new byte[8096];
        while ((length = in.read(buffer)) != -1) {
            try {
                this.appendBytes(this.pointer, buffer, 0, length);
            }
            catch (ExpatException e) {
                throw new ParseException(e.getMessage(), this.locator);
            }
        }
    }

    private void startDocument() throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.setDocumentLocator(this.locator);
            contentHandler.startDocument();
        }
    }

    private void endDocument() throws SAXException {
        ContentHandler contentHandler = this.xmlReader.contentHandler;
        if (contentHandler != null) {
            contentHandler.endDocument();
        }
    }

    void finish() throws SAXException {
        try {
            this.appendString(this.pointer, "", true);
        }
        catch (ExpatException e) {
            throw new ParseException(e.getMessage(), this.locator);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            if (this.pointer != 0L) {
                this.release(this.pointer);
                this.pointer = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    private native void release(long var1);

    private static native void releaseParser(long var0);

    private static native void staticInitialize(String var0);

    private int line() {
        return ExpatParser.line(this.pointer);
    }

    private static native int line(long var0);

    private int column() {
        return ExpatParser.column(this.pointer);
    }

    private static native int column(long var0);

    Attributes cloneAttributes() {
        if (!this.inStartElement) {
            throw new IllegalStateException(OUTSIDE_START_ELEMENT);
        }
        if (this.attributeCount == 0) {
            return ClonedAttributes.EMPTY;
        }
        long clonePointer = ExpatParser.cloneAttributes(this.attributePointer, this.attributeCount);
        return new ClonedAttributes(this.pointer, clonePointer, this.attributeCount);
    }

    private static native long cloneAttributes(long var0, int var2);

    static InputStream openUrl(String url) throws IOException {
        try {
            URLConnection urlConnection = new URL(url).openConnection();
            urlConnection.setConnectTimeout(20000);
            urlConnection.setReadTimeout(20000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(false);
            return urlConnection.getInputStream();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Couldn't open " + url);
            ioe.initCause(e);
            throw ioe;
        }
    }

    static {
        ExpatParser.staticInitialize("");
    }

    private static class EntityParser
    extends ExpatParser {
        private int depth = 0;

        private EntityParser(String encoding, ExpatReader xmlReader, long pointer, String publicId, String systemId) {
            super(encoding, xmlReader, pointer, publicId, systemId);
        }

        @Override
        void startElement(String uri, String localName, String qName, long attributePointer, int attributeCount) throws SAXException {
            if (this.depth++ > 0) {
                super.startElement(uri, localName, qName, attributePointer, attributeCount);
            }
        }

        @Override
        void endElement(String uri, String localName, String qName) throws SAXException {
            if (--this.depth > 0) {
                super.endElement(uri, localName, qName);
            }
        }

        @Override
        protected synchronized void finalize() throws Throwable {
        }
    }

    private static class ParseException
    extends SAXParseException {
        private ParseException(String message, Locator locator) {
            super(ParseException.makeMessage(message, locator), locator);
        }

        private static String makeMessage(String message, Locator locator) {
            return ParseException.makeMessage(message, locator.getLineNumber(), locator.getColumnNumber());
        }

        private static String makeMessage(String message, int line, int column) {
            return "At line " + line + ", column " + column + ": " + message;
        }
    }

    private class CurrentAttributes
    extends ExpatAttributes {
        private CurrentAttributes() {
        }

        @Override
        public long getParserPointer() {
            return ExpatParser.this.pointer;
        }

        @Override
        public long getPointer() {
            if (!ExpatParser.this.inStartElement) {
                throw new IllegalStateException(ExpatParser.OUTSIDE_START_ELEMENT);
            }
            return ExpatParser.this.attributePointer;
        }

        @Override
        public int getLength() {
            if (!ExpatParser.this.inStartElement) {
                throw new IllegalStateException(ExpatParser.OUTSIDE_START_ELEMENT);
            }
            return ExpatParser.this.attributeCount;
        }
    }

    private class ExpatLocator
    implements Locator {
        private ExpatLocator() {
        }

        @Override
        public String getPublicId() {
            return ExpatParser.this.publicId;
        }

        @Override
        public String getSystemId() {
            return ExpatParser.this.systemId;
        }

        @Override
        public int getLineNumber() {
            return ExpatParser.this.line();
        }

        @Override
        public int getColumnNumber() {
            return ExpatParser.this.column();
        }

        public String toString() {
            return "Locator[publicId: " + ExpatParser.this.publicId + ", systemId: " + ExpatParser.this.systemId + ", line: " + this.getLineNumber() + ", column: " + this.getColumnNumber() + "]";
        }
    }

    private static class ClonedAttributes
    extends ExpatAttributes {
        private static final Attributes EMPTY = new ClonedAttributes(0L, 0L, 0);
        private final long parserPointer;
        private long pointer;
        private final int length;

        private ClonedAttributes(long parserPointer, long pointer, int length) {
            this.parserPointer = parserPointer;
            this.pointer = pointer;
            this.length = length;
        }

        @Override
        public long getParserPointer() {
            return this.parserPointer;
        }

        @Override
        public long getPointer() {
            return this.pointer;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        protected synchronized void finalize() throws Throwable {
            try {
                if (this.pointer != 0L) {
                    this.freeAttributes(this.pointer);
                    this.pointer = 0L;
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

