/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import org.xml.sax.Attributes;

abstract class ExpatAttributes
implements Attributes {
    private static final String CDATA = "CDATA";

    ExpatAttributes() {
    }

    @Override
    public abstract int getLength();

    abstract long getParserPointer();

    public abstract long getPointer();

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ExpatAttributes.getURI(this.getParserPointer(), this.getPointer(), index);
    }

    @Override
    public String getLocalName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getLocalName(this.getParserPointer(), this.getPointer(), index);
    }

    @Override
    public String getQName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getQName(this.getParserPointer(), this.getPointer(), index);
    }

    @Override
    public String getType(int index) {
        return index < 0 || index >= this.getLength() ? null : CDATA;
    }

    @Override
    public String getValue(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getValueByIndex(this.getPointer(), index);
    }

    @Override
    public int getIndex(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return -1;
        }
        return ExpatAttributes.getIndex(pointer, uri, localName);
    }

    @Override
    public int getIndex(String qName) {
        if (qName == null) {
            throw new NullPointerException("qName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return -1;
        }
        return ExpatAttributes.getIndexForQName(pointer, qName);
    }

    @Override
    public String getType(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        return this.getIndex(uri, localName) == -1 ? null : CDATA;
    }

    @Override
    public String getType(String qName) {
        return this.getIndex(qName) == -1 ? null : CDATA;
    }

    @Override
    public String getValue(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return null;
        }
        return ExpatAttributes.getValue(pointer, uri, localName);
    }

    @Override
    public String getValue(String qName) {
        if (qName == null) {
            throw new NullPointerException("qName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return null;
        }
        return ExpatAttributes.getValueForQName(pointer, qName);
    }

    private static native String getURI(long var0, long var2, int var4);

    private static native String getLocalName(long var0, long var2, int var4);

    private static native String getQName(long var0, long var2, int var4);

    private static native String getValueByIndex(long var0, int var2);

    private static native int getIndex(long var0, String var2, String var3);

    private static native int getIndexForQName(long var0, String var2);

    private static native String getValue(long var0, String var2, String var3);

    private static native String getValueForQName(long var0, String var2);

    protected native void freeAttributes(long var1);
}

