/*
 * Decompiled with CFR 0.152.
 */
package libcore.net;

import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public abstract class UriCodec {
    private static final char INVALID_INPUT_CHARACTER = '\ufffd';

    protected abstract boolean isRetained(char var1);

    private static boolean isWhitelisted(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9';
    }

    private boolean isWhitelistedOrRetained(char c) {
        return UriCodec.isWhitelisted(c) || this.isRetained(c);
    }

    public final String validate(String uri, int start, int end, String name) throws URISyntaxException {
        int i = start;
        while (i < end) {
            char c;
            if (this.isWhitelistedOrRetained(c = uri.charAt(i++))) continue;
            if (c != '%') {
                throw UriCodec.unexpectedCharacterException(uri, name, c, i - 1);
            }
            for (int j = 0; j < 2; ++j) {
                if (UriCodec.hexCharToValue(c = UriCodec.getNextCharacter(uri, i++, end, name)) >= 0) continue;
                throw UriCodec.unexpectedCharacterException(uri, name, c, i - 1);
            }
        }
        return uri.substring(start, end);
    }

    private static int hexCharToValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return 10 + c - 97;
        }
        if ('A' <= c && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    private static URISyntaxException unexpectedCharacterException(String uri, String name, char unexpected, int index) {
        String nameString = name == null ? "" : " in [" + name + "]";
        return new URISyntaxException(uri, "Unexpected character" + nameString + ": " + unexpected, index);
    }

    private static char getNextCharacter(String uri, int index, int end, String name) throws URISyntaxException {
        if (index >= end) {
            String nameString = name == null ? "" : " in [" + name + "]";
            throw new URISyntaxException(uri, "Unexpected end of string" + nameString, index);
        }
        return uri.charAt(index);
    }

    public static void validateSimple(String uri, String legal) throws URISyntaxException {
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (UriCodec.isWhitelisted(c) || legal.indexOf(c) >= 0) continue;
            throw UriCodec.unexpectedCharacterException(uri, null, c, i);
        }
    }

    public final String encode(String s, Charset charset) {
        StringBuilder builder = new StringBuilder(s.length());
        this.appendEncoded(builder, s, charset, false);
        return builder.toString();
    }

    public final void appendEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, false);
    }

    public final void appendPartiallyEncoded(StringBuilder builder, String s) {
        this.appendEncoded(builder, s, StandardCharsets.UTF_8, true);
    }

    private void appendEncoded(StringBuilder builder, String s, Charset charset, boolean partiallyEncoded) {
        CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer cBuffer = CharBuffer.allocate(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '%' && partiallyEncoded) {
                UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
                builder.append('%');
                continue;
            }
            if (c == ' ' && this.isRetained(' ')) {
                UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
                builder.append('+');
                continue;
            }
            if (this.isWhitelistedOrRetained(c)) {
                UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
                builder.append(c);
                continue;
            }
            cBuffer.put(c);
        }
        UriCodec.flushEncodingCharBuffer(builder, encoder, cBuffer);
    }

    private static void flushEncodingCharBuffer(StringBuilder builder, CharsetEncoder encoder, CharBuffer cBuffer) {
        if (cBuffer.position() == 0) {
            return;
        }
        cBuffer.flip();
        ByteBuffer byteBuffer = ByteBuffer.allocate(cBuffer.remaining() * (int)Math.ceil(encoder.maxBytesPerChar()));
        byteBuffer.position(0);
        CoderResult result = encoder.encode(cBuffer, byteBuffer, true);
        if (result != CoderResult.UNDERFLOW) {
            throw new IllegalArgumentException("Error encoding, unexpected result [" + result.toString() + "] using encoder for [" + encoder.charset().name() + "]");
        }
        if (cBuffer.hasRemaining()) {
            throw new IllegalArgumentException("Encoder for [" + encoder.charset().name() + "] failed with underflow with " + "remaining input [" + cBuffer + "]");
        }
        encoder.flush(byteBuffer);
        if (result != CoderResult.UNDERFLOW) {
            throw new IllegalArgumentException("Error encoding, unexpected result [" + result.toString() + "] flushing encoder for [" + encoder.charset().name() + "]");
        }
        encoder.reset();
        byteBuffer.flip();
        while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            builder.append('%');
            builder.append(UriCodec.intToHexDigit((b & 0xF0) >>> 4));
            builder.append(UriCodec.intToHexDigit(b & 0xF));
        }
        cBuffer.flip();
        cBuffer.limit(cBuffer.capacity());
    }

    private static char intToHexDigit(int b) {
        if (b < 10) {
            return (char)(48 + b);
        }
        return (char)(65 + b - 10);
    }

    public static String decode(String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        StringBuilder builder = new StringBuilder(s.length());
        UriCodec.appendDecoded(builder, s, convertPlus, charset, throwOnFailure);
        return builder.toString();
    }

    private static void appendDecoded(StringBuilder builder, String s, boolean convertPlus, Charset charset, boolean throwOnFailure) {
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).replaceWith("\ufffd").onUnmappableCharacter(CodingErrorAction.REPORT);
        ByteBuffer byteBuffer = ByteBuffer.allocate(s.length());
        int i = 0;
        block6: while (i < s.length()) {
            char c = s.charAt(i);
            ++i;
            switch (c) {
                case '+': {
                    UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                    builder.append(convertPlus ? (char)' ' : '+');
                    continue block6;
                }
                case '%': {
                    byte hexValue = 0;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            c = UriCodec.getNextCharacter(s, i, s.length(), null);
                        }
                        catch (URISyntaxException e) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(e);
                            }
                            UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            return;
                        }
                        ++i;
                        int newDigit = UriCodec.hexCharToValue(c);
                        if (newDigit < 0) {
                            if (throwOnFailure) {
                                throw new IllegalArgumentException(UriCodec.unexpectedCharacterException(s, null, c, i - 1));
                            }
                            UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
                            builder.append('\ufffd');
                            break;
                        }
                        hexValue = (byte)(hexValue * 16 + newDigit);
                    }
                    byteBuffer.put(hexValue);
                    continue block6;
                }
            }
            UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
            builder.append(c);
        }
        UriCodec.flushDecodingByteAccumulator(builder, decoder, byteBuffer, throwOnFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushDecodingByteAccumulator(StringBuilder builder, CharsetDecoder decoder, ByteBuffer byteBuffer, boolean throwOnFailure) {
        if (byteBuffer.position() == 0) {
            return;
        }
        byteBuffer.flip();
        try {
            builder.append(decoder.decode(byteBuffer));
        }
        catch (CharacterCodingException e) {
            if (throwOnFailure) {
                throw new IllegalArgumentException(e);
            }
            builder.append('\ufffd');
        }
        finally {
            byteBuffer.flip();
            byteBuffer.limit(byteBuffer.capacity());
        }
    }

    public static String decode(String s) {
        return UriCodec.decode(s, false, StandardCharsets.UTF_8, true);
    }
}

