/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import libcore.util.BasicLruCache;
import libcore.util.ZoneInfoDB;

public final class TimeZoneNames {
    private static final String[] availableTimeZoneIds = TimeZone.getAvailableIDs();
    public static final int OLSON_NAME = 0;
    public static final int LONG_NAME = 1;
    public static final int SHORT_NAME = 2;
    public static final int LONG_NAME_DST = 3;
    public static final int SHORT_NAME_DST = 4;
    public static final int NAME_COUNT = 5;
    private static final ZoneStringsCache cachedZoneStrings = new ZoneStringsCache();
    private static final Comparator<String[]> ZONE_STRINGS_COMPARATOR = new Comparator<String[]>(){

        @Override
        public int compare(String[] lhs, String[] rhs) {
            return lhs[0].compareTo(rhs[0]);
        }
    };

    private TimeZoneNames() {
    }

    public static String getDisplayName(String[][] zoneStrings, String id2, boolean daylight, int style2) {
        String[] needle = new String[]{id2};
        int index = Arrays.binarySearch(zoneStrings, needle, ZONE_STRINGS_COMPARATOR);
        if (index >= 0) {
            String[] row = zoneStrings[index];
            if (daylight) {
                return style2 == 1 ? row[3] : row[4];
            }
            return style2 == 1 ? row[1] : row[2];
        }
        return null;
    }

    public static String[][] getZoneStrings(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (String[][])cachedZoneStrings.get(locale);
    }

    public static String[] forLocale(Locale locale) {
        String countryCode = locale.getCountry();
        ArrayList<String> ids = new ArrayList<String>();
        for (String line : ZoneInfoDB.getInstance().getZoneTab().split("\n")) {
            if (!line.startsWith(countryCode)) continue;
            int olsonIdStart = line.indexOf(9, 4) + 1;
            int olsonIdEnd = line.indexOf(9, olsonIdStart);
            if (olsonIdEnd == -1) {
                olsonIdEnd = line.length();
            }
            ids.add(line.substring(olsonIdStart, olsonIdEnd));
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static native String getExemplarLocation(String var0, String var1);

    private static native void fillZoneStrings(String var0, String[][] var1);

    public static class ZoneStringsCache
    extends BasicLruCache<Locale, String[][]> {
        public ZoneStringsCache() {
            super(5);
        }

        @Override
        protected String[][] create(Locale locale) {
            long start = System.nanoTime();
            String[][] result = new String[availableTimeZoneIds.length][5];
            for (int i = 0; i < availableTimeZoneIds.length; ++i) {
                result[i][0] = availableTimeZoneIds[i];
            }
            long nativeStart = System.nanoTime();
            TimeZoneNames.fillZoneStrings(locale.toLanguageTag(), result);
            long nativeEnd = System.nanoTime();
            this.addOffsetStrings(result);
            this.internStrings(result);
            long end = System.nanoTime();
            long nativeDuration = TimeUnit.NANOSECONDS.toMillis(nativeEnd - nativeStart);
            long duration = TimeUnit.NANOSECONDS.toMillis(end - start);
            System.logI((String)("Loaded time zone names for \"" + locale + "\" in " + duration + "ms" + " (" + nativeDuration + "ms in ICU)"));
            return result;
        }

        private void addOffsetStrings(String[][] result) {
            for (int i = 0; i < result.length; ++i) {
                TimeZone tz = null;
                for (int j = 1; j < 5; ++j) {
                    if (result[i][j] != null) continue;
                    if (tz == null) {
                        tz = TimeZone.getTimeZone(result[i][0]);
                    }
                    int offsetMillis = tz.getRawOffset();
                    if (j == 3 || j == 4) {
                        offsetMillis += tz.getDSTSavings();
                    }
                    result[i][j] = TimeZone.createGmtOffsetString((boolean)true, (boolean)true, (int)offsetMillis);
                }
            }
        }

        private void internStrings(String[][] result) {
            HashMap<String, String> internTable = new HashMap<String, String>();
            for (int i = 0; i < result.length; ++i) {
                for (int j = 1; j < 5; ++j) {
                    String original = result[i][j];
                    String nonDuplicate = (String)internTable.get(original);
                    if (nonDuplicate == null) {
                        internTable.put(original, original);
                        continue;
                    }
                    result[i][j] = nonDuplicate;
                }
            }
        }
    }
}

