/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import dalvik.system.DexPathList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import libcore.io.Libcore;

@Deprecated
public final class DexFile {
    private Object mCookie;
    private Object mInternalCookie;
    private final String mFileName;
    public static final int NO_DEXOPT_NEEDED = 0;
    public static final int DEX2OAT_FROM_SCRATCH = 1;
    public static final int DEX2OAT_FOR_BOOT_IMAGE = 2;
    public static final int DEX2OAT_FOR_FILTER = 3;
    public static final int DEX2OAT_FOR_RELOCATION = 4;

    @Deprecated
    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    DexFile(File file, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this(file.getPath(), loader, elements);
    }

    @Deprecated
    public DexFile(String fileName) throws IOException {
        this(fileName, null, null);
    }

    DexFile(String fileName, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(fileName, null, 0, loader, elements);
        this.mFileName = fileName;
    }

    DexFile(ByteBuffer buf) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openInMemoryDexFile(buf);
        this.mFileName = null;
    }

    private DexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        if (outputName != null) {
            try {
                String parent = new File(outputName).getParent();
                if (Libcore.os.getuid() != Libcore.os.stat((String)parent).st_uid) {
                    throw new IllegalArgumentException("Optimized data directory " + parent + " is not owned by the current user. Shared storage cannot protect" + " your application from code injection attacks.");
                }
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(sourceName, outputName, flags, loader, elements);
        this.mFileName = sourceName;
    }

    @Deprecated
    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return DexFile.loadDex(sourcePathName, outputPathName, flags, null, null);
    }

    static DexFile loadDex(String sourcePathName, String outputPathName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags, loader, elements);
    }

    public String getName() {
        return this.mFileName;
    }

    public String toString() {
        if (this.mFileName != null) {
            return this.getName();
        }
        return "InMemoryDexFile[cookie=" + Arrays.toString((long[])this.mCookie) + "]";
    }

    public void close() throws IOException {
        if (this.mInternalCookie != null) {
            if (DexFile.closeDexFile(this.mInternalCookie)) {
                this.mInternalCookie = null;
            }
            this.mCookie = null;
        }
    }

    public Class loadClass(String name, ClassLoader loader) {
        String slashName = name.replace('.', '/');
        return this.loadClassBinaryName(slashName, loader, null);
    }

    public Class loadClassBinaryName(String name, ClassLoader loader, List<Throwable> suppressed) {
        return DexFile.defineClass(name, loader, this.mCookie, this, suppressed);
    }

    private static Class defineClass(String name, ClassLoader loader, Object cookie, DexFile dexFile, List<Throwable> suppressed) {
        Class result;
        block4: {
            result = null;
            try {
                result = DexFile.defineClassNative(name, loader, cookie, dexFile);
            }
            catch (NoClassDefFoundError e) {
                if (suppressed != null) {
                    suppressed.add(e);
                }
            }
            catch (ClassNotFoundException e) {
                if (suppressed == null) break block4;
                suppressed.add(e);
            }
        }
        return result;
    }

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mInternalCookie != null && !DexFile.closeDexFile(this.mInternalCookie)) {
                throw new AssertionError((Object)"Failed to close dex file in finalizer.");
            }
            this.mInternalCookie = null;
            this.mCookie = null;
        }
        finally {
            super.finalize();
        }
    }

    private static Object openDexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return DexFile.openDexFileNative(new File(sourceName).getAbsolutePath(), outputName == null ? null : new File(outputName).getAbsolutePath(), flags, loader, elements);
    }

    private static Object openInMemoryDexFile(ByteBuffer buf) throws IOException {
        if (buf.isDirect()) {
            return DexFile.createCookieWithDirectBuffer(buf, buf.position(), buf.limit());
        }
        return DexFile.createCookieWithArray(buf.array(), buf.position(), buf.limit());
    }

    private static native Object createCookieWithDirectBuffer(ByteBuffer var0, int var1, int var2);

    private static native Object createCookieWithArray(byte[] var0, int var1, int var2);

    boolean isBackedByOatFile() {
        return DexFile.isBackedByOatFile(this.mCookie);
    }

    private static native boolean closeDexFile(Object var0);

    private static native Class defineClassNative(String var0, ClassLoader var1, Object var2, DexFile var3) throws ClassNotFoundException, NoClassDefFoundError;

    private static native String[] getClassNameList(Object var0);

    private static native boolean isBackedByOatFile(Object var0);

    private static native Object openDexFileNative(String var0, String var1, int var2, ClassLoader var3, DexPathList.Element[] var4);

    public static native boolean isDexOptNeeded(String var0) throws FileNotFoundException, IOException;

    public static native int getDexOptNeeded(String var0, String var1, String var2, boolean var3, boolean var4) throws FileNotFoundException, IOException;

    public static native String getDexFileStatus(String var0, String var1) throws FileNotFoundException;

    public static native String[] getDexFileOutputPaths(String var0, String var1) throws FileNotFoundException;

    public static native boolean isValidCompilerFilter(String var0);

    public static native boolean isProfileGuidedCompilerFilter(String var0);

    public static native String getNonProfileGuidedCompilerFilter(String var0);

    public static native String getSafeModeCompilerFilter(String var0);

    private static class DFEnum
    implements Enumeration<String> {
        private int mIndex = 0;
        private String[] mNameList;

        DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(df.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

