/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.EventLog;
import android.util.Slog;
import android.view.DisplayInfo;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DragResizeMode;
import com.android.server.wm.TaskStack;
import com.android.server.wm.TaskWindowContainerController;
import com.android.server.wm.WindowContainer;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import java.io.PrintWriter;
import java.util.function.Consumer;

class Task
extends WindowContainer<AppWindowToken>
implements DimLayer.DimLayerUser {
    static final String TAG = "WindowManager";
    private static final int BOUNDS_CHANGE_NONE = 0;
    private static final int BOUNDS_CHANGE_POSITION = 1;
    private static final int BOUNDS_CHANGE_SIZE = 2;
    TaskStack mStack;
    final int mTaskId;
    final int mUserId;
    private boolean mDeferRemoval = false;
    final WindowManagerService mService;
    private Rect mBounds = new Rect();
    final Rect mPreparedFrozenBounds = new Rect();
    final Configuration mPreparedFrozenMergedConfig = new Configuration();
    private final Rect mTempInsetBounds = new Rect();
    private int mRotation;
    private boolean mFillsParent = true;
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private int mResizeMode;
    private boolean mSupportsPictureInPicture;
    private boolean mDragResizing;
    private int mDragResizeMode;
    private boolean mHomeTask;
    private ActivityManager.TaskDescription mTaskDescription;
    private boolean mPreserveNonFloatingState = false;

    Task(int taskId, TaskStack stack, int userId, WindowManagerService service, Rect bounds, Configuration overrideConfig, int resizeMode, boolean supportsPictureInPicture, boolean homeTask, ActivityManager.TaskDescription taskDescription, TaskWindowContainerController controller) {
        this.mTaskId = taskId;
        this.mStack = stack;
        this.mUserId = userId;
        this.mService = service;
        this.mResizeMode = resizeMode;
        this.mSupportsPictureInPicture = supportsPictureInPicture;
        this.mHomeTask = homeTask;
        this.setController(controller);
        this.setBounds(bounds, overrideConfig);
        this.mTaskDescription = taskDescription;
        this.setOrientation(-2);
    }

    DisplayContent getDisplayContent() {
        return this.mStack != null ? this.mStack.getDisplayContent() : null;
    }

    private int getAdjustedAddPosition(int suggestedPosition) {
        int size = this.mChildren.size();
        if (suggestedPosition >= size) {
            return Math.min(size, suggestedPosition);
        }
        for (int pos = 0; pos < size && pos < suggestedPosition; ++pos) {
            if (!((AppWindowToken)this.mChildren.get((int)pos)).removed) continue;
            ++suggestedPosition;
        }
        return Math.min(size, suggestedPosition);
    }

    @Override
    void addChild(AppWindowToken wtoken, int position) {
        position = this.getAdjustedAddPosition(position);
        super.addChild(wtoken, position);
        this.mDeferRemoval = false;
    }

    @Override
    void positionChildAt(int position, AppWindowToken child, boolean includingParents) {
        position = this.getAdjustedAddPosition(position);
        super.positionChildAt(position, child, includingParents);
        this.mDeferRemoval = false;
    }

    private boolean hasWindowsAlive() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (!((AppWindowToken)this.mChildren.get(i)).hasWindowsAlive()) continue;
            return true;
        }
        return false;
    }

    boolean shouldDeferRemoval() {
        return this.hasWindowsAlive() && this.mStack.isAnimating();
    }

    @Override
    void removeIfPossible() {
        if (this.shouldDeferRemoval()) {
            this.mDeferRemoval = true;
            return;
        }
        this.removeImmediately();
    }

    @Override
    void removeImmediately() {
        EventLog.writeEvent(31003, this.mTaskId, "removeTask");
        this.mDeferRemoval = false;
        DisplayContent content = this.getDisplayContent();
        if (content != null) {
            content.mDimLayerController.removeDimLayerUser(this);
        }
        super.removeImmediately();
    }

    void reparent(TaskStack stack, int position, boolean moveParents) {
        if (stack == this.mStack) {
            throw new IllegalArgumentException("task=" + this + " already child of stack=" + this.mStack);
        }
        EventLog.writeEvent(31003, this.mTaskId, "reParentTask");
        DisplayContent prevDisplayContent = this.getDisplayContent();
        this.mPreserveNonFloatingState = stack.mStackId == 4;
        this.getParent().removeChild(this);
        stack.addTask(this, position, this.showForAllUsers(), moveParents);
        DisplayContent displayContent = stack.getDisplayContent();
        displayContent.setLayoutNeeded();
        if (prevDisplayContent != displayContent) {
            this.onDisplayChanged(displayContent);
            prevDisplayContent.setLayoutNeeded();
        }
    }

    void positionAt(int position, Rect bounds, Configuration overrideConfig) {
        this.mStack.positionChildAt(position, this, false);
        this.resizeLocked(bounds, overrideConfig, false);
    }

    @Override
    void onParentSet() {
        this.updateDisplayInfo(this.getDisplayContent());
        if (ActivityManager.StackId.windowsAreScaleable(this.mStack.mStackId)) {
            this.forceWindowsScaleable(true);
        } else {
            this.forceWindowsScaleable(false);
        }
    }

    @Override
    void removeChild(AppWindowToken token) {
        if (!this.mChildren.contains(token)) {
            Slog.e(TAG, "removeChild: token=" + this + " not found.");
            return;
        }
        super.removeChild(token);
        if (this.mChildren.isEmpty()) {
            EventLog.writeEvent(31003, this.mTaskId, "removeAppToken: last token");
            if (this.mDeferRemoval) {
                this.removeIfPossible();
            }
        }
    }

    void setSendingToBottom(boolean toBottom) {
        for (int appTokenNdx = 0; appTokenNdx < this.mChildren.size(); ++appTokenNdx) {
            ((AppWindowToken)this.mChildren.get((int)appTokenNdx)).sendingToBottom = toBottom;
        }
    }

    private int setBounds(Rect bounds, Configuration overrideConfig) {
        if (overrideConfig == null) {
            overrideConfig = Configuration.EMPTY;
        }
        if (bounds == null && !Configuration.EMPTY.equals(overrideConfig)) {
            throw new IllegalArgumentException("null bounds but non empty configuration: " + overrideConfig);
        }
        if (bounds != null && Configuration.EMPTY.equals(overrideConfig)) {
            throw new IllegalArgumentException("non null bounds, but empty configuration");
        }
        boolean oldFullscreen = this.mFillsParent;
        int rotation = 0;
        DisplayContent displayContent = this.mStack.getDisplayContent();
        if (displayContent != null) {
            displayContent.getLogicalDisplayRect(this.mTmpRect);
            rotation = displayContent.getDisplayInfo().rotation;
            boolean bl = this.mFillsParent = bounds == null;
            if (this.mFillsParent) {
                bounds = this.mTmpRect;
            }
        }
        if (bounds == null) {
            return 0;
        }
        if (this.mBounds.equals(bounds) && oldFullscreen == this.mFillsParent && this.mRotation == rotation) {
            return 0;
        }
        int boundsChange = 0;
        if (this.mBounds.left != bounds.left || this.mBounds.top != bounds.top) {
            boundsChange |= 1;
        }
        if (this.mBounds.width() != bounds.width() || this.mBounds.height() != bounds.height()) {
            boundsChange |= 2;
        }
        this.mBounds.set(bounds);
        this.mRotation = rotation;
        if (displayContent != null) {
            displayContent.mDimLayerController.updateDimLayer(this);
        }
        this.onOverrideConfigurationChanged(this.mFillsParent ? Configuration.EMPTY : overrideConfig);
        return boundsChange;
    }

    void setTempInsetBounds(Rect tempInsetBounds) {
        if (tempInsetBounds != null) {
            this.mTempInsetBounds.set(tempInsetBounds);
        } else {
            this.mTempInsetBounds.setEmpty();
        }
    }

    void getTempInsetBounds(Rect out) {
        out.set(this.mTempInsetBounds);
    }

    void setResizeable(int resizeMode) {
        this.mResizeMode = resizeMode;
    }

    boolean isResizeable() {
        return ActivityInfo.isResizeableMode(this.mResizeMode) || this.mSupportsPictureInPicture || this.mService.mForceResizableTasks;
    }

    boolean preserveOrientationOnResize() {
        return this.mResizeMode == 6 || this.mResizeMode == 5 || this.mResizeMode == 7;
    }

    boolean cropWindowsToStackBounds() {
        return this.isResizeable();
    }

    boolean isHomeTask() {
        return this.mHomeTask;
    }

    boolean resizeLocked(Rect bounds, Configuration overrideConfig, boolean forced) {
        int boundsChanged = this.setBounds(bounds, overrideConfig);
        if (forced) {
            boundsChanged |= 2;
        }
        if (boundsChanged == 0) {
            return false;
        }
        if ((boundsChanged & 2) == 2) {
            this.onResize();
        } else {
            this.onMovedByResize();
        }
        return true;
    }

    void prepareFreezingBounds() {
        this.mPreparedFrozenBounds.set(this.mBounds);
        this.mPreparedFrozenMergedConfig.setTo(this.getConfiguration());
    }

    void alignToAdjustedBounds(Rect adjustedBounds, Rect tempInsetBounds, boolean alignBottom) {
        if (!this.isResizeable() || Configuration.EMPTY.equals(this.getOverrideConfiguration())) {
            return;
        }
        this.getBounds(this.mTmpRect2);
        if (alignBottom) {
            int offsetY = adjustedBounds.bottom - this.mTmpRect2.bottom;
            this.mTmpRect2.offset(0, offsetY);
        } else {
            this.mTmpRect2.offsetTo(adjustedBounds.left, adjustedBounds.top);
        }
        this.setTempInsetBounds(tempInsetBounds);
        this.resizeLocked(this.mTmpRect2, this.getOverrideConfiguration(), false);
    }

    private boolean useCurrentBounds() {
        DisplayContent displayContent = this.mStack.getDisplayContent();
        return this.mFillsParent || !ActivityManager.StackId.isTaskResizeableByDockedStack(this.mStack.mStackId) || displayContent == null || displayContent.getDockedStackIgnoringVisibility() != null;
    }

    void getBounds(Rect out) {
        if (this.useCurrentBounds()) {
            out.set(this.mBounds);
            return;
        }
        this.mStack.getDisplayContent().getLogicalDisplayRect(out);
    }

    boolean getMaxVisibleBounds(Rect out) {
        boolean foundTop = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win;
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            if (token.mIsExiting || token.isClientHidden() || token.hiddenRequested || (win = token.findMainWindow()) == null) continue;
            if (!foundTop) {
                out.set(win.mVisibleFrame);
                foundTop = true;
                continue;
            }
            if (win.mVisibleFrame.left < out.left) {
                out.left = win.mVisibleFrame.left;
            }
            if (win.mVisibleFrame.top < out.top) {
                out.top = win.mVisibleFrame.top;
            }
            if (win.mVisibleFrame.right > out.right) {
                out.right = win.mVisibleFrame.right;
            }
            if (win.mVisibleFrame.bottom <= out.bottom) continue;
            out.bottom = win.mVisibleFrame.bottom;
        }
        return foundTop;
    }

    @Override
    public void getDimBounds(Rect out) {
        boolean dockedResizing;
        DisplayContent displayContent = this.mStack.getDisplayContent();
        boolean bl = dockedResizing = displayContent != null && displayContent.mDividerControllerLocked.isResizing();
        if (this.useCurrentBounds()) {
            if (this.inFreeformWorkspace() && this.getMaxVisibleBounds(out)) {
                return;
            }
            if (!this.mFillsParent) {
                if (dockedResizing) {
                    this.mStack.getBounds(out);
                } else {
                    this.mStack.getBounds(this.mTmpRect);
                    this.mTmpRect.intersect(this.mBounds);
                }
                out.set(this.mTmpRect);
            } else {
                out.set(this.mBounds);
            }
            return;
        }
        if (displayContent != null) {
            displayContent.getLogicalDisplayRect(out);
        }
    }

    void setDragResizing(boolean dragResizing, int dragResizeMode) {
        if (this.mDragResizing != dragResizing) {
            if (!DragResizeMode.isModeAllowedForStack(this.mStack.mStackId, dragResizeMode)) {
                throw new IllegalArgumentException("Drag resize mode not allow for stack stackId=" + this.mStack.mStackId + " dragResizeMode=" + dragResizeMode);
            }
            this.mDragResizing = dragResizing;
            this.mDragResizeMode = dragResizeMode;
            this.resetDragResizingChangeReported();
        }
    }

    boolean isDragResizing() {
        return this.mDragResizing;
    }

    int getDragResizeMode() {
        return this.mDragResizeMode;
    }

    void updateDisplayInfo(DisplayContent displayContent) {
        TaskWindowContainerController controller;
        if (displayContent == null) {
            return;
        }
        if (this.mFillsParent) {
            this.setBounds(null, Configuration.EMPTY);
            return;
        }
        int newRotation = displayContent.getDisplayInfo().rotation;
        if (this.mRotation == newRotation) {
            return;
        }
        this.mTmpRect2.set(this.mBounds);
        if (!ActivityManager.StackId.isTaskResizeAllowed(this.mStack.mStackId)) {
            this.setBounds(this.mTmpRect2, this.getOverrideConfiguration());
            return;
        }
        displayContent.rotateBounds(this.mRotation, newRotation, this.mTmpRect2);
        if (this.setBounds(this.mTmpRect2, this.getOverrideConfiguration()) != 0 && (controller = this.getController()) != null) {
            controller.requestResize(this.mBounds, 1);
        }
    }

    void cancelTaskWindowTransition() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((AppWindowToken)this.mChildren.get((int)i)).mAppAnimator.clearAnimation();
        }
    }

    void cancelTaskThumbnailTransition() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((AppWindowToken)this.mChildren.get((int)i)).mAppAnimator.clearThumbnail();
        }
    }

    boolean showForAllUsers() {
        int tokensCount = this.mChildren.size();
        return tokensCount != 0 && ((AppWindowToken)this.mChildren.get((int)(tokensCount - 1))).mShowForAllUsers;
    }

    boolean inFreeformWorkspace() {
        return this.mStack != null && this.mStack.mStackId == 2;
    }

    boolean inPinnedWorkspace() {
        return this.mStack != null && this.mStack.mStackId == 4;
    }

    boolean isFloating() {
        return ActivityManager.StackId.tasksAreFloating(this.mStack.mStackId) && !this.mStack.isAnimatingBoundsToFullscreen() && !this.mPreserveNonFloatingState;
    }

    WindowState getTopVisibleAppMainWindow() {
        AppWindowToken token = this.getTopVisibleAppToken();
        return token != null ? token.findMainWindow() : null;
    }

    AppWindowToken getTopFullscreenAppToken() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            WindowState win = token.findMainWindow();
            if (win == null || !win.mAttrs.isFullscreen()) continue;
            return token;
        }
        return null;
    }

    AppWindowToken getTopVisibleAppToken() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken token = (AppWindowToken)this.mChildren.get(i);
            if (token.mIsExiting || token.isClientHidden() || token.hiddenRequested) continue;
            return token;
        }
        return null;
    }

    @Override
    public boolean dimFullscreen() {
        return this.isFullscreen();
    }

    @Override
    public int getLayerForDim(WindowStateAnimator animator2, int layerOffset, int defaultLayer) {
        AppWindowToken appToken = animator2.mWin.mAppToken;
        if (animator2.mAttrType == 3 && this.hasChild(appToken)) {
            return Math.min(defaultLayer, appToken.getLowestAnimLayer() - layerOffset);
        }
        return defaultLayer;
    }

    boolean isFullscreen() {
        if (this.useCurrentBounds()) {
            return this.mFillsParent;
        }
        return true;
    }

    @Override
    public DisplayInfo getDisplayInfo() {
        return this.getDisplayContent().getDisplayInfo();
    }

    @Override
    public boolean isAttachedToDisplay() {
        return this.getDisplayContent() != null;
    }

    void forceWindowsScaleable(boolean force) {
        this.mService.openSurfaceTransaction();
        try {
            for (int i = this.mChildren.size() - 1; i >= 0; --i) {
                ((AppWindowToken)this.mChildren.get(i)).forceWindowsScaleableInTransaction(force);
            }
        }
        finally {
            this.mService.closeSurfaceTransaction();
        }
    }

    void setTaskDescription(ActivityManager.TaskDescription taskDescription) {
        this.mTaskDescription = taskDescription;
    }

    ActivityManager.TaskDescription getTaskDescription() {
        return this.mTaskDescription;
    }

    @Override
    boolean fillsParent() {
        return this.mFillsParent || !ActivityManager.StackId.isTaskResizeAllowed(this.mStack.mStackId);
    }

    @Override
    TaskWindowContainerController getController() {
        return (TaskWindowContainerController)super.getController();
    }

    @Override
    void forAllTasks(Consumer<Task> callback) {
        callback.accept(this);
    }

    public String toString() {
        return "{taskId=" + this.mTaskId + " appTokens=" + this.mChildren + " mdr=" + this.mDeferRemoval + "}";
    }

    @Override
    String getName() {
        return this.toShortString();
    }

    void clearPreserveNonFloatingState() {
        this.mPreserveNonFloatingState = false;
    }

    @Override
    public String toShortString() {
        return "Task=" + this.mTaskId;
    }

    public void dump(String prefix, PrintWriter pw) {
        String doublePrefix = prefix + "  ";
        pw.println(prefix + "taskId=" + this.mTaskId);
        pw.println(doublePrefix + "mFillsParent=" + this.mFillsParent);
        pw.println(doublePrefix + "mBounds=" + this.mBounds.toShortString());
        pw.println(doublePrefix + "mdr=" + this.mDeferRemoval);
        pw.println(doublePrefix + "appTokens=" + this.mChildren);
        pw.println(doublePrefix + "mTempInsetBounds=" + this.mTempInsetBounds.toShortString());
        String triplePrefix = doublePrefix + "  ";
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken = (AppWindowToken)this.mChildren.get(i);
            pw.println(triplePrefix + "Activity #" + i + " " + wtoken);
            wtoken.dump(pw, triplePrefix);
        }
    }
}

