/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import com.android.server.wm.RemoteEventTrace;
import com.android.server.wm.SurfaceControlWithBackground;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;

class RemoteSurfaceTrace
extends SurfaceControlWithBackground {
    static final String TAG = "RemoteSurfaceTrace";
    final FileDescriptor mWriteFd;
    final DataOutputStream mOut;
    final WindowManagerService mService;
    final WindowState mWindow;

    RemoteSurfaceTrace(FileDescriptor fd, SurfaceControlWithBackground wrapped, WindowState window) {
        super(wrapped);
        this.mWriteFd = fd;
        this.mOut = new DataOutputStream(new FileOutputStream(fd, false));
        this.mWindow = window;
        this.mService = this.mWindow.mService;
    }

    @Override
    public void setAlpha(float alpha) {
        this.writeFloatEvent("Alpha", alpha);
        super.setAlpha(alpha);
    }

    @Override
    public void setLayer(int zorder) {
        this.writeIntEvent("Layer", zorder);
        super.setLayer(zorder);
    }

    @Override
    public void setPosition(float x, float y) {
        this.writeFloatEvent("Position", x, y);
        super.setPosition(x, y);
    }

    @Override
    public void setGeometryAppliesWithResize() {
        this.writeEvent("GeometryAppliesWithResize");
        super.setGeometryAppliesWithResize();
    }

    @Override
    public void setSize(int w, int h) {
        this.writeIntEvent("Size", w, h);
        super.setSize(w, h);
    }

    @Override
    public void setWindowCrop(Rect crop) {
        this.writeRectEvent("Crop", crop);
        super.setWindowCrop(crop);
    }

    @Override
    public void setFinalCrop(Rect crop) {
        this.writeRectEvent("FinalCrop", crop);
        super.setFinalCrop(crop);
    }

    @Override
    public void setLayerStack(int layerStack) {
        this.writeIntEvent("LayerStack", layerStack);
        super.setLayerStack(layerStack);
    }

    @Override
    public void setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
        this.writeFloatEvent("Matrix", dsdx, dtdx, dsdy, dtdy);
        super.setMatrix(dsdx, dtdx, dsdy, dtdy);
    }

    @Override
    public void hide() {
        this.writeEvent("Hide");
        super.hide();
    }

    @Override
    public void show() {
        this.writeEvent("Show");
        super.show();
    }

    private void writeEvent(String tag) {
        try {
            this.mOut.writeUTF(tag);
            this.mOut.writeUTF(this.mWindow.getWindowTag().toString());
            this.writeSigil();
        }
        catch (Exception e) {
            RemoteEventTrace.logException(e);
            this.mService.disableSurfaceTrace();
        }
    }

    private void writeIntEvent(String tag, int ... values) {
        try {
            this.mOut.writeUTF(tag);
            this.mOut.writeUTF(this.mWindow.getWindowTag().toString());
            for (int value : values) {
                this.mOut.writeInt(value);
            }
            this.writeSigil();
        }
        catch (Exception e) {
            RemoteEventTrace.logException(e);
            this.mService.disableSurfaceTrace();
        }
    }

    private void writeFloatEvent(String tag, float ... values) {
        try {
            this.mOut.writeUTF(tag);
            this.mOut.writeUTF(this.mWindow.getWindowTag().toString());
            for (float value : values) {
                this.mOut.writeFloat(value);
            }
            this.writeSigil();
        }
        catch (Exception e) {
            RemoteEventTrace.logException(e);
            this.mService.disableSurfaceTrace();
        }
    }

    private void writeRectEvent(String tag, Rect value) {
        this.writeFloatEvent(tag, value.left, value.top, value.right, value.bottom);
    }

    private void writeSigil() throws Exception {
        this.mOut.write(RemoteEventTrace.sigil, 0, 4);
    }
}

