/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.graphics.Rect;
import com.android.server.wm.BoundsAnimationTarget;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.PinnedStackController;
import com.android.server.wm.PinnedStackWindowListener;
import com.android.server.wm.StackWindowController;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.util.List;

public class PinnedStackWindowController
extends StackWindowController {
    private Rect mTmpFromBounds = new Rect();
    private Rect mTmpToBounds = new Rect();

    public PinnedStackWindowController(int stackId, PinnedStackWindowListener listener, int displayId, boolean onTop, Rect outBounds) {
        super(stackId, listener, displayId, onTop, outBounds, WindowManagerService.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rect getPictureInPictureBounds(float aspectRatio, Rect stackBounds) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return null;
                }
                DisplayContent displayContent = ((TaskStack)this.mContainer).getDisplayContent();
                if (displayContent == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return null;
                }
                PinnedStackController pinnedStackController = displayContent.getPinnedStackController();
                if (stackBounds == null) {
                    stackBounds = pinnedStackController.getDefaultBounds();
                }
                if (pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio)) {
                    Rect rect = pinnedStackController.transformBoundsToAspectRatio(stackBounds, aspectRatio, true);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl19 : MonitorExitStatement: MONITOREXIT : var3_3
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return rect;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                return stackBounds;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl26 : MonitorExitStatement: MONITOREXIT : var3_3
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animateResizePinnedStack(Rect toBounds, Rect sourceHintBounds, int animationDuration, boolean fromFullscreen) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                boolean toFullscreen;
                WindowManagerService.boostPriorityForLockedSection();
                if (this.mContainer == null) {
                    throw new IllegalArgumentException("Pinned stack container not found :(");
                }
                Rect fromBounds = new Rect();
                ((TaskStack)this.mContainer).getBounds(fromBounds);
                int schedulePipModeChangedState = 0;
                boolean bl = toFullscreen = toBounds == null;
                if (toFullscreen) {
                    if (fromFullscreen) {
                        throw new IllegalArgumentException("Should not defer scheduling PiP mode change on animation to fullscreen.");
                    }
                    schedulePipModeChangedState = 1;
                    this.mService.getStackBounds(1, this.mTmpToBounds);
                    if (!this.mTmpToBounds.isEmpty()) {
                        toBounds = new Rect(this.mTmpToBounds);
                    } else {
                        toBounds = new Rect();
                        ((TaskStack)this.mContainer).getDisplayContent().getLogicalDisplayRect(toBounds);
                    }
                } else if (fromFullscreen) {
                    schedulePipModeChangedState = 2;
                }
                ((TaskStack)this.mContainer).setAnimationFinalBounds(sourceHintBounds, toBounds, toFullscreen);
                Rect finalToBounds = toBounds;
                int finalSchedulePipModeChangedState = schedulePipModeChangedState;
                this.mService.mBoundsAnimationController.getHandler().post(() -> {
                    if (this.mContainer == null) {
                        return;
                    }
                    this.mService.mBoundsAnimationController.animateBounds((BoundsAnimationTarget)((Object)this.mContainer), fromBounds, finalToBounds, animationDuration, finalSchedulePipModeChangedState, fromFullscreen, toFullscreen);
                });
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl29 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl33 : MonitorExitStatement: MONITOREXIT : var5_5
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureAspectRatio(float aspectRatio) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                PinnedStackController pinnedStackController = ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController();
                if (Float.compare(aspectRatio, pinnedStackController.getAspectRatio()) != 0) {
                    ((TaskStack)this.mContainer).getAnimationOrCurrentBounds(this.mTmpFromBounds);
                    this.mTmpToBounds.set(this.mTmpFromBounds);
                    this.getPictureInPictureBounds(aspectRatio, this.mTmpToBounds);
                    if (!this.mTmpToBounds.equals(this.mTmpFromBounds)) {
                        this.animateResizePinnedStack(this.mTmpToBounds, null, -1, false);
                    }
                    pinnedStackController.setAspectRatio(pinnedStackController.isValidPictureInPictureAspectRatio(aspectRatio) ? aspectRatio : -1.0f);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPictureInPictureActions(List<RemoteAction> actions) {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (!this.mService.mSupportsPictureInPicture || this.mContainer == null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    WindowManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                ((TaskStack)this.mContainer).getDisplayContent().getPinnedStackController().setActions(actions);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deferScheduleMultiWindowModeChanged() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                boolean bl = ((TaskStack)this.mContainer).deferScheduleMultiWindowModeChanged();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnimatingBoundsToFullscreen() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                boolean bl = ((TaskStack)this.mContainer).isAnimatingBoundsToFullscreen();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinnedStackResizeDisallowed() {
        WindowHashMap windowHashMap = this.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                boolean bl = ((TaskStack)this.mContainer).pinnedStackResizeDisallowed();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                return bl;
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    public void updatePictureInPictureModeForPinnedStackAnimation(Rect targetStackBounds, boolean forceUpdate) {
        if (this.mListener != null) {
            PinnedStackWindowListener listener = (PinnedStackWindowListener)this.mListener;
            listener.updatePictureInPictureModeForPinnedStackAnimation(targetStackBounds, forceUpdate);
        }
    }
}

