/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.graphics.Rect;
import android.os.Debug;
import android.os.Looper;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Slog;
import android.view.InputChannel;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.WindowManagerPolicy;
import com.android.server.input.InputApplicationHandle;
import com.android.server.input.InputManagerService;
import com.android.server.input.InputWindowHandle;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.InputConsumerImpl;
import com.android.server.wm.WallpaperController;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;

final class InputMonitor
implements InputManagerService.WindowManagerCallbacks {
    private final WindowManagerService mService;
    private WindowState mInputFocus;
    private boolean mInputDispatchFrozen;
    private String mInputFreezeReason = null;
    private boolean mInputDispatchEnabled;
    private boolean mUpdateInputWindowsNeeded = true;
    private InputWindowHandle[] mInputWindowHandles;
    private int mInputWindowHandleCount;
    private InputWindowHandle mFocusedInputWindowHandle;
    private boolean mAddInputConsumerHandle;
    private boolean mAddPipInputConsumerHandle;
    private boolean mAddWallpaperInputConsumerHandle;
    private boolean mDisableWallpaperTouchEvents;
    private final Rect mTmpRect = new Rect();
    private final UpdateInputForAllWindowsConsumer mUpdateInputForAllWindowsConsumer = new UpdateInputForAllWindowsConsumer();
    private final Object mInputDevicesReadyMonitor = new Object();
    private boolean mInputDevicesReady;
    private final ArrayMap<String, InputConsumerImpl> mInputConsumers = new ArrayMap();

    public InputMonitor(WindowManagerService service) {
        this.mService = service;
    }

    private void addInputConsumer(String name, InputConsumerImpl consumer) {
        this.mInputConsumers.put(name, consumer);
        this.updateInputWindowsLw(true);
    }

    boolean destroyInputConsumer(String name) {
        if (this.disposeInputConsumer(this.mInputConsumers.remove(name))) {
            this.updateInputWindowsLw(true);
            return true;
        }
        return false;
    }

    private boolean disposeInputConsumer(InputConsumerImpl consumer) {
        if (consumer != null) {
            consumer.disposeChannelsLw();
            return true;
        }
        return false;
    }

    InputConsumerImpl getInputConsumer(String name, int displayId) {
        return displayId == 0 ? this.mInputConsumers.get(name) : null;
    }

    void layoutInputConsumers(int dw, int dh) {
        for (int i = this.mInputConsumers.size() - 1; i >= 0; --i) {
            this.mInputConsumers.valueAt(i).layout(dw, dh);
        }
    }

    WindowManagerPolicy.InputConsumer createInputConsumer(Looper looper, String name, InputEventReceiver.Factory inputEventReceiverFactory) {
        if (this.mInputConsumers.containsKey(name)) {
            throw new IllegalStateException("Existing input consumer found with name: " + name);
        }
        EventReceiverInputConsumer consumer = new EventReceiverInputConsumer(this.mService, this, looper, name, inputEventReceiverFactory);
        this.addInputConsumer(name, consumer);
        return consumer;
    }

    void createInputConsumer(String name, InputChannel inputChannel) {
        if (this.mInputConsumers.containsKey(name)) {
            throw new IllegalStateException("Existing input consumer found with name: " + name);
        }
        InputConsumerImpl consumer = new InputConsumerImpl(this.mService, name, inputChannel);
        switch (name) {
            case "wallpaper_input_consumer": {
                consumer.mWindowHandle.hasWallpaper = true;
                break;
            }
            case "pip_input_consumer": {
                consumer.mWindowHandle.layoutParamsFlags |= 0x20;
            }
        }
        this.addInputConsumer(name, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyInputChannelBroken(InputWindowHandle inputWindowHandle) {
        if (inputWindowHandle == null) {
            return;
        }
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                WindowState windowState = (WindowState)inputWindowHandle.windowState;
                if (windowState != null) {
                    Slog.i("WindowManager", "WINDOW DIED " + windowState);
                    windowState.removeIfPossible();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long notifyANR(InputApplicationHandle inputApplicationHandle, InputWindowHandle inputWindowHandle, String reason) {
        AppWindowToken appWindowToken = null;
        WindowState windowState = null;
        boolean aboveSystem = false;
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            try {
                WindowManagerService.boostPriorityForLockedSection();
                if (inputWindowHandle != null && (windowState = (WindowState)inputWindowHandle.windowState) != null) {
                    appWindowToken = windowState.mAppToken;
                }
                if (appWindowToken == null && inputApplicationHandle != null) {
                    appWindowToken = (AppWindowToken)inputApplicationHandle.appWindowToken;
                }
                if (windowState != null) {
                    Slog.i("WindowManager", "Input event dispatching timed out sending to " + windowState.mAttrs.getTitle() + ".  Reason: " + reason);
                    int systemAlertLayer = this.mService.mPolicy.getWindowLayerFromTypeLw(2038, windowState.mOwnerCanAddInternalSystemWindow);
                    aboveSystem = windowState.mBaseLayer > systemAlertLayer;
                } else if (appWindowToken != null) {
                    Slog.i("WindowManager", "Input event dispatching timed out sending to application " + appWindowToken.stringName + ".  Reason: " + reason);
                } else {
                    Slog.i("WindowManager", "Input event dispatching timed out .  Reason: " + reason);
                }
                this.mService.saveANRStateLocked(appWindowToken, windowState, reason);
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl25 : MonitorExitStatement: MONITOREXIT : var7_7
                WindowManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 3] lbl29 : MonitorExitStatement: MONITOREXIT : var7_7
                WindowManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        this.mService.mAmInternal.saveANRState(reason);
        if (appWindowToken != null && appWindowToken.appToken != null) {
            boolean abort;
            AppWindowContainerController controller = appWindowToken.getController();
            boolean bl = controller != null && controller.keyDispatchingTimedOut(reason, windowState != null ? windowState.mSession.mPid : -1) ? true : (abort = false);
            if (!abort) {
                return appWindowToken.mInputDispatchingTimeoutNanos;
            }
        } else if (windowState != null) {
            try {
                long timeout = ActivityManager.getService().inputDispatchingTimedOut(windowState.mSession.mPid, aboveSystem, reason);
                if (timeout >= 0L) {
                    return timeout * 1000000L;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private void addInputWindowHandle(InputWindowHandle windowHandle) {
        if (this.mInputWindowHandles == null) {
            this.mInputWindowHandles = new InputWindowHandle[16];
        }
        if (this.mInputWindowHandleCount >= this.mInputWindowHandles.length) {
            this.mInputWindowHandles = Arrays.copyOf(this.mInputWindowHandles, this.mInputWindowHandleCount * 2);
        }
        this.mInputWindowHandles[this.mInputWindowHandleCount++] = windowHandle;
    }

    void addInputWindowHandle(InputWindowHandle inputWindowHandle, WindowState child, int flags, int type, boolean isVisible, boolean hasFocus, boolean hasWallpaper) {
        inputWindowHandle.name = child.toString();
        inputWindowHandle.layoutParamsFlags = flags = child.getTouchableRegion(inputWindowHandle.touchableRegion, flags);
        inputWindowHandle.layoutParamsType = type;
        inputWindowHandle.dispatchingTimeoutNanos = child.getInputDispatchingTimeoutNanos();
        inputWindowHandle.visible = isVisible;
        inputWindowHandle.canReceiveKeys = child.canReceiveKeys();
        inputWindowHandle.hasFocus = hasFocus;
        inputWindowHandle.hasWallpaper = hasWallpaper;
        inputWindowHandle.paused = child.mAppToken != null ? child.mAppToken.paused : false;
        inputWindowHandle.layer = child.mLayer;
        inputWindowHandle.ownerPid = child.mSession.mPid;
        inputWindowHandle.ownerUid = child.mSession.mUid;
        inputWindowHandle.inputFeatures = child.mAttrs.inputFeatures;
        Rect frame = child.mFrame;
        inputWindowHandle.frameLeft = frame.left;
        inputWindowHandle.frameTop = frame.top;
        inputWindowHandle.frameRight = frame.right;
        inputWindowHandle.frameBottom = frame.bottom;
        inputWindowHandle.scaleFactor = child.mGlobalScale != 1.0f ? 1.0f / child.mGlobalScale : 1.0f;
        this.addInputWindowHandle(inputWindowHandle);
        if (hasFocus) {
            this.mFocusedInputWindowHandle = inputWindowHandle;
        }
    }

    private void clearInputWindowHandlesLw() {
        while (this.mInputWindowHandleCount != 0) {
            this.mInputWindowHandles[--this.mInputWindowHandleCount] = null;
        }
        this.mFocusedInputWindowHandle = null;
    }

    void setUpdateInputWindowsNeededLw() {
        this.mUpdateInputWindowsNeeded = true;
    }

    void updateInputWindowsLw(boolean force) {
        boolean inPositioning;
        boolean inDrag;
        if (!force && !this.mUpdateInputWindowsNeeded) {
            return;
        }
        this.mUpdateInputWindowsNeeded = false;
        boolean bl = inDrag = this.mService.mDragState != null;
        if (inDrag) {
            InputWindowHandle dragWindowHandle = this.mService.mDragState.getInputWindowHandle();
            if (dragWindowHandle != null) {
                this.addInputWindowHandle(dragWindowHandle);
            } else {
                Slog.w("WindowManager", "Drag is in progress but there is no drag window handle.");
            }
        }
        boolean bl2 = inPositioning = this.mService.mTaskPositioner != null;
        if (inPositioning) {
            InputWindowHandle dragWindowHandle = this.mService.mTaskPositioner.mDragWindowHandle;
            if (dragWindowHandle != null) {
                this.addInputWindowHandle(dragWindowHandle);
            } else {
                Slog.e("WindowManager", "Repositioning is in progress but there is no drag window handle.");
            }
        }
        this.mUpdateInputForAllWindowsConsumer.updateInputWindows(inDrag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyConfigurationChanged() {
        this.mService.sendNewConfiguration(0);
        Object object = this.mInputDevicesReadyMonitor;
        synchronized (object) {
            if (!this.mInputDevicesReady) {
                this.mInputDevicesReady = true;
                this.mInputDevicesReadyMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForInputDevicesReady(long timeoutMillis) {
        Object object = this.mInputDevicesReadyMonitor;
        synchronized (object) {
            if (!this.mInputDevicesReady) {
                try {
                    this.mInputDevicesReadyMonitor.wait(timeoutMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.mInputDevicesReady;
        }
    }

    @Override
    public void notifyLidSwitchChanged(long whenNanos, boolean lidOpen) {
        this.mService.mPolicy.notifyLidSwitchChanged(whenNanos, lidOpen);
    }

    @Override
    public void notifyCameraLensCoverSwitchChanged(long whenNanos, boolean lensCovered) {
        this.mService.mPolicy.notifyCameraLensCoverSwitchChanged(whenNanos, lensCovered);
    }

    @Override
    public int interceptKeyBeforeQueueing(KeyEvent event, int policyFlags) {
        return this.mService.mPolicy.interceptKeyBeforeQueueing(event, policyFlags);
    }

    @Override
    public int interceptMotionBeforeQueueingNonInteractive(long whenNanos, int policyFlags) {
        return this.mService.mPolicy.interceptMotionBeforeQueueingNonInteractive(whenNanos, policyFlags);
    }

    @Override
    public long interceptKeyBeforeDispatching(InputWindowHandle focus, KeyEvent event, int policyFlags) {
        WindowState windowState = focus != null ? (WindowState)focus.windowState : null;
        return this.mService.mPolicy.interceptKeyBeforeDispatching(windowState, event, policyFlags);
    }

    @Override
    public KeyEvent dispatchUnhandledKey(InputWindowHandle focus, KeyEvent event, int policyFlags) {
        WindowState windowState = focus != null ? (WindowState)focus.windowState : null;
        return this.mService.mPolicy.dispatchUnhandledKey(windowState, event, policyFlags);
    }

    @Override
    public int getPointerLayer() {
        return this.mService.mPolicy.getWindowLayerFromTypeLw(2018) * 10000 + 1000;
    }

    public void setInputFocusLw(WindowState newWindow, boolean updateInputWindows) {
        if (newWindow != this.mInputFocus) {
            if (newWindow != null && newWindow.canReceiveKeys()) {
                newWindow.mToken.paused = false;
            }
            this.mInputFocus = newWindow;
            this.setUpdateInputWindowsNeededLw();
            if (updateInputWindows) {
                this.updateInputWindowsLw(false);
            }
        }
    }

    public void setFocusedAppLw(AppWindowToken newApp) {
        if (newApp == null) {
            this.mService.mInputManager.setFocusedApplication(null);
        } else {
            InputApplicationHandle handle = newApp.mInputApplicationHandle;
            handle.name = newApp.toString();
            handle.dispatchingTimeoutNanos = newApp.mInputDispatchingTimeoutNanos;
            this.mService.mInputManager.setFocusedApplication(handle);
        }
    }

    public void pauseDispatchingLw(WindowToken window) {
        if (!window.paused) {
            window.paused = true;
            this.updateInputWindowsLw(true);
        }
    }

    public void resumeDispatchingLw(WindowToken window) {
        if (window.paused) {
            window.paused = false;
            this.updateInputWindowsLw(true);
        }
    }

    public void freezeInputDispatchingLw() {
        if (!this.mInputDispatchFrozen) {
            this.mInputDispatchFrozen = true;
            this.mInputFreezeReason = Debug.getCallers(6);
            this.updateInputDispatchModeLw();
        }
    }

    public void thawInputDispatchingLw() {
        if (this.mInputDispatchFrozen) {
            this.mInputDispatchFrozen = false;
            this.mInputFreezeReason = null;
            this.updateInputDispatchModeLw();
        }
    }

    public void setEventDispatchingLw(boolean enabled) {
        if (this.mInputDispatchEnabled != enabled) {
            this.mInputDispatchEnabled = enabled;
            this.updateInputDispatchModeLw();
        }
    }

    private void updateInputDispatchModeLw() {
        this.mService.mInputManager.setInputDispatchMode(this.mInputDispatchEnabled, this.mInputDispatchFrozen);
    }

    void dump(PrintWriter pw, String prefix) {
        Set<String> inputConsumerKeys;
        if (this.mInputFreezeReason != null) {
            pw.println(prefix + "mInputFreezeReason=" + this.mInputFreezeReason);
        }
        if (!(inputConsumerKeys = this.mInputConsumers.keySet()).isEmpty()) {
            pw.println(prefix + "InputConsumers:");
            for (String key : inputConsumerKeys) {
                pw.println(prefix + "  name=" + key);
            }
        }
    }

    private final class UpdateInputForAllWindowsConsumer
    implements Consumer<WindowState> {
        InputConsumerImpl navInputConsumer;
        InputConsumerImpl pipInputConsumer;
        InputConsumerImpl wallpaperInputConsumer;
        Rect pipTouchableBounds;
        boolean inDrag;
        WallpaperController wallpaperController;

        private UpdateInputForAllWindowsConsumer() {
        }

        private void updateInputWindows(boolean inDrag) {
            this.navInputConsumer = InputMonitor.this.getInputConsumer("nav_input_consumer", 0);
            this.pipInputConsumer = InputMonitor.this.getInputConsumer("pip_input_consumer", 0);
            this.wallpaperInputConsumer = InputMonitor.this.getInputConsumer("wallpaper_input_consumer", 0);
            InputMonitor.this.mAddInputConsumerHandle = this.navInputConsumer != null;
            InputMonitor.this.mAddPipInputConsumerHandle = this.pipInputConsumer != null;
            InputMonitor.this.mAddWallpaperInputConsumerHandle = this.wallpaperInputConsumer != null;
            InputMonitor.this.mTmpRect.setEmpty();
            this.pipTouchableBounds = InputMonitor.this.mAddPipInputConsumerHandle ? InputMonitor.this.mTmpRect : null;
            InputMonitor.this.mDisableWallpaperTouchEvents = false;
            this.inDrag = inDrag;
            this.wallpaperController = ((InputMonitor)InputMonitor.this).mService.mRoot.mWallpaperController;
            ((InputMonitor)InputMonitor.this).mService.mRoot.forAllWindows(this, true);
            if (InputMonitor.this.mAddWallpaperInputConsumerHandle) {
                InputMonitor.this.addInputWindowHandle(this.wallpaperInputConsumer.mWindowHandle);
            }
            ((InputMonitor)InputMonitor.this).mService.mInputManager.setInputWindows(InputMonitor.this.mInputWindowHandles, InputMonitor.this.mFocusedInputWindowHandle);
            InputMonitor.this.clearInputWindowHandlesLw();
        }

        @Override
        public void accept(WindowState w) {
            boolean hasWallpaper;
            InputChannel inputChannel = w.mInputChannel;
            InputWindowHandle inputWindowHandle = w.mInputWindowHandle;
            if (inputChannel == null || inputWindowHandle == null || w.mRemoved || w.canReceiveTouchInput()) {
                return;
            }
            int flags = w.mAttrs.flags;
            int privateFlags = w.mAttrs.privateFlags;
            int type = w.mAttrs.type;
            boolean hasFocus = w == InputMonitor.this.mInputFocus;
            boolean isVisible = w.isVisibleLw();
            if (w.getStackId() == 4) {
                if (InputMonitor.this.mAddPipInputConsumerHandle && inputWindowHandle.layer <= this.pipInputConsumer.mWindowHandle.layer) {
                    w.getStack().getBounds(this.pipTouchableBounds);
                    this.pipInputConsumer.mWindowHandle.touchableRegion.set(this.pipTouchableBounds);
                    InputMonitor.this.addInputWindowHandle(this.pipInputConsumer.mWindowHandle);
                    InputMonitor.this.mAddPipInputConsumerHandle = false;
                }
                if (!hasFocus) {
                    return;
                }
            }
            if (InputMonitor.this.mAddInputConsumerHandle && inputWindowHandle.layer <= this.navInputConsumer.mWindowHandle.layer) {
                InputMonitor.this.addInputWindowHandle(this.navInputConsumer.mWindowHandle);
                InputMonitor.this.mAddInputConsumerHandle = false;
            }
            if (InputMonitor.this.mAddWallpaperInputConsumerHandle && w.mAttrs.type == 2013 && w.isVisibleLw()) {
                InputMonitor.this.addInputWindowHandle(this.wallpaperInputConsumer.mWindowHandle);
                InputMonitor.this.mAddWallpaperInputConsumerHandle = false;
            }
            if ((privateFlags & 0x800) != 0) {
                InputMonitor.this.mDisableWallpaperTouchEvents = true;
            }
            boolean bl = hasWallpaper = this.wallpaperController.isWallpaperTarget(w) && (privateFlags & 0x400) == 0 && !InputMonitor.this.mDisableWallpaperTouchEvents;
            if (this.inDrag && isVisible && w.getDisplayContent().isDefaultDisplay) {
                ((InputMonitor)InputMonitor.this).mService.mDragState.sendDragStartedIfNeededLw(w);
            }
            InputMonitor.this.addInputWindowHandle(inputWindowHandle, w, flags, type, isVisible, hasFocus, hasWallpaper);
        }
    }

    private static final class EventReceiverInputConsumer
    extends InputConsumerImpl
    implements WindowManagerPolicy.InputConsumer {
        private InputMonitor mInputMonitor;
        private final InputEventReceiver mInputEventReceiver;

        EventReceiverInputConsumer(WindowManagerService service, InputMonitor monitor, Looper looper, String name, InputEventReceiver.Factory inputEventReceiverFactory) {
            super(service, name, null);
            this.mInputMonitor = monitor;
            this.mInputEventReceiver = inputEventReceiverFactory.createInputEventReceiver(this.mClientChannel, looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dismiss() {
            WindowHashMap windowHashMap = this.mService.mWindowMap;
            synchronized (windowHashMap) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    if (this.mInputMonitor.destroyInputConsumer(this.mWindowHandle.name)) {
                        this.mInputEventReceiver.dispose();
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
        }
    }
}

