/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.ActivityManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Slog;
import android.view.IApplicationToken;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.internal.util.ToBooleanFunction;
import com.android.server.input.InputApplicationHandle;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.StartingData;
import com.android.server.wm.Task;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowContainerController;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;

class AppWindowToken
extends WindowToken
implements WindowManagerService.AppFreezeListener {
    private static final String TAG = "WindowManager";
    final IApplicationToken appToken;
    final AppWindowAnimator mAppAnimator;
    final boolean mVoiceInteraction;
    private boolean mFillsParent;
    boolean layoutConfigChanges;
    boolean mShowForAllUsers;
    int mTargetSdk;
    private boolean mReparenting;
    private boolean mRemovingFromDisplay = false;
    long mInputDispatchingTimeoutNanos;
    private long mLastTransactionSequence = Long.MIN_VALUE;
    private int mNumInterestingWindows;
    private int mNumDrawnWindows;
    boolean inPendingTransaction;
    boolean allDrawn;
    boolean deferClearAllDrawn;
    boolean allDrawnExcludingSaved;
    private int mNumInterestingWindowsExcludingSaved;
    private int mNumDrawnWindowsExcludingSaved;
    boolean hiddenRequested;
    private boolean mClientHidden;
    boolean mDeferHidingClient;
    boolean reportedVisible;
    private boolean reportedDrawn;
    boolean removed;
    StartingData startingData;
    WindowState startingWindow;
    WindowManagerPolicy.StartingSurface startingSurface;
    boolean startingDisplayed;
    boolean startingMoved;
    private boolean mHiddenSetFromTransferredStartingWindow;
    boolean firstWindowDrawn;
    private final WindowState.UpdateReportedVisibilityResults mReportedVisibilityResults = new WindowState.UpdateReportedVisibilityResults();
    final InputApplicationHandle mInputApplicationHandle;
    boolean mIsExiting;
    boolean mLaunchTaskBehind;
    boolean mEnteringAnimation;
    private boolean mAlwaysFocusable;
    boolean mAppStopped;
    int mRotationAnimationHint;
    private int mPendingRelaunchCount;
    private boolean mLastContainsShowWhenLockedWindow;
    private boolean mLastContainsDismissKeyguardWindow;
    private final Rect mBounds = new Rect();
    ArrayDeque<Rect> mFrozenBounds = new ArrayDeque();
    ArrayDeque<Configuration> mFrozenMergedConfig = new ArrayDeque();
    private boolean mDisablePreviewScreenshots;
    Task mLastParent;
    private boolean mCanTurnScreenOn = true;

    AppWindowToken(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, long inputDispatchingTimeoutNanos, boolean fullscreen, boolean showForAllUsers, int targetSdk, int orientation, int rotationAnimationHint, int configChanges, boolean launchTaskBehind, boolean alwaysFocusable, AppWindowContainerController controller, Configuration overrideConfig, Rect bounds) {
        this(service, token, voiceInteraction, dc, fullscreen, overrideConfig, bounds);
        this.setController(controller);
        this.mInputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
        this.mShowForAllUsers = showForAllUsers;
        this.mTargetSdk = targetSdk;
        this.mOrientation = orientation;
        this.layoutConfigChanges = (configChanges & 0x480) != 0;
        this.mLaunchTaskBehind = launchTaskBehind;
        this.mAlwaysFocusable = alwaysFocusable;
        this.mRotationAnimationHint = rotationAnimationHint;
        this.hidden = true;
        this.hiddenRequested = true;
    }

    AppWindowToken(WindowManagerService service, IApplicationToken token, boolean voiceInteraction, DisplayContent dc, boolean fillsParent, Configuration overrideConfig, Rect bounds) {
        super(service, token != null ? token.asBinder() : null, 2, true, dc, false);
        this.appToken = token;
        this.mVoiceInteraction = voiceInteraction;
        this.mFillsParent = fillsParent;
        this.mInputApplicationHandle = new InputApplicationHandle(this);
        this.mAppAnimator = new AppWindowAnimator(this, service);
        if (overrideConfig != null) {
            this.onOverrideConfigurationChanged(overrideConfig);
        }
        if (bounds != null) {
            this.mBounds.set(bounds);
        }
    }

    void onOverrideConfigurationChanged(Configuration overrideConfiguration, Rect bounds) {
        this.onOverrideConfigurationChanged(overrideConfiguration);
        if (this.mBounds.equals(bounds)) {
            return;
        }
        this.mBounds.set(bounds);
        this.onResize();
    }

    void getBounds(Rect outBounds) {
        outBounds.set(this.mBounds);
    }

    boolean hasBounds() {
        return !this.mBounds.isEmpty();
    }

    void onFirstWindowDrawn(WindowState win, WindowStateAnimator winAnimator) {
        this.firstWindowDrawn = true;
        this.removeDeadWindows();
        if (this.startingWindow != null) {
            winAnimator.clearAnimation();
            if (this.getController() != null) {
                this.getController().removeStartingWindow();
            }
        }
        this.updateReportedVisibilityLocked();
    }

    void updateReportedVisibilityLocked() {
        boolean nowVisible;
        if (this.appToken == null) {
            return;
        }
        int count = this.mChildren.size();
        this.mReportedVisibilityResults.reset();
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.updateReportedVisibility(this.mReportedVisibilityResults);
        }
        int numInteresting = this.mReportedVisibilityResults.numInteresting;
        int numVisible = this.mReportedVisibilityResults.numVisible;
        int numDrawn = this.mReportedVisibilityResults.numDrawn;
        boolean nowGone = this.mReportedVisibilityResults.nowGone;
        boolean nowDrawn = numInteresting > 0 && numDrawn >= numInteresting;
        boolean bl = nowVisible = numInteresting > 0 && numVisible >= numInteresting && !this.hidden;
        if (!nowGone) {
            if (!nowDrawn) {
                nowDrawn = this.reportedDrawn;
            }
            if (!nowVisible) {
                nowVisible = this.reportedVisible;
            }
        }
        AppWindowContainerController controller = this.getController();
        if (nowDrawn != this.reportedDrawn) {
            if (nowDrawn && controller != null) {
                controller.reportWindowsDrawn();
            }
            this.reportedDrawn = nowDrawn;
        }
        if (nowVisible != this.reportedVisible) {
            this.reportedVisible = nowVisible;
            if (controller != null) {
                if (nowVisible) {
                    controller.reportWindowsVisible();
                } else {
                    controller.reportWindowsGone();
                }
            }
        }
    }

    boolean isClientHidden() {
        return this.mClientHidden;
    }

    void setClientHidden(boolean hideClient) {
        if (this.mClientHidden == hideClient || hideClient && this.mDeferHidingClient) {
            return;
        }
        this.mClientHidden = hideClient;
        this.sendAppVisibilityToClients();
    }

    boolean setVisibility(WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout, boolean isVoiceInteraction) {
        int i;
        boolean delayed = false;
        this.inPendingTransaction = false;
        this.mHiddenSetFromTransferredStartingWindow = false;
        this.setClientHidden(!visible);
        boolean visibilityChanged = false;
        if (this.hidden == visible || this.hidden && this.mIsExiting || visible && this.waitingForReplacement()) {
            AccessibilityController accessibilityController = this.mService.mAccessibilityController;
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (this.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                this.mAppAnimator.setNullAnimation();
            }
            if (transit != -1) {
                WindowState window;
                if (this.mService.applyAnimationLocked(this, lp, transit, visible, isVoiceInteraction)) {
                    runningAppAnimation = true;
                    delayed = true;
                }
                if ((window = this.findMainWindow()) != null && accessibilityController != null && this.getDisplayContent().getDisplayId() == 0) {
                    accessibilityController.onAppWindowTransitionLocked(window, transit);
                }
                changed = true;
            }
            int windowsCount = this.mChildren.size();
            for (int i2 = 0; i2 < windowsCount; ++i2) {
                WindowState win = (WindowState)this.mChildren.get(i2);
                changed |= win.onAppVisibilityChanged(visible, runningAppAnimation);
            }
            this.hiddenRequested = !visible;
            this.hidden = this.hiddenRequested;
            visibilityChanged = true;
            if (!visible) {
                this.stopFreezingScreen(true, true);
            } else {
                if (this.startingWindow != null && !this.startingWindow.isDrawnLw()) {
                    this.startingWindow.mPolicyVisibility = false;
                    this.startingWindow.mPolicyVisibilityAfterAnim = false;
                }
                this.forAllWindows(this.mService::makeWindowFreezingScreenIfNeededLocked, true);
            }
            if (changed) {
                this.mService.mInputMonitor.setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.mService.updateFocusedWindowLocked(3, false);
                    this.mService.mWindowPlacerLocked.performSurfacePlacement();
                }
                this.mService.mInputMonitor.updateInputWindowsLw(false);
            }
        }
        if (this.mAppAnimator.animation != null) {
            delayed = true;
        }
        for (i = this.mChildren.size() - 1; i >= 0 && !delayed; --i) {
            if (!((WindowState)this.mChildren.get(i)).isWindowAnimationSet()) continue;
            delayed = true;
        }
        if (visibilityChanged) {
            if (visible && !delayed) {
                this.mEnteringAnimation = true;
                this.mService.mActivityManagerAppTransitionNotifier.onAppTransitionFinishedLocked(this.token);
            }
            if (this.hidden && !delayed && !this.mService.mAppTransition.isTransitionSet()) {
                SurfaceControl.openTransaction();
                for (i = this.mChildren.size() - 1; i >= 0; --i) {
                    ((WindowState)this.mChildren.get((int)i)).mWinAnimator.hide("immediately hidden");
                }
                SurfaceControl.closeTransaction();
            }
            if (!this.mService.mClosingApps.contains(this) && !this.mService.mOpeningApps.contains(this)) {
                this.mService.getDefaultDisplayContentLocked().getDockedDividerController().notifyAppVisibilityChanged();
                this.mService.mTaskSnapshotController.notifyAppVisibilityChanged(this, visible);
            }
        }
        return delayed;
    }

    WindowState getTopFullscreenWindow() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (win == null || !win.mAttrs.isFullscreen()) continue;
            return win;
        }
        return null;
    }

    WindowState findMainWindow() {
        WindowState candidate = null;
        int j = this.mChildren.size();
        while (j > 0) {
            WindowState win = (WindowState)this.mChildren.get(--j);
            int type = win.mAttrs.type;
            if (type != 1 && type != 3) continue;
            if (win.mAnimatingExit) {
                candidate = win;
                continue;
            }
            return win;
        }
        return candidate;
    }

    boolean windowsAreFocusable() {
        return ActivityManager.StackId.canReceiveKeys(this.getTask().mStack.mStackId) || this.mAlwaysFocusable;
    }

    @Override
    AppWindowContainerController getController() {
        WindowContainerController controller = super.getController();
        return controller != null ? (AppWindowContainerController)controller : null;
    }

    @Override
    boolean isVisible() {
        return !this.hidden;
    }

    @Override
    void removeImmediately() {
        this.onRemovedFromDisplay();
        super.removeImmediately();
    }

    @Override
    void removeIfPossible() {
        this.mIsExiting = false;
        this.removeAllWindowsIfPossible();
        this.removeImmediately();
    }

    @Override
    boolean checkCompleteDeferredRemoval() {
        if (this.mIsExiting) {
            this.removeIfPossible();
        }
        return super.checkCompleteDeferredRemoval();
    }

    void onRemovedFromDisplay() {
        if (this.mRemovingFromDisplay) {
            return;
        }
        this.mRemovingFromDisplay = true;
        boolean delayed = this.setVisibility(null, false, -1, true, this.mVoiceInteraction);
        this.mService.mOpeningApps.remove(this);
        this.mService.mUnknownAppVisibilityController.appRemovedOrHidden(this);
        this.mService.mTaskSnapshotController.onAppRemoved(this);
        this.waitingToShow = false;
        if (this.mService.mClosingApps.contains(this)) {
            delayed = true;
        } else if (this.mService.mAppTransition.isTransitionSet()) {
            this.mService.mClosingApps.add(this);
            delayed = true;
        }
        if (this.startingData != null && this.getController() != null) {
            this.getController().removeStartingWindow();
        }
        if (this.mAppAnimator.animating) {
            this.mService.mNoAnimationNotifyOnTransitionFinished.add(this.token);
        }
        TaskStack stack = this.getStack();
        if (delayed && !this.isEmpty()) {
            if (stack != null) {
                stack.mExitingAppTokens.add(this);
            }
            this.mIsExiting = true;
        } else {
            this.mAppAnimator.clearAnimation();
            this.mAppAnimator.animating = false;
            if (stack != null) {
                stack.mExitingAppTokens.remove(this);
            }
            this.removeIfPossible();
        }
        this.removed = true;
        this.stopFreezingScreen(true, true);
        if (this.mService.mFocusedApp == this) {
            this.mService.mFocusedApp = null;
            this.mService.updateFocusedWindowLocked(0, true);
            this.mService.mInputMonitor.setFocusedAppLw(null);
        }
        if (!delayed) {
            this.updateReportedVisibilityLocked();
        }
        this.mRemovingFromDisplay = false;
    }

    void clearAnimatingFlags() {
        boolean wallpaperMightChange = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            wallpaperMightChange |= win.clearAnimatingFlags();
        }
        if (wallpaperMightChange) {
            this.requestUpdateWallpaperIfNeeded();
        }
    }

    void destroySurfaces() {
        this.destroySurfaces(false);
    }

    private void destroySurfaces(boolean cleanupOnResume) {
        boolean destroyedSomething = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            destroyedSomething |= win.destroySurface(cleanupOnResume, this.mAppStopped);
        }
        if (destroyedSomething) {
            DisplayContent dc = this.getDisplayContent();
            dc.assignWindowLayers(true);
        }
    }

    void notifyAppResumed(boolean wasStopped) {
        this.mAppStopped = false;
        this.setCanTurnScreenOn(true);
        if (!wasStopped) {
            this.destroySurfaces(true);
        }
    }

    void notifyAppStopped() {
        this.mAppStopped = true;
        this.destroySurfaces();
        if (this.getController() != null) {
            this.getController().removeStartingWindow();
        }
    }

    boolean shouldSaveSurface() {
        return this.allDrawn;
    }

    private boolean canRestoreSurfaces() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (!w.canRestoreSurface()) continue;
            return true;
        }
        return false;
    }

    private void clearWasVisibleBeforeClientHidden() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.clearWasVisibleBeforeClientHidden();
        }
    }

    boolean isAnimatingInvisibleWithSavedSurface() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (!w.isAnimatingInvisibleWithSavedSurface()) continue;
            return true;
        }
        return false;
    }

    void stopUsingSavedSurfaceLocked() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.stopUsingSavedSurface();
        }
        this.destroySurfaces();
    }

    void markSavedSurfaceExiting() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.markSavedSurfaceExiting();
        }
    }

    void restoreSavedSurfaceForInterestingWindows() {
        if (!this.canRestoreSurfaces()) {
            this.clearWasVisibleBeforeClientHidden();
            return;
        }
        int interestingNotDrawn = -1;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            interestingNotDrawn = w.restoreSavedSurfaceForInterestingWindow();
        }
        if (!this.allDrawn) {
            boolean bl = this.allDrawn = interestingNotDrawn == 0;
            if (this.allDrawn) {
                this.mService.mH.obtainMessage(32, this.token).sendToTarget();
            }
        }
        this.clearWasVisibleBeforeClientHidden();
    }

    void destroySavedSurfaces() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.destroySavedSurface();
        }
    }

    void clearAllDrawn() {
        this.allDrawn = false;
        this.deferClearAllDrawn = false;
        this.allDrawnExcludingSaved = false;
    }

    Task getTask() {
        return (Task)this.getParent();
    }

    TaskStack getStack() {
        Task task = this.getTask();
        if (task != null) {
            return task.mStack;
        }
        return null;
    }

    @Override
    void onParentSet() {
        super.onParentSet();
        Task task = this.getTask();
        if (!this.mReparenting) {
            if (task == null) {
                this.mService.mClosingApps.remove(this);
            } else if (this.mLastParent != null && this.mLastParent.mStack != null) {
                task.mStack.mExitingAppTokens.remove(this);
            }
        }
        this.mLastParent = task;
    }

    void postWindowRemoveStartingWindowCleanup(WindowState win) {
        if (this.startingWindow == win) {
            if (this.getController() != null) {
                this.getController().removeStartingWindow();
            }
        } else if (this.mChildren.size() == 0) {
            this.startingData = null;
            if (this.mHiddenSetFromTransferredStartingWindow) {
                this.hidden = true;
            }
        } else if (this.mChildren.size() == 1 && this.startingSurface != null && !this.isRelaunching() && this.getController() != null) {
            this.getController().removeStartingWindow();
        }
    }

    void removeDeadWindows() {
        for (int winNdx = this.mChildren.size() - 1; winNdx >= 0; --winNdx) {
            WindowState win = (WindowState)this.mChildren.get(winNdx);
            if (!win.mAppDied) continue;
            win.mDestroying = true;
            win.removeIfPossible();
        }
    }

    boolean hasWindowsAlive() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if (((WindowState)this.mChildren.get((int)i)).mAppDied) continue;
            return true;
        }
        return false;
    }

    void setWillReplaceWindows(boolean animate) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.setWillReplaceWindow(animate);
        }
        if (animate) {
            this.mAppAnimator.setDummyAnimation();
        }
    }

    void setWillReplaceChildWindows() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.setWillReplaceChildWindows();
        }
    }

    void clearWillReplaceWindows() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.clearWillReplaceWindow();
        }
    }

    void requestUpdateWallpaperIfNeeded() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.requestUpdateWallpaperIfNeeded();
        }
    }

    boolean isRelaunching() {
        return this.mPendingRelaunchCount > 0;
    }

    boolean shouldFreezeBounds() {
        Task task = this.getTask();
        if (task == null || task.inFreeformWorkspace()) {
            return false;
        }
        return this.getTask().isDragResizing();
    }

    void startRelaunching() {
        if (this.shouldFreezeBounds()) {
            this.freezeBounds();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            w.mWinAnimator.detachChildren();
        }
        ++this.mPendingRelaunchCount;
    }

    void finishRelaunching() {
        this.unfreezeBounds();
        if (this.mPendingRelaunchCount > 0) {
            --this.mPendingRelaunchCount;
        } else {
            this.checkKeyguardFlagsChanged();
        }
    }

    void clearRelaunching() {
        if (this.mPendingRelaunchCount == 0) {
            return;
        }
        this.unfreezeBounds();
        this.mPendingRelaunchCount = 0;
    }

    @Override
    protected boolean isFirstChildWindowGreaterThanSecond(WindowState newWindow, WindowState existingWindow) {
        int type1 = newWindow.mAttrs.type;
        int type2 = existingWindow.mAttrs.type;
        if (type1 == 1 && type2 != 1) {
            return false;
        }
        if (type1 != 1 && type2 == 1) {
            return true;
        }
        if (type1 == 3 && type2 != 3) {
            return true;
        }
        return type1 == 3 || type2 != 3;
    }

    @Override
    void addWindow(WindowState w) {
        super.addWindow(w);
        boolean gotReplacementWindow = false;
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.mChildren.get(i);
            gotReplacementWindow |= candidate.setReplacementWindowIfNeeded(w);
        }
        if (gotReplacementWindow) {
            this.mService.scheduleWindowReplacementTimeouts(this);
        }
        this.checkKeyguardFlagsChanged();
    }

    @Override
    void removeChild(WindowState child) {
        super.removeChild(child);
        this.checkKeyguardFlagsChanged();
    }

    private boolean waitingForReplacement() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState candidate = (WindowState)this.mChildren.get(i);
            if (!candidate.waitingForReplacement()) continue;
            return true;
        }
        return false;
    }

    void onWindowReplacementTimeout() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            ((WindowState)this.mChildren.get(i)).onWindowReplacementTimeout();
        }
    }

    void reparent(Task task, int position) {
        Task currentTask = this.getTask();
        if (task == currentTask) {
            throw new IllegalArgumentException("window token=" + this + " already child of task=" + currentTask);
        }
        if (currentTask.mStack != task.mStack) {
            throw new IllegalArgumentException("window token=" + this + " current task=" + currentTask + " belongs to a different stack than " + task);
        }
        DisplayContent prevDisplayContent = this.getDisplayContent();
        this.mReparenting = true;
        this.getParent().removeChild(this);
        task.addChild(this, position);
        this.mReparenting = false;
        DisplayContent displayContent = task.getDisplayContent();
        displayContent.setLayoutNeeded();
        if (prevDisplayContent != displayContent) {
            this.onDisplayChanged(displayContent);
            prevDisplayContent.setLayoutNeeded();
        }
    }

    private void freezeBounds() {
        Task task = this.getTask();
        this.mFrozenBounds.offer(new Rect(task.mPreparedFrozenBounds));
        if (task.mPreparedFrozenMergedConfig.equals(Configuration.EMPTY)) {
            this.mFrozenMergedConfig.offer(new Configuration(task.getConfiguration()));
        } else {
            this.mFrozenMergedConfig.offer(new Configuration(task.mPreparedFrozenMergedConfig));
        }
        task.mPreparedFrozenMergedConfig.unset();
    }

    private void unfreezeBounds() {
        if (this.mFrozenBounds.isEmpty()) {
            return;
        }
        this.mFrozenBounds.remove();
        if (!this.mFrozenMergedConfig.isEmpty()) {
            this.mFrozenMergedConfig.remove();
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            win.onUnfreezeBounds();
        }
        this.mService.mWindowPlacerLocked.performSurfacePlacement();
    }

    void setAppLayoutChanges(int changes, String reason) {
        if (!this.mChildren.isEmpty()) {
            DisplayContent dc = this.getDisplayContent();
            dc.pendingLayoutChanges |= changes;
        }
    }

    void removeReplacedWindowIfNeeded(WindowState replacement) {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)this.mChildren.get(i);
            if (!win.removeReplacedWindowIfNeeded(replacement)) continue;
            return;
        }
    }

    void startFreezingScreen() {
        if (!this.hiddenRequested) {
            if (!this.mAppAnimator.freezingScreen) {
                this.mAppAnimator.freezingScreen = true;
                this.mService.registerAppFreezeListener(this);
                this.mAppAnimator.lastFreezeDuration = 0;
                ++this.mService.mAppsFreezingScreen;
                if (this.mService.mAppsFreezingScreen == 1) {
                    this.mService.startFreezingDisplayLocked(false, 0, 0, this.getDisplayContent());
                    this.mService.mH.removeMessages(17);
                    this.mService.mH.sendEmptyMessageDelayed(17, 2000L);
                }
            }
            int count = this.mChildren.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)this.mChildren.get(i);
                w.onStartFreezingScreen();
            }
        }
    }

    void stopFreezingScreen(boolean unfreezeSurfaceNow, boolean force) {
        if (!this.mAppAnimator.freezingScreen) {
            return;
        }
        int count = this.mChildren.size();
        boolean unfrozeWindows = false;
        for (int i = 0; i < count; ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            unfrozeWindows |= w.onStopFreezingScreen();
        }
        if (force || unfrozeWindows) {
            this.mAppAnimator.freezingScreen = false;
            this.mService.unregisterAppFreezeListener(this);
            this.mAppAnimator.lastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mService.mDisplayFreezeTime);
            --this.mService.mAppsFreezingScreen;
            this.mService.mLastFinishedFreezeSource = this;
        }
        if (unfreezeSurfaceNow) {
            if (unfrozeWindows) {
                this.mService.mWindowPlacerLocked.performSurfacePlacement();
            }
            this.mService.stopFreezingDisplayLocked();
        }
    }

    @Override
    public void onAppFreezeTimeout() {
        Slog.w(TAG, "Force clearing freeze: " + this);
        this.stopFreezingScreen(true, true);
    }

    boolean transferStartingWindow(IBinder transferFrom) {
        AppWindowToken fromToken = this.getDisplayContent().getAppWindowToken(transferFrom);
        if (fromToken == null) {
            return false;
        }
        WindowState tStartingWindow = fromToken.startingWindow;
        if (tStartingWindow != null && fromToken.startingSurface != null) {
            this.mService.mSkipAppTransitionAnimation = true;
            long origId = Binder.clearCallingIdentity();
            this.startingData = fromToken.startingData;
            this.startingSurface = fromToken.startingSurface;
            this.startingDisplayed = fromToken.startingDisplayed;
            fromToken.startingDisplayed = false;
            this.startingWindow = tStartingWindow;
            this.reportedVisible = fromToken.reportedVisible;
            fromToken.startingData = null;
            fromToken.startingSurface = null;
            fromToken.startingWindow = null;
            fromToken.startingMoved = true;
            tStartingWindow.mToken = this;
            tStartingWindow.mAppToken = this;
            fromToken.removeChild(tStartingWindow);
            fromToken.postWindowRemoveStartingWindowCleanup(tStartingWindow);
            fromToken.mHiddenSetFromTransferredStartingWindow = false;
            this.addWindow(tStartingWindow);
            if (fromToken.allDrawn) {
                this.allDrawn = true;
                this.deferClearAllDrawn = fromToken.deferClearAllDrawn;
            }
            if (fromToken.firstWindowDrawn) {
                this.firstWindowDrawn = true;
            }
            if (!fromToken.hidden) {
                this.hidden = false;
                this.hiddenRequested = false;
                this.mHiddenSetFromTransferredStartingWindow = true;
            }
            this.setClientHidden(fromToken.mClientHidden);
            fromToken.mAppAnimator.transferCurrentAnimation(this.mAppAnimator, tStartingWindow.mWinAnimator);
            this.mService.updateFocusedWindowLocked(3, true);
            this.getDisplayContent().setLayoutNeeded();
            this.mService.mWindowPlacerLocked.performSurfacePlacement();
            Binder.restoreCallingIdentity(origId);
            return true;
        }
        if (fromToken.startingData != null) {
            this.startingData = fromToken.startingData;
            fromToken.startingData = null;
            fromToken.startingMoved = true;
            if (this.getController() != null) {
                this.getController().scheduleAddStartingWindow();
            }
            return true;
        }
        AppWindowAnimator tAppAnimator = fromToken.mAppAnimator;
        AppWindowAnimator wAppAnimator = this.mAppAnimator;
        if (tAppAnimator.thumbnail != null) {
            if (wAppAnimator.thumbnail != null) {
                wAppAnimator.thumbnail.destroy();
            }
            wAppAnimator.thumbnail = tAppAnimator.thumbnail;
            wAppAnimator.thumbnailLayer = tAppAnimator.thumbnailLayer;
            wAppAnimator.thumbnailAnimation = tAppAnimator.thumbnailAnimation;
            tAppAnimator.thumbnail = null;
        }
        return false;
    }

    boolean isLastWindow(WindowState win) {
        return this.mChildren.size() == 1 && this.mChildren.get(0) == win;
    }

    void setAllAppWinAnimators() {
        ArrayList<WindowStateAnimator> allAppWinAnimators = this.mAppAnimator.mAllAppWinAnimators;
        allAppWinAnimators.clear();
        int windowsCount = this.mChildren.size();
        for (int j = 0; j < windowsCount; ++j) {
            ((WindowState)this.mChildren.get(j)).addWinAnimatorToList(allAppWinAnimators);
        }
    }

    @Override
    void onAppTransitionDone() {
        this.sendingToBottom = false;
    }

    @Override
    int getOrientation(int candidate) {
        if (!this.fillsParent() && this.mTargetSdk >= 27) {
            return -2;
        }
        if (candidate == 3) {
            return this.mOrientation;
        }
        if (!this.sendingToBottom && !this.mService.mClosingApps.contains(this) && (this.isVisible() || this.mService.mOpeningApps.contains(this) || this.isOnTop())) {
            return this.mOrientation;
        }
        return -2;
    }

    int getOrientationIgnoreVisibility() {
        return this.mOrientation;
    }

    @Override
    void checkAppWindowsReadyToShow() {
        if (this.allDrawn == this.mAppAnimator.allDrawn) {
            return;
        }
        this.mAppAnimator.allDrawn = this.allDrawn;
        if (!this.allDrawn) {
            return;
        }
        if (this.mAppAnimator.freezingScreen) {
            this.mAppAnimator.showAllWindowsLocked();
            this.stopFreezingScreen(false, true);
            this.setAppLayoutChanges(4, "checkAppWindowsReadyToShow: freezingScreen");
        } else {
            this.setAppLayoutChanges(8, "checkAppWindowsReadyToShow");
            if (!this.mService.mOpeningApps.contains(this)) {
                this.mService.mAnimator.orAnimating(this.mAppAnimator.showAllWindowsLocked());
            }
        }
    }

    private boolean allDrawnStatesConsidered() {
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            WindowState child = (WindowState)this.mChildren.get(i);
            if (!child.mightAffectAllDrawn(false) || child.getDrawnStateEvaluated()) continue;
            return false;
        }
        return true;
    }

    void updateAllDrawn() {
        int numInteresting;
        if (!this.allDrawn && (numInteresting = this.mNumInterestingWindows) > 0 && this.allDrawnStatesConsidered() && this.mNumDrawnWindows >= numInteresting && !this.isRelaunching()) {
            this.allDrawn = true;
            if (this.mDisplayContent != null) {
                this.mDisplayContent.setLayoutNeeded();
            }
            this.mService.mH.obtainMessage(32, this.token).sendToTarget();
            TaskStack pinnedStack = this.mDisplayContent.getStackById(4);
            if (pinnedStack != null) {
                pinnedStack.onAllWindowsDrawn();
            }
        }
        if (!this.allDrawnExcludingSaved && (numInteresting = this.mNumInterestingWindowsExcludingSaved) > 0 && this.mNumDrawnWindowsExcludingSaved >= numInteresting) {
            this.allDrawnExcludingSaved = true;
            if (this.mDisplayContent != null) {
                this.mDisplayContent.setLayoutNeeded();
            }
            if (this.isAnimatingInvisibleWithSavedSurface() && !this.mService.mFinishedEarlyAnim.contains(this)) {
                this.mService.mFinishedEarlyAnim.add(this);
            }
        }
    }

    boolean updateDrawnWindowStates(WindowState w) {
        w.setDrawnStateEvaluated(true);
        if (this.allDrawn && this.allDrawnExcludingSaved && !this.mAppAnimator.freezingScreen) {
            return false;
        }
        if (this.mLastTransactionSequence != (long)this.mService.mTransactionSequence) {
            this.mLastTransactionSequence = this.mService.mTransactionSequence;
            this.mNumDrawnWindows = 0;
            this.mNumInterestingWindows = 0;
            this.mNumInterestingWindowsExcludingSaved = 0;
            this.mNumDrawnWindowsExcludingSaved = 0;
            this.startingDisplayed = false;
        }
        WindowStateAnimator winAnimator = w.mWinAnimator;
        boolean isInterestingAndDrawn = false;
        if (!this.allDrawn && w.mightAffectAllDrawn(false)) {
            if (w != this.startingWindow) {
                if (w.isInteresting()) {
                    ++this.mNumInterestingWindows;
                    if (w.isDrawnLw()) {
                        ++this.mNumDrawnWindows;
                        isInterestingAndDrawn = true;
                    }
                }
            } else if (w.isDrawnLw()) {
                if (this.getController() != null) {
                    this.getController().reportStartingWindowDrawn();
                }
                this.startingDisplayed = true;
            }
        }
        if (!this.allDrawnExcludingSaved && w.mightAffectAllDrawn(true) && w != this.startingWindow && w.isInteresting()) {
            ++this.mNumInterestingWindowsExcludingSaved;
            if (w.isDrawnLw() && !w.isAnimatingWithSavedSurface()) {
                ++this.mNumDrawnWindowsExcludingSaved;
                isInterestingAndDrawn = true;
            }
        }
        return isInterestingAndDrawn;
    }

    @Override
    void stepAppWindowsAnimation(long currentTime) {
        this.mAppAnimator.wasAnimating = this.mAppAnimator.animating;
        if (this.mAppAnimator.stepAnimationLocked(currentTime)) {
            this.mAppAnimator.animating = true;
            this.mService.mAnimator.setAnimating(true);
            this.mService.mAnimator.mAppWindowAnimating = true;
        } else if (this.mAppAnimator.wasAnimating) {
            this.setAppLayoutChanges(4, null);
        }
    }

    @Override
    boolean forAllWindows(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        if (this.mIsExiting && !this.waitingForReplacement()) {
            return false;
        }
        return this.forAllWindowsUnchecked(callback, traverseTopToBottom);
    }

    boolean forAllWindowsUnchecked(ToBooleanFunction<WindowState> callback, boolean traverseTopToBottom) {
        return super.forAllWindows(callback, traverseTopToBottom);
    }

    @Override
    AppWindowToken asAppWindowToken() {
        return this;
    }

    @Override
    boolean fillsParent() {
        return this.mFillsParent;
    }

    void setFillsParent(boolean fillsParent) {
        this.mFillsParent = fillsParent;
    }

    boolean containsDismissKeyguardWindow() {
        if (this.isRelaunching()) {
            return this.mLastContainsDismissKeyguardWindow;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if ((((WindowState)this.mChildren.get((int)i)).mAttrs.flags & 0x400000) == 0) continue;
            return true;
        }
        return false;
    }

    boolean containsShowWhenLockedWindow() {
        if (this.isRelaunching()) {
            return this.mLastContainsShowWhenLockedWindow;
        }
        for (int i = this.mChildren.size() - 1; i >= 0; --i) {
            if ((((WindowState)this.mChildren.get((int)i)).mAttrs.flags & 0x80000) == 0) continue;
            return true;
        }
        return false;
    }

    void checkKeyguardFlagsChanged() {
        boolean containsDismissKeyguard = this.containsDismissKeyguardWindow();
        boolean containsShowWhenLocked = this.containsShowWhenLockedWindow();
        if (containsDismissKeyguard != this.mLastContainsDismissKeyguardWindow || containsShowWhenLocked != this.mLastContainsShowWhenLockedWindow) {
            this.mService.notifyKeyguardFlagsChanged(null);
        }
        this.mLastContainsDismissKeyguardWindow = containsDismissKeyguard;
        this.mLastContainsShowWhenLockedWindow = containsShowWhenLocked;
    }

    WindowState getImeTargetBelowWindow(WindowState w) {
        WindowState target;
        int index = this.mChildren.indexOf(w);
        if (index > 0 && (target = (WindowState)this.mChildren.get(index - 1)).canBeImeTarget()) {
            return target;
        }
        return null;
    }

    int getLowestAnimLayer() {
        for (int i = 0; i < this.mChildren.size(); ++i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mRemoved) continue;
            return w.mWinAnimator.mAnimLayer;
        }
        return Integer.MAX_VALUE;
    }

    WindowState getHighestAnimLayerWindow(WindowState currentTarget) {
        WindowState candidate = null;
        for (int i = this.mChildren.indexOf(currentTarget); i >= 0; --i) {
            WindowState w = (WindowState)this.mChildren.get(i);
            if (w.mRemoved || candidate != null && w.mWinAnimator.mAnimLayer <= candidate.mWinAnimator.mAnimLayer) continue;
            candidate = w;
        }
        return candidate;
    }

    void setDisablePreviewScreenshots(boolean disable) {
        this.mDisablePreviewScreenshots = disable;
    }

    void setCanTurnScreenOn(boolean canTurnScreenOn) {
        this.mCanTurnScreenOn = canTurnScreenOn;
    }

    boolean canTurnScreenOn() {
        return this.mCanTurnScreenOn;
    }

    boolean shouldUseAppThemeSnapshot() {
        return this.mDisablePreviewScreenshots || this.forAllWindows((WindowState w) -> (w.mAttrs.flags & 0x2000) != 0, true);
    }

    @Override
    int getAnimLayerAdjustment() {
        return this.mAppAnimator.animLayerAdjustment;
    }

    @Override
    void dump(PrintWriter pw, String prefix) {
        super.dump(pw, prefix);
        if (this.appToken != null) {
            pw.println(prefix + "app=true mVoiceInteraction=" + this.mVoiceInteraction);
        }
        pw.print(prefix);
        pw.print("task=");
        pw.println(this.getTask());
        pw.print(prefix);
        pw.print(" mFillsParent=");
        pw.print(this.mFillsParent);
        pw.print(" mOrientation=");
        pw.println(this.mOrientation);
        pw.println(prefix + "hiddenRequested=" + this.hiddenRequested + " mClientHidden=" + this.mClientHidden + (this.mDeferHidingClient ? " mDeferHidingClient=" + this.mDeferHidingClient : "") + " reportedDrawn=" + this.reportedDrawn + " reportedVisible=" + this.reportedVisible);
        if (this.paused) {
            pw.print(prefix);
            pw.print("paused=");
            pw.println(this.paused);
        }
        if (this.mAppStopped) {
            pw.print(prefix);
            pw.print("mAppStopped=");
            pw.println(this.mAppStopped);
        }
        if (this.mNumInterestingWindows != 0 || this.mNumDrawnWindows != 0 || this.allDrawn || this.mAppAnimator.allDrawn) {
            pw.print(prefix);
            pw.print("mNumInterestingWindows=");
            pw.print(this.mNumInterestingWindows);
            pw.print(" mNumDrawnWindows=");
            pw.print(this.mNumDrawnWindows);
            pw.print(" inPendingTransaction=");
            pw.print(this.inPendingTransaction);
            pw.print(" allDrawn=");
            pw.print(this.allDrawn);
            pw.print(" (animator=");
            pw.print(this.mAppAnimator.allDrawn);
            pw.println(")");
        }
        if (this.inPendingTransaction) {
            pw.print(prefix);
            pw.print("inPendingTransaction=");
            pw.println(this.inPendingTransaction);
        }
        if (this.startingData != null || this.removed || this.firstWindowDrawn || this.mIsExiting) {
            pw.print(prefix);
            pw.print("startingData=");
            pw.print(this.startingData);
            pw.print(" removed=");
            pw.print(this.removed);
            pw.print(" firstWindowDrawn=");
            pw.print(this.firstWindowDrawn);
            pw.print(" mIsExiting=");
            pw.println(this.mIsExiting);
        }
        if (this.startingWindow != null || this.startingSurface != null || this.startingDisplayed || this.startingMoved || this.mHiddenSetFromTransferredStartingWindow) {
            pw.print(prefix);
            pw.print("startingWindow=");
            pw.print(this.startingWindow);
            pw.print(" startingSurface=");
            pw.print(this.startingSurface);
            pw.print(" startingDisplayed=");
            pw.print(this.startingDisplayed);
            pw.print(" startingMoved=");
            pw.print(this.startingMoved);
            pw.println(" mHiddenSetFromTransferredStartingWindow=" + this.mHiddenSetFromTransferredStartingWindow);
        }
        if (!this.mFrozenBounds.isEmpty()) {
            pw.print(prefix);
            pw.print("mFrozenBounds=");
            pw.println(this.mFrozenBounds);
            pw.print(prefix);
            pw.print("mFrozenMergedConfig=");
            pw.println(this.mFrozenMergedConfig);
        }
        if (this.mPendingRelaunchCount != 0) {
            pw.print(prefix);
            pw.print("mPendingRelaunchCount=");
            pw.println(this.mPendingRelaunchCount);
        }
        if (this.getController() != null) {
            pw.print(prefix);
            pw.print("controller=");
            pw.println(this.getController());
        }
        if (this.mRemovingFromDisplay) {
            pw.println(prefix + "mRemovingFromDisplay=" + this.mRemovingFromDisplay);
        }
        if (this.mAppAnimator.isAnimating()) {
            this.mAppAnimator.dump(pw, prefix + "  ");
        }
    }

    @Override
    public String toString() {
        if (this.stringName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("AppWindowToken{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" token=");
            sb.append(this.token);
            sb.append('}');
            this.stringName = sb.toString();
        }
        return this.stringName + (this.mIsExiting ? " mIsExiting=" : "");
    }
}

