/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.SoundTrigger;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionService;
import android.service.voice.IVoiceInteractionSession;
import android.service.voice.VoiceInteractionManagerInternal;
import android.service.voice.VoiceInteractionServiceInfo;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractionSessionListener;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.UiThread;
import com.android.server.soundtrigger.SoundTriggerInternal;
import com.android.server.voiceinteraction.DatabaseHelper;
import com.android.server.voiceinteraction.VoiceInteractionManagerServiceImpl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.TreeSet;

public class VoiceInteractionManagerService
extends SystemService {
    static final String TAG = "VoiceInteractionManagerService";
    static final boolean DEBUG = false;
    final Context mContext;
    final ContentResolver mResolver;
    final DatabaseHelper mDbHelper;
    final ActivityManagerInternal mAmInternal;
    final TreeSet<Integer> mLoadedKeyphraseIds;
    SoundTriggerInternal mSoundTriggerInternal;
    private final RemoteCallbackList<IVoiceInteractionSessionListener> mVoiceInteractionSessionListeners = new RemoteCallbackList();
    private final VoiceInteractionManagerServiceStub mServiceStub;

    public VoiceInteractionManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mResolver = context.getContentResolver();
        this.mDbHelper = new DatabaseHelper(context);
        this.mServiceStub = new VoiceInteractionManagerServiceStub();
        this.mAmInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mLoadedKeyphraseIds = new TreeSet();
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setVoiceInteractionPackagesProvider(new PackageManagerInternal.PackagesProvider(){

            @Override
            public String[] getPackages(int userId) {
                VoiceInteractionManagerService.this.mServiceStub.initForUser(userId);
                ComponentName interactor = VoiceInteractionManagerService.this.mServiceStub.getCurInteractor(userId);
                if (interactor != null) {
                    return new String[]{interactor.getPackageName()};
                }
                return null;
            }
        });
    }

    @Override
    public void onStart() {
        this.publishBinderService("voiceinteraction", this.mServiceStub);
        this.publishLocalService(VoiceInteractionManagerInternal.class, new LocalService());
    }

    @Override
    public void onBootPhase(int phase) {
        if (500 == phase) {
            this.mSoundTriggerInternal = LocalServices.getService(SoundTriggerInternal.class);
        } else if (phase == 600) {
            this.mServiceStub.systemRunning(this.isSafeMode());
        }
    }

    @Override
    public void onStartUser(int userHandle) {
        this.mServiceStub.initForUser(userHandle);
    }

    @Override
    public void onUnlockUser(int userHandle) {
        this.mServiceStub.initForUser(userHandle);
        this.mServiceStub.switchImplementationIfNeeded(false);
    }

    @Override
    public void onSwitchUser(int userHandle) {
        this.mServiceStub.switchUser(userHandle);
    }

    class VoiceInteractionManagerServiceStub
    extends IVoiceInteractionManagerService.Stub {
        VoiceInteractionManagerServiceImpl mImpl;
        private boolean mSafeMode;
        private int mCurUser;
        private final boolean mEnableService;
        PackageMonitor mPackageMonitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                int userHandle = UserHandle.getUserId(uid);
                ComponentName curInteractor = VoiceInteractionManagerServiceStub.this.getCurInteractor(userHandle);
                ComponentName curRecognizer = VoiceInteractionManagerServiceStub.this.getCurRecognizer(userHandle);
                boolean hit = false;
                for (String pkg : packages) {
                    if (curInteractor != null && pkg.equals(curInteractor.getPackageName())) {
                        hit = true;
                        break;
                    }
                    if (curRecognizer == null || !pkg.equals(curRecognizer.getPackageName())) continue;
                    hit = true;
                    break;
                }
                if (hit && doit) {
                    VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = VoiceInteractionManagerServiceStub.this;
                    synchronized (voiceInteractionManagerServiceStub) {
                        VoiceInteractionManagerServiceStub.this.unloadAllKeyphraseModels();
                        if (VoiceInteractionManagerServiceStub.this.mImpl != null) {
                            VoiceInteractionManagerServiceStub.this.mImpl.shutdownLocked();
                            VoiceInteractionManagerServiceStub.this.mImpl = null;
                        }
                        VoiceInteractionManagerServiceStub.this.setCurInteractor(null, userHandle);
                        VoiceInteractionManagerServiceStub.this.setCurRecognizer(null, userHandle);
                        VoiceInteractionManagerServiceStub.this.resetCurAssistant(userHandle);
                        VoiceInteractionManagerServiceStub.this.initForUser(userHandle);
                        VoiceInteractionManagerServiceStub.this.switchImplementationIfNeededLocked(true);
                    }
                }
                return hit;
            }

            @Override
            public void onHandleUserStop(Intent intent, int userHandle) {
            }

            @Override
            public void onPackageModified(String pkgName) {
                if (VoiceInteractionManagerServiceStub.this.mCurUser != this.getChangingUserId()) {
                    return;
                }
                if (this.isPackageAppearing(pkgName) != 0) {
                    return;
                }
                ComponentName curInteractor = VoiceInteractionManagerServiceStub.this.getCurInteractor(VoiceInteractionManagerServiceStub.this.mCurUser);
                if (curInteractor == null) {
                    VoiceInteractionServiceInfo availInteractorInfo = VoiceInteractionManagerServiceStub.this.findAvailInteractor(VoiceInteractionManagerServiceStub.this.mCurUser, pkgName);
                    if (availInteractorInfo != null) {
                        ComponentName availInteractor = new ComponentName(availInteractorInfo.getServiceInfo().packageName, availInteractorInfo.getServiceInfo().name);
                        VoiceInteractionManagerServiceStub.this.setCurInteractor(availInteractor, VoiceInteractionManagerServiceStub.this.mCurUser);
                        if (VoiceInteractionManagerServiceStub.this.getCurRecognizer(VoiceInteractionManagerServiceStub.this.mCurUser) == null && availInteractorInfo.getRecognitionService() != null) {
                            VoiceInteractionManagerServiceStub.this.setCurRecognizer(new ComponentName(availInteractorInfo.getServiceInfo().packageName, availInteractorInfo.getRecognitionService()), VoiceInteractionManagerServiceStub.this.mCurUser);
                        }
                    }
                } else if (this.didSomePackagesChange()) {
                    if (curInteractor != null && pkgName.equals(curInteractor.getPackageName())) {
                        VoiceInteractionManagerServiceStub.this.switchImplementationIfNeeded(true);
                    }
                } else if (curInteractor != null && this.isComponentModified(curInteractor.getClassName())) {
                    VoiceInteractionManagerServiceStub.this.switchImplementationIfNeeded(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSomePackagesChanged() {
                int userHandle = this.getChangingUserId();
                VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = VoiceInteractionManagerServiceStub.this;
                synchronized (voiceInteractionManagerServiceStub) {
                    int change;
                    ComponentName curInteractor = VoiceInteractionManagerServiceStub.this.getCurInteractor(userHandle);
                    ComponentName curRecognizer = VoiceInteractionManagerServiceStub.this.getCurRecognizer(userHandle);
                    ComponentName curAssistant = VoiceInteractionManagerServiceStub.this.getCurAssistant(userHandle);
                    if (curRecognizer == null) {
                        if (this.anyPackagesAppearing() && (curRecognizer = VoiceInteractionManagerServiceStub.this.findAvailRecognizer(null, userHandle)) != null) {
                            VoiceInteractionManagerServiceStub.this.setCurRecognizer(curRecognizer, userHandle);
                        }
                        return;
                    }
                    if (curInteractor != null) {
                        int change2 = this.isPackageDisappearing(curInteractor.getPackageName());
                        if (change2 == 3) {
                            VoiceInteractionManagerServiceStub.this.setCurInteractor(null, userHandle);
                            VoiceInteractionManagerServiceStub.this.setCurRecognizer(null, userHandle);
                            VoiceInteractionManagerServiceStub.this.resetCurAssistant(userHandle);
                            VoiceInteractionManagerServiceStub.this.initForUser(userHandle);
                            return;
                        }
                        change2 = this.isPackageAppearing(curInteractor.getPackageName());
                        if (change2 != 0 && VoiceInteractionManagerServiceStub.this.mImpl != null && curInteractor.getPackageName().equals(VoiceInteractionManagerServiceStub.this.mImpl.mComponent.getPackageName())) {
                            VoiceInteractionManagerServiceStub.this.switchImplementationIfNeededLocked(true);
                        }
                        return;
                    }
                    if (curAssistant != null && (change = this.isPackageDisappearing(curAssistant.getPackageName())) == 3) {
                        VoiceInteractionManagerServiceStub.this.setCurInteractor(null, userHandle);
                        VoiceInteractionManagerServiceStub.this.setCurRecognizer(null, userHandle);
                        VoiceInteractionManagerServiceStub.this.resetCurAssistant(userHandle);
                        VoiceInteractionManagerServiceStub.this.initForUser(userHandle);
                        return;
                    }
                    change = this.isPackageDisappearing(curRecognizer.getPackageName());
                    if (change == 3 || change == 2) {
                        VoiceInteractionManagerServiceStub.this.setCurRecognizer(VoiceInteractionManagerServiceStub.this.findAvailRecognizer(null, userHandle), userHandle);
                    } else if (this.isPackageModified(curRecognizer.getPackageName())) {
                        VoiceInteractionManagerServiceStub.this.setCurRecognizer(VoiceInteractionManagerServiceStub.this.findAvailRecognizer(curRecognizer.getPackageName(), userHandle), userHandle);
                    }
                }
            }
        };

        VoiceInteractionManagerServiceStub() {
            this.mEnableService = this.shouldEnableService(VoiceInteractionManagerService.this.mContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startLocalVoiceInteraction(final IBinder token, Bundle options) {
            if (this.mImpl == null) {
                return;
            }
            long caller = Binder.clearCallingIdentity();
            try {
                this.mImpl.showSessionLocked(options, 16, new IVoiceInteractionSessionShowCallback.Stub(){

                    @Override
                    public void onFailed() {
                    }

                    @Override
                    public void onShown() {
                        VoiceInteractionManagerService.this.mAmInternal.onLocalVoiceInteractionStarted(token, VoiceInteractionManagerServiceStub.this.mImpl.mActiveSession.mSession, VoiceInteractionManagerServiceStub.this.mImpl.mActiveSession.mInteractor);
                    }
                }, token);
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopLocalVoiceInteraction(IBinder callingActivity) {
            if (this.mImpl == null) {
                return;
            }
            long caller = Binder.clearCallingIdentity();
            try {
                this.mImpl.finishLocked(callingActivity, true);
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        public boolean supportsLocalVoiceInteraction() {
            if (this.mImpl == null) {
                return false;
            }
            return this.mImpl.supportsLocalVoiceInteraction();
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            try {
                return super.onTransact(code, data, reply, flags);
            }
            catch (RuntimeException e) {
                if (!(e instanceof SecurityException)) {
                    Slog.wtf(VoiceInteractionManagerService.TAG, "VoiceInteractionManagerService Crash", e);
                }
                throw e;
            }
        }

        public void initForUser(int userHandle) {
            String forceInteractorPackage;
            String curInteractorStr = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_interaction_service", userHandle);
            ComponentName curRecognizer = this.getCurRecognizer(userHandle);
            VoiceInteractionServiceInfo curInteractorInfo = null;
            if (curInteractorStr == null && curRecognizer != null && this.mEnableService && (curInteractorInfo = this.findAvailInteractor(userHandle, curRecognizer.getPackageName())) != null) {
                curRecognizer = null;
            }
            if ((forceInteractorPackage = this.getForceVoiceInteractionServicePackage(VoiceInteractionManagerService.this.mContext.getResources())) != null && (curInteractorInfo = this.findAvailInteractor(userHandle, forceInteractorPackage)) != null) {
                curRecognizer = null;
            }
            if (!this.mEnableService && curInteractorStr != null && !TextUtils.isEmpty(curInteractorStr)) {
                this.setCurInteractor(null, userHandle);
                curInteractorStr = "";
            }
            if (curRecognizer != null) {
                IPackageManager pm = AppGlobals.getPackageManager();
                ServiceInfo interactorInfo = null;
                ServiceInfo recognizerInfo = null;
                ComponentName curInteractor = !TextUtils.isEmpty(curInteractorStr) ? ComponentName.unflattenFromString(curInteractorStr) : null;
                try {
                    recognizerInfo = pm.getServiceInfo(curRecognizer, 786432, userHandle);
                    if (curInteractor != null) {
                        interactorInfo = pm.getServiceInfo(curInteractor, 786432, userHandle);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                if (recognizerInfo != null && (curInteractor == null || interactorInfo != null)) {
                    return;
                }
            }
            if (curInteractorInfo == null && this.mEnableService) {
                curInteractorInfo = this.findAvailInteractor(userHandle, null);
            }
            if (curInteractorInfo != null) {
                this.setCurInteractor(new ComponentName(curInteractorInfo.getServiceInfo().packageName, curInteractorInfo.getServiceInfo().name), userHandle);
                if (curInteractorInfo.getRecognitionService() != null) {
                    this.setCurRecognizer(new ComponentName(curInteractorInfo.getServiceInfo().packageName, curInteractorInfo.getRecognitionService()), userHandle);
                    return;
                }
            }
            if ((curRecognizer = this.findAvailRecognizer(null, userHandle)) != null) {
                if (curInteractorInfo == null) {
                    this.setCurInteractor(null, userHandle);
                }
                this.setCurRecognizer(curRecognizer, userHandle);
            }
        }

        private boolean shouldEnableService(Context context) {
            return !ActivityManager.isLowRamDeviceStatic() && context.getPackageManager().hasSystemFeature("android.software.voice_recognizers") || this.getForceVoiceInteractionServicePackage(context.getResources()) != null;
        }

        private String getForceVoiceInteractionServicePackage(Resources res) {
            String interactorPackage = res.getString(17039658);
            return TextUtils.isEmpty(interactorPackage) ? null : interactorPackage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void systemRunning(boolean safeMode) {
            this.mSafeMode = safeMode;
            this.mPackageMonitor.register(VoiceInteractionManagerService.this.mContext, BackgroundThread.getHandler().getLooper(), UserHandle.ALL, true);
            new SettingsObserver(UiThread.getHandler());
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                this.mCurUser = ActivityManager.getCurrentUser();
                this.switchImplementationIfNeededLocked(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void switchUser(int userHandle) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                this.mCurUser = userHandle;
                this.switchImplementationIfNeededLocked(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void switchImplementationIfNeeded(boolean force) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                this.switchImplementationIfNeededLocked(force);
            }
        }

        void switchImplementationIfNeededLocked(boolean force) {
            if (!this.mSafeMode) {
                String curService = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mResolver, "voice_interaction_service", this.mCurUser);
                ComponentName serviceComponent = null;
                ServiceInfo serviceInfo = null;
                if (curService != null && !curService.isEmpty()) {
                    try {
                        serviceComponent = ComponentName.unflattenFromString(curService);
                        serviceInfo = AppGlobals.getPackageManager().getServiceInfo(serviceComponent, 0, this.mCurUser);
                    }
                    catch (RemoteException | RuntimeException e) {
                        Slog.wtf(VoiceInteractionManagerService.TAG, "Bad voice interaction service name " + curService, e);
                        serviceComponent = null;
                        serviceInfo = null;
                    }
                }
                if (force || this.mImpl == null || this.mImpl.mUser != this.mCurUser || !this.mImpl.mComponent.equals(serviceComponent)) {
                    this.unloadAllKeyphraseModels();
                    if (this.mImpl != null) {
                        this.mImpl.shutdownLocked();
                    }
                    if (serviceComponent != null && serviceInfo != null) {
                        this.mImpl = new VoiceInteractionManagerServiceImpl(VoiceInteractionManagerService.this.mContext, UiThread.getHandler(), this, this.mCurUser, serviceComponent);
                        this.mImpl.startLocked();
                    } else {
                        this.mImpl = null;
                    }
                }
            }
        }

        VoiceInteractionServiceInfo findAvailInteractor(int userHandle, String packageName) {
            List<ResolveInfo> available = VoiceInteractionManagerService.this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent("android.service.voice.VoiceInteractionService"), 0x100C0000, userHandle);
            int numAvailable = available.size();
            if (numAvailable == 0) {
                Slog.w(VoiceInteractionManagerService.TAG, "no available voice interaction services found for user " + userHandle);
                return null;
            }
            VoiceInteractionServiceInfo foundInfo = null;
            for (int i = 0; i < numAvailable; ++i) {
                ServiceInfo cur = available.get((int)i).serviceInfo;
                if ((cur.applicationInfo.flags & 1) == 0) continue;
                ComponentName comp = new ComponentName(cur.packageName, cur.name);
                try {
                    VoiceInteractionServiceInfo info = new VoiceInteractionServiceInfo(VoiceInteractionManagerService.this.mContext.getPackageManager(), comp, userHandle);
                    if (info.getParseError() == null) {
                        if (packageName != null && !info.getServiceInfo().packageName.equals(packageName)) continue;
                        if (foundInfo == null) {
                            foundInfo = info;
                            continue;
                        }
                        Slog.w(VoiceInteractionManagerService.TAG, "More than one voice interaction service, picking first " + new ComponentName(foundInfo.getServiceInfo().packageName, foundInfo.getServiceInfo().name) + " over " + new ComponentName(cur.packageName, cur.name));
                        continue;
                    }
                    Slog.w(VoiceInteractionManagerService.TAG, "Bad interaction service " + comp + ": " + info.getParseError());
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(VoiceInteractionManagerService.TAG, "Failure looking up interaction service " + comp);
                }
            }
            return foundInfo;
        }

        ComponentName getCurInteractor(int userHandle) {
            String curInteractor = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_interaction_service", userHandle);
            if (TextUtils.isEmpty(curInteractor)) {
                return null;
            }
            return ComponentName.unflattenFromString(curInteractor);
        }

        void setCurInteractor(ComponentName comp, int userHandle) {
            Settings.Secure.putStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_interaction_service", comp != null ? comp.flattenToShortString() : "", userHandle);
        }

        ComponentName findAvailRecognizer(String prefPackage, int userHandle) {
            List<ResolveInfo> available = VoiceInteractionManagerService.this.mContext.getPackageManager().queryIntentServicesAsUser(new Intent("android.speech.RecognitionService"), 786432, userHandle);
            int numAvailable = available.size();
            if (numAvailable == 0) {
                Slog.w(VoiceInteractionManagerService.TAG, "no available voice recognition services found for user " + userHandle);
                return null;
            }
            if (prefPackage != null) {
                for (int i = 0; i < numAvailable; ++i) {
                    ServiceInfo serviceInfo = available.get((int)i).serviceInfo;
                    if (!prefPackage.equals(serviceInfo.packageName)) continue;
                    return new ComponentName(serviceInfo.packageName, serviceInfo.name);
                }
            }
            if (numAvailable > 1) {
                Slog.w(VoiceInteractionManagerService.TAG, "more than one voice recognition service found, picking first");
            }
            ServiceInfo serviceInfo = available.get((int)0).serviceInfo;
            return new ComponentName(serviceInfo.packageName, serviceInfo.name);
        }

        ComponentName getCurRecognizer(int userHandle) {
            String curRecognizer = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_recognition_service", userHandle);
            if (TextUtils.isEmpty(curRecognizer)) {
                return null;
            }
            return ComponentName.unflattenFromString(curRecognizer);
        }

        void setCurRecognizer(ComponentName comp, int userHandle) {
            Settings.Secure.putStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "voice_recognition_service", comp != null ? comp.flattenToShortString() : "", userHandle);
        }

        ComponentName getCurAssistant(int userHandle) {
            String curAssistant = Settings.Secure.getStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "assistant", userHandle);
            if (TextUtils.isEmpty(curAssistant)) {
                return null;
            }
            return ComponentName.unflattenFromString(curAssistant);
        }

        void resetCurAssistant(int userHandle) {
            Settings.Secure.putStringForUser(VoiceInteractionManagerService.this.mContext.getContentResolver(), "assistant", null, userHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showSession(IVoiceInteractionService service, Bundle args, int flags) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.showSessionLocked(args, flags, null, null);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean deliverNewSession(IBinder token, IVoiceInteractionSession session, IVoiceInteractor interactor) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                boolean bl;
                if (this.mImpl == null) {
                    throw new SecurityException("deliverNewSession without running voice interaction service");
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    bl = this.mImpl.deliverNewSessionLocked(token, session, interactor);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean showSessionFromSession(IBinder token, Bundle sessionArgs, int flags) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                boolean bl;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "showSessionFromSession without running voice interaction service");
                    return false;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    bl = this.mImpl.showSessionLocked(sessionArgs, flags, null, null);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hideSessionFromSession(IBinder token) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                boolean bl;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "hideSessionFromSession without running voice interaction service");
                    return false;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    bl = this.mImpl.hideSessionLocked();
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startVoiceActivity(IBinder token, Intent intent, String resolvedType) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int n;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "startVoiceActivity without running voice interaction service");
                    return -96;
                }
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    n = this.mImpl.startVoiceActivityLocked(callingPid, callingUid, token, intent, resolvedType);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startAssistantActivity(IBinder token, Intent intent, String resolvedType) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int n;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "startAssistantActivity without running voice interaction service");
                    return -96;
                }
                int callingPid = Binder.getCallingPid();
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    n = this.mImpl.startAssistantActivityLocked(callingPid, callingUid, token, intent, resolvedType);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setKeepAwake(IBinder token, boolean keepAwake) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "setKeepAwake without running voice interaction service");
                    return;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.setKeepAwakeLocked(token, keepAwake);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeSystemDialogs(IBinder token) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "closeSystemDialogs without running voice interaction service");
                    return;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.closeSystemDialogsLocked(token);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(IBinder token) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "finish without running voice interaction service");
                    return;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.finishLocked(token, false);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDisabledShowContext(int flags) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "setDisabledShowContext without running voice interaction service");
                    return;
                }
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.setDisabledShowContextLocked(callingUid, flags);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDisabledShowContext() {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int n;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "getDisabledShowContext without running voice interaction service");
                    return 0;
                }
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    n = this.mImpl.getDisabledShowContextLocked(callingUid);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getUserDisabledShowContext() {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int n;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "getUserDisabledShowContext without running voice interaction service");
                    return 0;
                }
                int callingUid = Binder.getCallingUid();
                long caller = Binder.clearCallingIdentity();
                try {
                    n = this.mImpl.getUserDisabledShowContextLocked(callingUid);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int keyphraseId, String bcp47Locale) {
            this.enforceCallingPermission("android.permission.MANAGE_VOICE_KEYPHRASES");
            if (bcp47Locale == null) {
                throw new IllegalArgumentException("Illegal argument(s) in getKeyphraseSoundModel");
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            try {
                SoundTrigger.KeyphraseSoundModel keyphraseSoundModel = VoiceInteractionManagerService.this.mDbHelper.getKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                return keyphraseSoundModel;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel model) {
            this.enforceCallingPermission("android.permission.MANAGE_VOICE_KEYPHRASES");
            if (model == null) {
                throw new IllegalArgumentException("Model must not be null");
            }
            long caller = Binder.clearCallingIdentity();
            try {
                if (VoiceInteractionManagerService.this.mDbHelper.updateKeyphraseSoundModel(model)) {
                    VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
                    synchronized (voiceInteractionManagerServiceStub) {
                        if (this.mImpl != null && this.mImpl.mService != null) {
                            this.mImpl.notifySoundModelsChangedLocked();
                        }
                    }
                    int n = 0;
                    return n;
                }
                int n = Integer.MIN_VALUE;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int deleteKeyphraseSoundModel(int keyphraseId, String bcp47Locale) {
            this.enforceCallingPermission("android.permission.MANAGE_VOICE_KEYPHRASES");
            if (bcp47Locale == null) {
                throw new IllegalArgumentException("Illegal argument(s) in deleteKeyphraseSoundModel");
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            boolean deleted = false;
            try {
                int unloadStatus = VoiceInteractionManagerService.this.mSoundTriggerInternal.unloadKeyphraseModel(keyphraseId);
                if (unloadStatus != 0) {
                    Slog.w(VoiceInteractionManagerService.TAG, "Unable to unload keyphrase sound model:" + unloadStatus);
                }
                int n = (deleted = VoiceInteractionManagerService.this.mDbHelper.deleteKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale)) ? 0 : Integer.MIN_VALUE;
                return n;
            }
            finally {
                if (deleted) {
                    VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
                    synchronized (voiceInteractionManagerServiceStub) {
                        if (this.mImpl != null && this.mImpl.mService != null) {
                            this.mImpl.notifySoundModelsChangedLocked();
                        }
                        VoiceInteractionManagerService.this.mLoadedKeyphraseIds.remove(keyphraseId);
                    }
                }
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEnrolledForKeyphrase(IVoiceInteractionService service, int keyphraseId, String bcp47Locale) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
            }
            if (bcp47Locale == null) {
                throw new IllegalArgumentException("Illegal argument(s) in isEnrolledForKeyphrase");
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            try {
                SoundTrigger.KeyphraseSoundModel model = VoiceInteractionManagerService.this.mDbHelper.getKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                boolean bl = model != null;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoundTrigger.ModuleProperties getDspModuleProperties(IVoiceInteractionService service) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                SoundTrigger.ModuleProperties moduleProperties;
                if (this.mImpl == null || this.mImpl.mService == null || service == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    moduleProperties = VoiceInteractionManagerService.this.mSoundTriggerInternal.getModuleProperties();
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return moduleProperties;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startRecognition(IVoiceInteractionService service, int keyphraseId, String bcp47Locale, IRecognitionStatusCallback callback, SoundTrigger.RecognitionConfig recognitionConfig) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
                if (callback == null || recognitionConfig == null || bcp47Locale == null) {
                    throw new IllegalArgumentException("Illegal argument(s) in startRecognition");
                }
            }
            int callingUid = UserHandle.getCallingUserId();
            long caller = Binder.clearCallingIdentity();
            try {
                SoundTrigger.KeyphraseSoundModel soundModel = VoiceInteractionManagerService.this.mDbHelper.getKeyphraseSoundModel(keyphraseId, callingUid, bcp47Locale);
                if (soundModel == null || soundModel.uuid == null || soundModel.keyphrases == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "No matching sound model found in startRecognition");
                    int n = Integer.MIN_VALUE;
                    return n;
                }
                VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub2 = this;
                synchronized (voiceInteractionManagerServiceStub2) {
                    VoiceInteractionManagerService.this.mLoadedKeyphraseIds.add(keyphraseId);
                }
                int n = VoiceInteractionManagerService.this.mSoundTriggerInternal.startRecognition(keyphraseId, soundModel, callback, recognitionConfig);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int stopRecognition(IVoiceInteractionService service, int keyphraseId, IRecognitionStatusCallback callback) {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null || this.mImpl.mService == null || service == null || service.asBinder() != this.mImpl.mService.asBinder()) {
                    throw new SecurityException("Caller is not the current voice interaction service");
                }
            }
            long caller = Binder.clearCallingIdentity();
            try {
                int n = VoiceInteractionManagerService.this.mSoundTriggerInternal.stopRecognition(keyphraseId, callback);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void unloadAllKeyphraseModels() {
            for (int keyphraseId : VoiceInteractionManagerService.this.mLoadedKeyphraseIds) {
                long caller = Binder.clearCallingIdentity();
                try {
                    int status = VoiceInteractionManagerService.this.mSoundTriggerInternal.unloadKeyphraseModel(keyphraseId);
                    if (status == 0) continue;
                    Slog.w(VoiceInteractionManagerService.TAG, "Failed to unload keyphrase " + keyphraseId + ":" + status);
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
            VoiceInteractionManagerService.this.mLoadedKeyphraseIds.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ComponentName getActiveServiceComponentName() {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                return this.mImpl != null ? this.mImpl.mComponent : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean showSessionForActiveService(Bundle args, int sourceFlags, IVoiceInteractionSessionShowCallback showCallback, IBinder activityToken) {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                boolean bl;
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "showSessionForActiveService without running voice interactionservice");
                    return false;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    bl = this.mImpl.showSessionLocked(args, sourceFlags | 1 | 2, showCallback, activityToken);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(caller);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(caller);
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hideCurrentSession() throws RemoteException {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    return;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    if (this.mImpl.mActiveSession != null && this.mImpl.mActiveSession.mSession != null) {
                        try {
                            this.mImpl.mActiveSession.mSession.closeSystemDialogs();
                        }
                        catch (RemoteException e) {
                            Log.w(VoiceInteractionManagerService.TAG, "Failed to call closeSystemDialogs", e);
                        }
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void launchVoiceAssistFromKeyguard() {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    Slog.w(VoiceInteractionManagerService.TAG, "launchVoiceAssistFromKeyguard without running voice interactionservice");
                    return;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    this.mImpl.launchVoiceAssistFromKeyguard();
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSessionRunning() {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                return this.mImpl != null && this.mImpl.mActiveSession != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean activeServiceSupportsAssist() {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                return this.mImpl != null && this.mImpl.mInfo != null && this.mImpl.mInfo.getSupportsAssist();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean activeServiceSupportsLaunchFromKeyguard() throws RemoteException {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                return this.mImpl != null && this.mImpl.mInfo != null && this.mImpl.mInfo.getSupportsLaunchFromKeyguard();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLockscreenShown() {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                if (this.mImpl == null) {
                    return;
                }
                long caller = Binder.clearCallingIdentity();
                try {
                    if (this.mImpl.mActiveSession != null && this.mImpl.mActiveSession.mSession != null) {
                        try {
                            this.mImpl.mActiveSession.mSession.onLockscreenShown();
                        }
                        catch (RemoteException e) {
                            Log.w(VoiceInteractionManagerService.TAG, "Failed to call onLockscreenShown", e);
                        }
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(caller);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerVoiceInteractionSessionListener(IVoiceInteractionSessionListener listener) {
            this.enforceCallingPermission("android.permission.ACCESS_VOICE_INTERACTION_SERVICE");
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.register(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSessionShown() {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int size = VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.beginBroadcast();
                for (int i = 0; i < size; ++i) {
                    IVoiceInteractionSessionListener listener = (IVoiceInteractionSessionListener)VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.getBroadcastItem(i);
                    try {
                        listener.onVoiceSessionShown();
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.e(VoiceInteractionManagerService.TAG, "Error delivering voice interaction open event.", e);
                    }
                }
                VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.finishBroadcast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSessionHidden() {
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                int size = VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.beginBroadcast();
                for (int i = 0; i < size; ++i) {
                    IVoiceInteractionSessionListener listener = (IVoiceInteractionSessionListener)VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.getBroadcastItem(i);
                    try {
                        listener.onVoiceSessionHidden();
                        continue;
                    }
                    catch (RemoteException e) {
                        Slog.e(VoiceInteractionManagerService.TAG, "Error delivering voice interaction closed event.", e);
                    }
                }
                VoiceInteractionManagerService.this.mVoiceInteractionSessionListeners.finishBroadcast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(VoiceInteractionManagerService.this.mContext, VoiceInteractionManagerService.TAG, pw)) {
                return;
            }
            VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = this;
            synchronized (voiceInteractionManagerServiceStub) {
                pw.println("VOICE INTERACTION MANAGER (dumpsys voiceinteraction)");
                pw.println("  mEnableService: " + this.mEnableService);
                if (this.mImpl == null) {
                    pw.println("  (No active implementation)");
                    return;
                }
                this.mImpl.dumpLocked(fd, pw, args);
            }
            VoiceInteractionManagerService.this.mSoundTriggerInternal.dump(fd, pw, args);
        }

        private void enforceCallingPermission(String permission2) {
            if (VoiceInteractionManagerService.this.mContext.checkCallingOrSelfPermission(permission2) != 0) {
                throw new SecurityException("Caller does not hold the permission " + permission2);
            }
        }

        class SettingsObserver
        extends ContentObserver {
            SettingsObserver(Handler handler) {
                super(handler);
                ContentResolver resolver = VoiceInteractionManagerService.this.mContext.getContentResolver();
                resolver.registerContentObserver(Settings.Secure.getUriFor("voice_interaction_service"), false, this, -1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(boolean selfChange) {
                VoiceInteractionManagerServiceStub voiceInteractionManagerServiceStub = VoiceInteractionManagerServiceStub.this;
                synchronized (voiceInteractionManagerServiceStub) {
                    VoiceInteractionManagerServiceStub.this.switchImplementationIfNeededLocked(false);
                }
            }
        }
    }

    class LocalService
    extends VoiceInteractionManagerInternal {
        LocalService() {
        }

        @Override
        public void startLocalVoiceInteraction(IBinder callingActivity, Bundle options) {
            VoiceInteractionManagerService.this.mServiceStub.startLocalVoiceInteraction(callingActivity, options);
        }

        @Override
        public boolean supportsLocalVoiceInteraction() {
            return VoiceInteractionManagerService.this.mServiceStub.supportsLocalVoiceInteraction();
        }

        @Override
        public void stopLocalVoiceInteraction(IBinder callingActivity) {
            VoiceInteractionManagerService.this.mServiceStub.stopLocalVoiceInteraction(callingActivity);
        }
    }
}

