/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.hardware.soundtrigger.SoundTrigger;
import android.text.TextUtils;
import android.util.Slog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class DatabaseHelper
extends SQLiteOpenHelper {
    static final String TAG = "SoundModelDBHelper";
    static final boolean DBG = false;
    private static final String NAME = "sound_model.db";
    private static final int VERSION = 6;
    private static final String CREATE_TABLE_SOUND_MODEL = "CREATE TABLE sound_model(model_uuid TEXT,vendor_uuid TEXT,keyphrase_id INTEGER,type INTEGER,data BLOB,recognition_modes INTEGER,locale TEXT,hint_text TEXT,users TEXT,PRIMARY KEY (keyphrase_id,locale,users))";

    public DatabaseHelper(Context context) {
        super(context, NAME, null, 6);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE_SOUND_MODEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 4) {
            db.execSQL("DROP TABLE IF EXISTS sound_model");
            this.onCreate(db);
        } else if (oldVersion == 4) {
            Slog.d(TAG, "Adding vendor UUID column");
            db.execSQL("ALTER TABLE sound_model ADD COLUMN vendor_uuid TEXT");
            ++oldVersion;
        }
        if (oldVersion == 5) {
            String selectQuery = "SELECT * FROM sound_model";
            ArrayList<SoundModelRecord> old_records = new ArrayList<SoundModelRecord>();
            try (Cursor c = db.rawQuery(selectQuery, null);){
                if (c.moveToFirst()) {
                    do {
                        try {
                            old_records.add(new SoundModelRecord(5, c));
                        }
                        catch (Exception e) {
                            Slog.e(TAG, "Failed to extract V5 record", e);
                        }
                    } while (c.moveToNext());
                }
            }
            db.execSQL("DROP TABLE IF EXISTS sound_model");
            this.onCreate(db);
            for (SoundModelRecord record : old_records) {
                if (!record.ifViolatesV6PrimaryKeyIsFirstOfAnyDuplicates(old_records)) continue;
                try {
                    long return_value = record.writeToDatabase(6, db);
                    if (return_value != -1L) continue;
                    Slog.e(TAG, "Database write failed " + record.modelUuid + ": " + return_value);
                }
                catch (Exception e) {
                    Slog.e(TAG, "Failed to update V6 record " + record.modelUuid, e);
                }
            }
            ++oldVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateKeyphraseSoundModel(SoundTrigger.KeyphraseSoundModel soundModel) {
        DatabaseHelper databaseHelper = this;
        synchronized (databaseHelper) {
            boolean bl;
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues values = new ContentValues();
            values.put("model_uuid", soundModel.uuid.toString());
            if (soundModel.vendorUuid != null) {
                values.put("vendor_uuid", soundModel.vendorUuid.toString());
            }
            values.put("type", 0);
            values.put("data", soundModel.data);
            if (soundModel.keyphrases == null || soundModel.keyphrases.length != 1) return false;
            values.put("keyphrase_id", soundModel.keyphrases[0].id);
            values.put("recognition_modes", soundModel.keyphrases[0].recognitionModes);
            values.put("users", DatabaseHelper.getCommaSeparatedString(soundModel.keyphrases[0].users));
            values.put("locale", soundModel.keyphrases[0].locale);
            values.put("hint_text", soundModel.keyphrases[0].text);
            try {
                bl = db.insertWithOnConflict("sound_model", null, values, 5) != -1L;
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteKeyphraseSoundModel(int keyphraseId, int userHandle, String bcp47Locale) {
        bcp47Locale = Locale.forLanguageTag(bcp47Locale).toLanguageTag();
        DatabaseHelper databaseHelper = this;
        synchronized (databaseHelper) {
            boolean bl;
            SoundTrigger.KeyphraseSoundModel soundModel = this.getKeyphraseSoundModel(keyphraseId, userHandle, bcp47Locale);
            if (soundModel == null) {
                return false;
            }
            SQLiteDatabase db = this.getWritableDatabase();
            String soundModelClause = "model_uuid='" + soundModel.uuid.toString() + "'";
            try {
                bl = db.delete("sound_model", soundModelClause, null) != 0;
            }
            catch (Throwable throwable) {
                db.close();
                throw throwable;
            }
            db.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SoundTrigger.KeyphraseSoundModel getKeyphraseSoundModel(int keyphraseId, int userHandle, String bcp47Locale) {
        bcp47Locale = Locale.forLanguageTag(bcp47Locale).toLanguageTag();
        DatabaseHelper databaseHelper = this;
        synchronized (databaseHelper) {
            String selectQuery = "SELECT  * FROM sound_model WHERE keyphrase_id= '" + keyphraseId + "' AND " + "locale" + "='" + bcp47Locale + "'";
            SQLiteDatabase db = this.getReadableDatabase();
            Cursor c = db.rawQuery(selectQuery, null);
            try {
                if (c.moveToFirst()) {
                    do {
                        SoundTrigger.KeyphraseSoundModel model;
                        int type;
                        if ((type = c.getInt(c.getColumnIndex("type"))) != 0) continue;
                        String modelUuid = c.getString(c.getColumnIndex("model_uuid"));
                        if (modelUuid == null) {
                            Slog.w(TAG, "Ignoring SoundModel since it doesn't specify an ID");
                            continue;
                        }
                        String vendorUuidString = null;
                        int vendorUuidColumn = c.getColumnIndex("vendor_uuid");
                        if (vendorUuidColumn != -1) {
                            vendorUuidString = c.getString(vendorUuidColumn);
                        }
                        byte[] data = c.getBlob(c.getColumnIndex("data"));
                        int recognitionModes = c.getInt(c.getColumnIndex("recognition_modes"));
                        int[] users = DatabaseHelper.getArrayForCommaSeparatedString(c.getString(c.getColumnIndex("users")));
                        String modelLocale = c.getString(c.getColumnIndex("locale"));
                        String text = c.getString(c.getColumnIndex("hint_text"));
                        if (users == null) {
                            Slog.w(TAG, "Ignoring SoundModel since it doesn't specify users");
                            continue;
                        }
                        boolean isAvailableForCurrentUser = false;
                        for (int user : users) {
                            if (userHandle != user) continue;
                            isAvailableForCurrentUser = true;
                            break;
                        }
                        if (!isAvailableForCurrentUser) continue;
                        SoundTrigger.Keyphrase[] keyphrases = new SoundTrigger.Keyphrase[]{new SoundTrigger.Keyphrase(keyphraseId, recognitionModes, modelLocale, text, users)};
                        UUID vendorUuid = null;
                        if (vendorUuidString != null) {
                            vendorUuid = UUID.fromString(vendorUuidString);
                        }
                        SoundTrigger.KeyphraseSoundModel keyphraseSoundModel = model = new SoundTrigger.KeyphraseSoundModel(UUID.fromString(modelUuid), vendorUuid, data, keyphrases);
                        return keyphraseSoundModel;
                    } while (c.moveToNext());
                }
                Slog.w(TAG, "No SoundModel available for the given keyphrase");
            }
            finally {
                c.close();
                db.close();
            }
            return null;
        }
    }

    private static String getCommaSeparatedString(int[] users) {
        if (users == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < users.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(users[i]);
        }
        return sb.toString();
    }

    private static int[] getArrayForCommaSeparatedString(String text) {
        if (TextUtils.isEmpty(text)) {
            return null;
        }
        String[] usersStr = text.split(",");
        int[] users = new int[usersStr.length];
        for (int i = 0; i < usersStr.length; ++i) {
            users[i] = Integer.parseInt(usersStr[i]);
        }
        return users;
    }

    private static class SoundModelRecord {
        public final String modelUuid;
        public final String vendorUuid;
        public final int keyphraseId;
        public final int type;
        public final byte[] data;
        public final int recognitionModes;
        public final String locale;
        public final String hintText;
        public final String users;

        public SoundModelRecord(int version, Cursor c) {
            this.modelUuid = c.getString(c.getColumnIndex("model_uuid"));
            this.vendorUuid = version >= 5 ? c.getString(c.getColumnIndex("vendor_uuid")) : null;
            this.keyphraseId = c.getInt(c.getColumnIndex("keyphrase_id"));
            this.type = c.getInt(c.getColumnIndex("type"));
            this.data = c.getBlob(c.getColumnIndex("data"));
            this.recognitionModes = c.getInt(c.getColumnIndex("recognition_modes"));
            this.locale = c.getString(c.getColumnIndex("locale"));
            this.hintText = c.getString(c.getColumnIndex("hint_text"));
            this.users = c.getString(c.getColumnIndex("users"));
        }

        private boolean V6PrimaryKeyMatches(SoundModelRecord record) {
            return this.keyphraseId == record.keyphraseId && SoundModelRecord.stringComparisonHelper(this.locale, record.locale) && SoundModelRecord.stringComparisonHelper(this.users, record.users);
        }

        public boolean ifViolatesV6PrimaryKeyIsFirstOfAnyDuplicates(List<SoundModelRecord> records) {
            for (SoundModelRecord record : records) {
                if (this == record || !this.V6PrimaryKeyMatches(record) || Arrays.equals(this.data, record.data)) continue;
                return false;
            }
            for (SoundModelRecord record : records) {
                if (!this.V6PrimaryKeyMatches(record)) continue;
                return this == record;
            }
            return true;
        }

        public long writeToDatabase(int version, SQLiteDatabase db) {
            ContentValues values = new ContentValues();
            values.put("model_uuid", this.modelUuid);
            if (version >= 5) {
                values.put("vendor_uuid", this.vendorUuid);
            }
            values.put("keyphrase_id", this.keyphraseId);
            values.put("type", this.type);
            values.put("data", this.data);
            values.put("recognition_modes", this.recognitionModes);
            values.put("locale", this.locale);
            values.put("hint_text", this.hintText);
            values.put("users", this.users);
            return db.insertWithOnConflict("sound_model", null, values, 5);
        }

        private static boolean stringComparisonHelper(String a, String b) {
            if (a != null) {
                return a.equals(b);
            }
            return a == b;
        }
    }

    public static interface SoundModelContract {
        public static final String TABLE = "sound_model";
        public static final String KEY_MODEL_UUID = "model_uuid";
        public static final String KEY_VENDOR_UUID = "vendor_uuid";
        public static final String KEY_KEYPHRASE_ID = "keyphrase_id";
        public static final String KEY_TYPE = "type";
        public static final String KEY_DATA = "data";
        public static final String KEY_RECOGNITION_MODES = "recognition_modes";
        public static final String KEY_LOCALE = "locale";
        public static final String KEY_HINT_TEXT = "hint_text";
        public static final String KEY_USERS = "users";
    }
}

